/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.xml;

import com.sun.xml.internal.org.jvnet.staxex.Base64Data;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamReaderEx;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamWriterEx;
import com.sun.xml.internal.ws.streaming.MtomStreamWriter;
import java.io.IOException;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamReaderToXMLStreamWriter {
    private static final int BUF_SIZE = 4096;
    protected XMLStreamReader in;
    protected XMLStreamWriter out;
    private char[] buf;
    boolean optimizeBase64Data = false;
    AttachmentMarshaller mtomAttachmentMarshaller;

    public void bridge(XMLStreamReader xMLStreamReader, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        assert (xMLStreamReader != null && xMLStreamWriter != null);
        this.in = xMLStreamReader;
        this.out = xMLStreamWriter;
        this.optimizeBase64Data = xMLStreamReader instanceof XMLStreamReaderEx;
        if (xMLStreamWriter instanceof XMLStreamWriterEx && xMLStreamWriter instanceof MtomStreamWriter) {
            this.mtomAttachmentMarshaller = ((MtomStreamWriter)((Object)xMLStreamWriter)).getAttachmentMarshaller();
        }
        int n = 0;
        this.buf = new char[4096];
        int n2 = xMLStreamReader.getEventType();
        if (n2 == 7) {
            while (!xMLStreamReader.isStartElement()) {
                n2 = xMLStreamReader.next();
                if (n2 != 5) continue;
                this.handleComment();
            }
        }
        if (n2 != 1) {
            throw new IllegalStateException("The current event is not START_ELEMENT\n but " + n2);
        }
        do {
            switch (n2) {
                case 1: {
                    ++n;
                    this.handleStartElement();
                    break;
                }
                case 2: {
                    this.handleEndElement();
                    if (--n != 0) break;
                    return;
                }
                case 4: {
                    this.handleCharacters();
                    break;
                }
                case 9: {
                    this.handleEntityReference();
                    break;
                }
                case 3: {
                    this.handlePI();
                    break;
                }
                case 5: {
                    this.handleComment();
                    break;
                }
                case 11: {
                    this.handleDTD();
                    break;
                }
                case 12: {
                    this.handleCDATA();
                    break;
                }
                case 6: {
                    this.handleSpace();
                    break;
                }
                case 8: {
                    throw new XMLStreamException("Malformed XML at depth=" + n + ", Reached EOF. Event=" + n2);
                }
                default: {
                    throw new XMLStreamException("Cannot process event: " + n2);
                }
            }
            n2 = xMLStreamReader.next();
        } while (n != 0);
    }

    protected void handlePI() throws XMLStreamException {
        this.out.writeProcessingInstruction(this.in.getPITarget(), this.in.getPIData());
    }

    protected void handleCharacters() throws XMLStreamException {
        CharSequence charSequence = null;
        if (this.optimizeBase64Data) {
            charSequence = ((XMLStreamReaderEx)this.in).getPCDATA();
        }
        if (charSequence != null && charSequence instanceof Base64Data) {
            if (this.mtomAttachmentMarshaller != null) {
                Base64Data base64Data = (Base64Data)charSequence;
                ((XMLStreamWriterEx)this.out).writeBinary(base64Data.getDataHandler());
            } else {
                try {
                    ((Base64Data)charSequence).writeTo(this.out);
                }
                catch (IOException iOException) {
                    throw new XMLStreamException(iOException);
                }
            }
        } else {
            int n = 0;
            int n2 = this.buf.length;
            while (n2 == this.buf.length) {
                n2 = this.in.getTextCharacters(n, this.buf, 0, this.buf.length);
                this.out.writeCharacters(this.buf, 0, n2);
                n += this.buf.length;
            }
        }
    }

    protected void handleEndElement() throws XMLStreamException {
        this.out.writeEndElement();
    }

    protected void handleStartElement() throws XMLStreamException {
        int n;
        String string = this.in.getNamespaceURI();
        if (string == null) {
            this.out.writeStartElement(this.in.getLocalName());
        } else {
            this.out.writeStartElement(XMLStreamReaderToXMLStreamWriter.fixNull(this.in.getPrefix()), this.in.getLocalName(), string);
        }
        int n2 = this.in.getNamespaceCount();
        for (n = 0; n < n2; ++n) {
            this.out.writeNamespace(this.in.getNamespacePrefix(n), XMLStreamReaderToXMLStreamWriter.fixNull(this.in.getNamespaceURI(n)));
        }
        n = this.in.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            this.handleAttribute(i);
        }
    }

    protected void handleAttribute(int n) throws XMLStreamException {
        String string = this.in.getAttributeNamespace(n);
        String string2 = this.in.getAttributePrefix(n);
        if (XMLStreamReaderToXMLStreamWriter.fixNull(string).equals("http://www.w3.org/2000/xmlns/")) {
            return;
        }
        if (string == null || string2 == null || string2.equals("")) {
            this.out.writeAttribute(this.in.getAttributeLocalName(n), this.in.getAttributeValue(n));
        } else {
            this.out.writeAttribute(string2, string, this.in.getAttributeLocalName(n), this.in.getAttributeValue(n));
        }
    }

    protected void handleDTD() throws XMLStreamException {
        this.out.writeDTD(this.in.getText());
    }

    protected void handleComment() throws XMLStreamException {
        this.out.writeComment(this.in.getText());
    }

    protected void handleEntityReference() throws XMLStreamException {
        this.out.writeEntityRef(this.in.getText());
    }

    protected void handleSpace() throws XMLStreamException {
        this.handleCharacters();
    }

    protected void handleCDATA() throws XMLStreamException {
        this.out.writeCData(this.in.getText());
    }

    private static String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

