/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

class InMemoryCookieStore
implements CookieStore {
    private List<HttpCookie> cookieJar = new ArrayList<HttpCookie>();
    private Map<String, List<HttpCookie>> domainIndex = new HashMap<String, List<HttpCookie>>();
    private Map<URI, List<HttpCookie>> uriIndex = new HashMap<URI, List<HttpCookie>>();
    private ReentrantLock lock = new ReentrantLock(false);

    @Override
    public void add(URI uRI, HttpCookie httpCookie) {
        if (httpCookie == null) {
            throw new NullPointerException("cookie is null");
        }
        this.lock.lock();
        try {
            this.cookieJar.remove(httpCookie);
            if (httpCookie.getMaxAge() != 0L) {
                this.cookieJar.add(httpCookie);
                if (httpCookie.getDomain() != null) {
                    this.addIndex(this.domainIndex, httpCookie.getDomain(), httpCookie);
                }
                if (uRI != null) {
                    this.addIndex(this.uriIndex, this.getEffectiveURI(uRI), httpCookie);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpCookie> get(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri is null");
        }
        ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        boolean bl = "https".equalsIgnoreCase(uRI.getScheme());
        this.lock.lock();
        try {
            this.getInternal1(arrayList, this.domainIndex, uRI.getHost(), bl);
            this.getInternal2(arrayList, this.uriIndex, this.getEffectiveURI(uRI), bl);
        }
        finally {
            this.lock.unlock();
        }
        return arrayList;
    }

    @Override
    public List<HttpCookie> getCookies() {
        List<HttpCookie> list;
        this.lock.lock();
        try {
            Iterator<HttpCookie> iterator = this.cookieJar.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().hasExpired()) continue;
                iterator.remove();
            }
        }
        finally {
            list = Collections.unmodifiableList(this.cookieJar);
            this.lock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<URI> getURIs() {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        this.lock.lock();
        try {
            Iterator<URI> iterator = this.uriIndex.keySet().iterator();
            while (iterator.hasNext()) {
                URI uRI = iterator.next();
                List<HttpCookie> list = this.uriIndex.get(uRI);
                if (list != null && list.size() != 0) continue;
                iterator.remove();
            }
        }
        finally {
            arrayList.addAll(this.uriIndex.keySet());
            this.lock.unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(URI uRI, HttpCookie httpCookie) {
        if (httpCookie == null) {
            throw new NullPointerException("cookie is null");
        }
        boolean bl = false;
        this.lock.lock();
        try {
            bl = this.cookieJar.remove(httpCookie);
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    @Override
    public boolean removeAll() {
        this.lock.lock();
        try {
            if (this.cookieJar.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.cookieJar.clear();
            this.domainIndex.clear();
            this.uriIndex.clear();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    private boolean netscapeDomainMatches(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        boolean bl = ".local".equalsIgnoreCase(string);
        int n = string.indexOf(46);
        if (n == 0) {
            n = string.indexOf(46, 1);
        }
        if (!(bl || n != -1 && n != string.length() - 1)) {
            return false;
        }
        int n2 = string2.indexOf(46);
        if (n2 == -1 && bl) {
            return true;
        }
        int n3 = string.length();
        int n4 = string2.length() - n3;
        if (n4 == 0) {
            return string2.equalsIgnoreCase(string);
        }
        if (n4 > 0) {
            String string3 = string2.substring(0, n4);
            String string4 = string2.substring(n4);
            return string4.equalsIgnoreCase(string);
        }
        if (n4 == -1) {
            return string.charAt(0) == '.' && string2.equalsIgnoreCase(string.substring(1));
        }
        return false;
    }

    private void getInternal1(List<HttpCookie> list, Map<String, List<HttpCookie>> map, String string, boolean bl) {
        ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        for (Map.Entry<String, List<HttpCookie>> entry : map.entrySet()) {
            String string2 = entry.getKey();
            List<HttpCookie> list2 = entry.getValue();
            for (HttpCookie httpCookie : list2) {
                if ((httpCookie.getVersion() != 0 || !this.netscapeDomainMatches(string2, string)) && (httpCookie.getVersion() != 1 || !HttpCookie.domainMatches(string2, string))) continue;
                if (this.cookieJar.indexOf(httpCookie) != -1) {
                    if (!httpCookie.hasExpired()) {
                        if (!bl && httpCookie.getSecure() || list.contains(httpCookie)) continue;
                        list.add(httpCookie);
                        continue;
                    }
                    arrayList.add(httpCookie);
                    continue;
                }
                arrayList.add(httpCookie);
            }
            for (HttpCookie httpCookie : arrayList) {
                list2.remove(httpCookie);
                this.cookieJar.remove(httpCookie);
            }
            arrayList.clear();
        }
    }

    private <T> void getInternal2(List<HttpCookie> list, Map<T, List<HttpCookie>> map, Comparable<T> comparable, boolean bl) {
        for (T t : map.keySet()) {
            List<HttpCookie> list2;
            if (comparable.compareTo(t) != 0 || (list2 = map.get(t)) == null) continue;
            Iterator<HttpCookie> iterator = list2.iterator();
            while (iterator.hasNext()) {
                HttpCookie httpCookie = iterator.next();
                if (this.cookieJar.indexOf(httpCookie) != -1) {
                    if (!httpCookie.hasExpired()) {
                        if (!bl && httpCookie.getSecure() || list.contains(httpCookie)) continue;
                        list.add(httpCookie);
                        continue;
                    }
                    iterator.remove();
                    this.cookieJar.remove(httpCookie);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private <T> void addIndex(Map<T, List<HttpCookie>> map, T t, HttpCookie httpCookie) {
        if (t != null) {
            List<HttpCookie> list = map.get(t);
            if (list != null) {
                list.remove(httpCookie);
                list.add(httpCookie);
            } else {
                list = new ArrayList<HttpCookie>();
                list.add(httpCookie);
                map.put(t, list);
            }
        }
    }

    private URI getEffectiveURI(URI uRI) {
        URI uRI2 = null;
        try {
            uRI2 = new URI("http", uRI.getHost(), null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI2 = uRI;
        }
        return uRI2;
    }
}

