#include <Wire.h>
 
#define HDC1000_ADDRESS 0x40
#define HDC1000_RDY_PIN 2
  
#define HDC1000_TEMPERATURE_POINTER     0x00
#define HDC1000_HUMIDITY_POINTER        0x01
#define HDC1000_CONFIGURATION_POINTER   0x02
#define HDC1000_SERIAL_ID1_POINTER      0xfb
#define HDC1000_SERIAL_ID2_POINTER      0xfc
#define HDC1000_SERIAL_ID3_POINTER      0xfd
#define HDC1000_MANUFACTURER_ID_POINTER 0xfe
 
#define HDC1000_CONFIGURE_MSB 0x10 /* Get both temperature and humidity */
#define HDC1000_CONFIGURE_LSB 0x00 /* 14 bit resolution */
 
void getTemperatureAndHumidity(float *temperature, float *humidity) {
  unsigned int tData, hData;
  
  Wire.beginTransmission(HDC1000_ADDRESS);
  Wire.write(HDC1000_TEMPERATURE_POINTER);
  Wire.endTransmission();
  while (digitalRead(HDC1000_RDY_PIN) == HIGH);
  Wire.requestFrom(HDC1000_ADDRESS, 4);
  while (Wire.available() < 4);
  
  tData = Wire.read() << 8;
  tData |= Wire.read();
  
  hData = Wire.read() << 8;
  hData |= Wire.read();
  
  *temperature = tData / 65536.0 * 165.0 - 40.0;
  *humidity = hData / 65536.0 * 100.0;
}
 
//*********************************************************
void setup() 
{
 
  //Initialize Serial and I2C communications
  Serial.begin(9600);
  Wire.begin();
  pinMode(HDC1000_RDY_PIN, INPUT);
   
  //Put the HDC1000 IC into the correct operating mode
  Wire.beginTransmission(HDC1000_ADDRESS);
  Wire.write(HDC1000_CONFIGURATION_POINTER);
  Wire.write(HDC1000_CONFIGURE_MSB);
  Wire.write(HDC1000_CONFIGURE_LSB);
  Wire.endTransmission();
 
}
//------------------------------------------------------
void loop() 
{
  float temperature, humidity;
  
  getTemperatureAndHumidity(&temperature, &humidity);
  Serial.print("Temperature = ");
  Serial.print(temperature);
  Serial.print(" degree, Humidity = ");
  Serial.print(humidity);
  Serial.println("%");
  Serial.flush();
  
  delay(1000);
 
}