// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file HelloWorld.h
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifndef _HelloWorld_H_
#define _HelloWorld_H_

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <micrortps/client/xrce_client.h>

/*!
 * @brief This class represents the structure HelloWorld defined by the user in the IDL file.
 * @ingroup HELLOWORLD
 */
typedef struct HelloWorld
{
    uint32_t index;
    char* message;

} HelloWorld;

static bool serialize_HelloWorld_topic(MicroBuffer* writer, const HelloWorld* topic)
{
    serialize_uint32_t(writer, topic->index);
    serialize_sequence_char(writer, topic->message, (uint32_t)(strlen(topic->message) + 1));

    return writer->error == BUFFER_OK;
}

static bool deserialize_HelloWorld_topic(MicroBuffer* reader, HelloWorld* topic)
{
    deserialize_uint32_t(reader, &topic->index);
    uint32_t size_message = 0;
    deserialize_sequence_char(reader, &topic->message, &size_message);

    return reader->error == BUFFER_OK;
}

static uint32_t size_of_HelloWorld_topic(const HelloWorld* topic)
{
    uint32_t size = 0;

    size += 4 + get_alignment(size, 4);
    size += 4 + get_alignment(size, 4) + (uint32_t)(strlen(topic->message) + 1);

    return size;
}

static bool write_HelloWorld(Session* session, ObjectId datawriter_id, StreamId stream_id, HelloWorld* topic)
{
    if (session == NULL)
    {
        return false;
    }

    bool result = false;
    uint32_t topic_size = size_of_HelloWorld_topic(topic);
    MicroBuffer* topic_buffer = NULL;

    if (128 > stream_id)
    {
        topic_buffer = prepare_best_effort_stream_for_topic(&session->output_best_effort_stream, datawriter_id, (uint16_t)topic_size);
    }
    else
    {
        topic_buffer = prepare_reliable_stream_for_topic(&session->output_reliable_stream, datawriter_id, (uint16_t)topic_size);
    }

    if (topic_buffer != NULL)
    {
        result = serialize_HelloWorld_topic(topic_buffer, topic);
    }

    return result;
}

#endif // _HelloWorld_H_
