;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text

; +9 code bytes, speeds up rotations of 16+ bits (while slightly slowing -16 ones)
;#define COMPROMISE

; bit rotations (left/right)
; input/output in BC(high):AX(low) registers
; E contains on entry the number of bit positions to rotate

; right rotation implemented in terms of left rotation (more efficient on RL78)
START_FUNC ___rotrsi3

    xor   r_4, #31
    inc   e
    and   r_4, #31
    ; fall-through

START_ANOTHER_FUNC ___rotlsi3

#ifdef COMPROMISE
    cmp   r_4, #16
    bc    $2f
    sub   r_4, #16
    xchw  ax, bc
#endif

2:  cmp0  r_4
    bz    $1f

0:  shlw  ax, 1
    rolwc bc, 1
    mov1  r_0.0, CY

    dec   e
    bnz   $0b

1:  ret

END_ANOTHER_FUNC ___rotlsi3

END_FUNC ___rotrsi3
