#ifndef _MICRORTPS_DEMO_CONFIG_H_
#define _MICRORTPS_DEMO_CONFIG_H_

/* Allows to select which of examples to run.
 * 0 = Run Publisher demo
 * 1 = Run Subscriber demo*/
#define demoConfigMICRORTPS_SELECT_RUNNER             1

#if (demoConfigMICRORTPS_SELECT_RUNNER == 0)
#define demoConfigMICRORTPS_SELECT_PUBLISHER
#elif (demoConfigMICRORTPS_SELECT_RUNNER == 1)
#define demoConfigMICRORTPS_SELECT_SUBSCRIBER
#else
#error "demoConfigMICRORTPS_SELECT_RUNNER must be set to 0 or 1 in micrortps_demo_config.h"
#endif

/* Micro RTPS client mode configuration.
 * 0 = Use UDP connection
 * 1 = Use Serial connection */
#define demoConfigMICRORTPS_SELECT_MODE               0

#if (demoConfigMICRORTPS_SELECT_MODE == 0)
#define demoConfigMICRORTPS_USE_UDP
#elif (demoConfigMICRORTPS_SELECT_MODE == 1)
#define demoConfigMICRORTPS_USE_SERIAL
#else
#error "demoConfigMICRORTPS_SELECT_MODE must be set to 0 or 1 in micrortps_demo_config.h"
#endif

/* Micro RTPS client stream configuration.
 * STREAMID_BUILTIN_RELIABLE     = Use RELIABLE Stream
 * STREAMID_BUILTIN_BEST_EFFORTS = Use Best effort Stream */
#define democonfigMICRORTPS_SELECT_STREAM             STREAMID_BUILTIN_BEST_EFFORTS

/* Micro RTPS agent IP address configuration. */
#define democonfigMICRORTPS_AGENT_ADDR0               192
#define democonfigMICRORTPS_AGENT_ADDR1               168
#define democonfigMICRORTPS_AGENT_ADDR2               1
#define democonfigMICRORTPS_AGENT_ADDR3               101

/* Micro RTPS agent port configuration. */
#define democonfigMICRORTPS_AGENT_PORT                2020

/* HelloWorldTopic ID */
#define HELLO_WORLD_TOPIC                             0x01

/* Micro RTPS client Publisher task parameters. */
#define democonfigMICRORTPS_PUB_TASK_STACK_SIZE         ( configMINIMAL_STACK_SIZE * 80 )
#define democonfigMICRORTPS_PUB_TASK_PRIORITY           ( configMAX_PRIORITIES - 4 )
#define democonfigMICRORTPS_PUB_TASK_DELAY              ( 1000 )

/* Micro RTPS client Subscriber task parameters. */
#define democonfigMICRORTPS_SUB_TASK_STACK_SIZE         ( configMINIMAL_STACK_SIZE * 80 )
#define democonfigMICRORTPS_SUB_TASK_PRIORITY           ( configMAX_PRIORITIES - 4 )
#define democonfigMICRORTPS_SUB_TASK_DELAY              ( 100 )

#endif /* _MICRORTPS_DEMO_CONFIG_H_ */
