#include <Arduino.h>
#include <Wire.h>
extern "C" {
#include "FreeRTOS.h"
#include "task.h"
}

#define IMU_ADR 0x68
const int MPU_addr = 0x68;  // I2C address of the MPU-6050
int16_t AcX, AcY, AcZ, Tmp, GyX, GyY, GyZ;

void loop2(void *pvParameters); // sensing Ac/Gy

void setup() {
	// LEDs
	pinMode(PIN_LED0, OUTPUT);
	pinMode(PIN_LED1, OUTPUT);

	// Acceleration / Gyro sensor
	Wire2.begin();
	Wire2.beginTransmission(MPU_addr);
	Wire2.write(0x6B);  // PWR_MGMT_1 register
	Wire2.write(0);     // set to zero (wakes up the MPU-6050)
	Wire2.endTransmission(true);

	// serial output to USB
	Serial.begin(9600);

	// loop2 task creation for sensing
	xTaskCreate(loop2, "LOOP2", 512, NULL, 2, NULL);
}

void loop() {
	digitalWrite(PIN_LED0, !digitalRead(PIN_LED0));
	Serial.println("loop comes");
	vTaskDelay(100);
}

void loop2(void *pvParameters) {
	while (1) {
		digitalWrite(PIN_LED1, !digitalRead(PIN_LED1));
		Wire2.beginTransmission(MPU_addr);
		Wire2.write(0x3B);  // starting with register 0x3B (ACCEL_XOUT_H)
		Wire2.endTransmission(false);
		Wire2.requestFrom(MPU_addr, 14, true); // request a total of 14 registers
		AcX = Wire2.read() << 8 | Wire2.read(); // 0x3B (ACCEL_XOUT_H) & 0x3C (ACCEL_XOUT_L)
		AcY = Wire2.read() << 8 | Wire2.read(); // 0x3D (ACCEL_YOUT_H) & 0x3E (ACCEL_YOUT_L)
		AcZ = Wire2.read() << 8 | Wire2.read(); // 0x3F (ACCEL_ZOUT_H) & 0x40 (ACCEL_ZOUT_L)
		Tmp = Wire2.read() << 8 | Wire2.read(); // 0x41 (TEMP_OUT_H) & 0x42 (TEMP_OUT_L)
		GyX = Wire2.read() << 8 | Wire2.read(); // 0x43 (GYRO_XOUT_H) & 0x44 (GYRO_XOUT_L)
		GyY = Wire2.read() << 8 | Wire2.read(); // 0x45 (GYRO_YOUT_H) & 0x46 (GYRO_YOUT_L)
		GyZ = Wire2.read() << 8 | Wire2.read(); // 0x47 (GYRO_ZOUT_H) & 0x48 (GYRO_ZOUT_L)
		Serial.print("AcX = ");
		Serial.print(AcX);
		Serial.print(" | AcY = ");
		Serial.print(AcY);
		Serial.print(" | AcZ = ");
		Serial.print(AcZ);
		Serial.print(" | Tmp = ");
		Serial.print(Tmp / 340.00 + 36.53); //equation for temperature in degrees C from datasheet
		Serial.print(" | GyX = ");
		Serial.print(GyX);
		Serial.print(" | GyY = ");
		Serial.print(GyY);
		Serial.print(" | GyZ = ");
		Serial.println(GyZ);
		vTaskDelay(500);
	}
}
