/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import processing.app.Base;
import processing.app.Editor;
import processing.app.tools.Tool;
import processing.core.PApplet;

public class ColorSelector
implements Tool,
DocumentListener {
    Editor editor;
    JFrame frame;
    int hue;
    int saturation;
    int brightness;
    int red;
    int green;
    int blue;
    ColorRange range;
    ColorSlider slider;
    JTextField hueField;
    JTextField saturationField;
    JTextField brightnessField;
    JTextField redField;
    JTextField greenField;
    JTextField blueField;
    JTextField hexField;
    JPanel colorPanel;
    boolean updating;
    int labelH;

    @Override
    public String getMenuTitle() {
        return "Color Selector";
    }

    @Override
    public void init(Editor editor) {
        this.editor = editor;
        this.frame = new JFrame("Color Selector");
        this.frame.getContentPane().setLayout(new BorderLayout());
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.range = new ColorRange();
        this.range.init();
        Box rangeBox = new Box(1);
        rangeBox.setAlignmentY(0.0f);
        rangeBox.setBorder(BorderFactory.createBevelBorder(1));
        rangeBox.add(this.range);
        box.add(rangeBox);
        box.add(Box.createHorizontalStrut(10));
        this.slider = new ColorSlider();
        this.slider.init();
        Box sliderBox = new Box(1);
        sliderBox.setAlignmentY(0.0f);
        sliderBox.setBorder(BorderFactory.createBevelBorder(1));
        sliderBox.add(this.slider);
        box.add(sliderBox);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.createColorFields());
        box.add(Box.createHorizontalStrut(10));
        this.frame.getContentPane().add((Component)box, "Center");
        this.frame.pack();
        this.frame.setResizable(false);
        Dimension size = this.frame.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((screen.width - size.width) / 2, (screen.height - size.height) / 2);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ColorSelector.this.frame.setVisible(false);
            }
        });
        Base.registerWindowCloseKeys(this.frame.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorSelector.this.frame.setVisible(false);
            }
        });
        Base.setIcon(this.frame);
        this.hueField.getDocument().addDocumentListener(this);
        this.saturationField.getDocument().addDocumentListener(this);
        this.brightnessField.getDocument().addDocumentListener(this);
        this.redField.getDocument().addDocumentListener(this);
        this.greenField.getDocument().addDocumentListener(this);
        this.blueField.getDocument().addDocumentListener(this);
        this.hexField.getDocument().addDocumentListener(this);
        this.hexField.setText("FFFFFF");
    }

    @Override
    public void run() {
        this.frame.setVisible(true);
        this.frame.setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.updating) {
            return;
        }
        this.updating = true;
        Document doc = e.getDocument();
        if (doc == this.hueField.getDocument()) {
            this.hue = this.bounded(this.hue, this.hueField, 359);
            this.updateRGB();
            this.updateHex();
        } else if (doc == this.saturationField.getDocument()) {
            this.saturation = this.bounded(this.saturation, this.saturationField, 99);
            this.updateRGB();
            this.updateHex();
        } else if (doc == this.brightnessField.getDocument()) {
            this.brightness = this.bounded(this.brightness, this.brightnessField, 99);
            this.updateRGB();
            this.updateHex();
        } else if (doc == this.redField.getDocument()) {
            this.red = this.bounded(this.red, this.redField, 255);
            this.updateHSB();
            this.updateHex();
        } else if (doc == this.greenField.getDocument()) {
            this.green = this.bounded(this.green, this.greenField, 255);
            this.updateHSB();
            this.updateHex();
        } else if (doc == this.blueField.getDocument()) {
            this.blue = this.bounded(this.blue, this.blueField, 255);
            this.updateHSB();
            this.updateHex();
        } else if (doc == this.hexField.getDocument()) {
            String str = this.hexField.getText();
            while (str.length() < 6) {
                str = str + "0";
            }
            if (str.length() > 6) {
                str = str.substring(0, 6);
            }
            this.updateRGB2(Integer.parseInt(str, 16));
            this.updateHSB();
        }
        this.range.redraw();
        this.slider.redraw();
        this.colorPanel.repaint();
        this.updating = false;
    }

    protected void updateRGB() {
        int rgb = Color.HSBtoRGB((float)this.hue / 359.0f, (float)this.saturation / 99.0f, (float)this.brightness / 99.0f);
        this.updateRGB2(rgb);
    }

    protected void updateRGB2(int rgb) {
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.redField.setText(String.valueOf(this.red));
        this.greenField.setText(String.valueOf(this.green));
        this.blueField.setText(String.valueOf(this.blue));
    }

    protected void updateHSB() {
        float[] hsb = new float[3];
        Color.RGBtoHSB(this.red, this.green, this.blue, hsb);
        this.hue = (int)(hsb[0] * 359.0f);
        this.saturation = (int)(hsb[1] * 99.0f);
        this.brightness = (int)(hsb[2] * 99.0f);
        this.hueField.setText(String.valueOf(this.hue));
        this.saturationField.setText(String.valueOf(this.saturation));
        this.brightnessField.setText(String.valueOf(this.brightness));
    }

    protected void updateHex() {
        this.hexField.setText(PApplet.hex(this.red, 2) + PApplet.hex(this.green, 2) + PApplet.hex(this.blue, 2));
    }

    protected int bounded(int current, final JTextField field, final int max) {
        String text = field.getText();
        if (text.length() == 0) {
            return 0;
        }
        try {
            int value = Integer.parseInt(text);
            if (value > max) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        field.setText(String.valueOf(max));
                    }
                });
                return max;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return current;
        }
    }

    protected Container createColorFields() {
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        this.colorPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(new Color(ColorSelector.this.red, ColorSelector.this.green, ColorSelector.this.blue));
                Dimension size = this.getSize();
                g.fillRect(0, 0, size.width, size.height);
            }
        };
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(1));
        Dimension dim = new Dimension(60, 40);
        this.colorPanel.setMinimumSize(dim);
        box.add(this.colorPanel);
        box.add(Box.createVerticalStrut(10));
        Box row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("H:"));
        this.hueField = new NumberField(4, false);
        row.add(this.hueField);
        row.add(new JLabel(" \u00b0"));
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(5));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("S:"));
        this.saturationField = new NumberField(4, false);
        row.add(this.saturationField);
        row.add(new JLabel(" %"));
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(5));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("B:"));
        this.brightnessField = new NumberField(4, false);
        row.add(this.brightnessField);
        row.add(new JLabel(" %"));
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(10));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("R:"));
        this.redField = new NumberField(4, false);
        row.add(this.redField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(5));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("G:"));
        this.greenField = new NumberField(4, false);
        row.add(this.greenField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(5));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("B:"));
        this.blueField = new NumberField(4, false);
        row.add(this.blueField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(10));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("#"));
        this.hexField = new NumberField(5, true);
        row.add(this.hexField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(10));
        box.add(Box.createVerticalGlue());
        return box;
    }

    protected JLabel createFixedLabel(String title) {
        JLabel label = new JLabel(title);
        if (this.labelH == 0) {
            this.labelH = label.getPreferredSize().height;
        }
        Dimension dim = new Dimension(20, this.labelH);
        label.setPreferredSize(dim);
        label.setMinimumSize(dim);
        label.setMaximumSize(dim);
        return label;
    }

    class NumberDocument
    extends PlainDocument {
        NumberField parentField;

        public NumberDocument(NumberField parentField) {
            this.parentField = parentField;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] chars = str.toCharArray();
            int charCount = 0;
            for (int i = 0; i < chars.length; ++i) {
                boolean ok = Character.isDigit(chars[i]);
                if (this.parentField.allowHex) {
                    if (chars[i] >= 'A' && chars[i] <= 'F') {
                        ok = true;
                    }
                    if (chars[i] >= 'a' && chars[i] <= 'f') {
                        ok = true;
                    }
                }
                if (!ok) continue;
                if (charCount != i) {
                    chars[charCount] = chars[i];
                }
                ++charCount;
            }
            super.insertString(offs, new String(chars, 0, charCount), a);
        }
    }

    class NumberField
    extends JTextField {
        public boolean allowHex;

        public NumberField(int cols, boolean allowHex) {
            super(cols);
            this.allowHex = allowHex;
        }

        @Override
        protected Document createDefaultModel() {
            return new NumberDocument(this);
        }

        @Override
        public Dimension getPreferredSize() {
            if (!this.allowHex) {
                return new Dimension(45, super.getPreferredSize().height);
            }
            return super.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    public class ColorSlider
    extends PApplet {
        static final int WIDE = 20;
        static final int HIGH = 256;

        @Override
        public void setup() {
            this.size(20, 256, "processing.core.PGraphics3D");
            this.colorMode(3, 255.0f, 100.0f, 100.0f);
            this.noLoop();
        }

        @Override
        public void draw() {
            if (this.g == null || this.g.pixels == null) {
                return;
            }
            if (this.width != 20 || this.height < 256) {
                return;
            }
            int index = 0;
            int sel = 255 - (int)(255.0f * ((float)ColorSelector.this.hue / 359.0f));
            for (int j = 0; j < 256; ++j) {
                int c = this.color(255 - j, 100, 100);
                if (j == sel) {
                    c = -16777216;
                }
                for (int i = 0; i < 20; ++i) {
                    this.g.pixels[index++] = c;
                }
            }
        }

        @Override
        public void mousePressed() {
            this.updateMouse();
        }

        @Override
        public void mouseDragged() {
            this.updateMouse();
        }

        public void updateMouse() {
            if (this.mouseX >= 0 && this.mouseX < 256 && this.mouseY >= 0 && this.mouseY < 256) {
                int nhue = 359 - (int)(359.0f * ((float)this.mouseY / 255.0f));
                ColorSelector.this.hueField.setText(String.valueOf(nhue));
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(20, 256);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(20, 256);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(20, 256);
        }

        @Override
        public void keyPressed() {
            if (this.key == '\u001b') {
                ColorSelector.this.frame.setVisible(false);
                this.key = '\u0000';
            }
        }
    }

    public class ColorRange
    extends PApplet {
        static final int WIDE = 256;
        static final int HIGH = 256;
        int lastX;
        int lastY;

        @Override
        public void setup() {
            this.size(256, 256, "processing.core.PGraphics3D");
            this.noLoop();
            this.colorMode(3, 360.0f, 256.0f, 256.0f);
            this.noFill();
            this.rectMode(3);
        }

        @Override
        public void draw() {
            if (this.g == null || this.g.pixels == null) {
                return;
            }
            if (this.width != 256 || this.height < 256) {
                return;
            }
            int index = 0;
            for (int j = 0; j < 256; ++j) {
                for (int i = 0; i < 256; ++i) {
                    this.g.pixels[index++] = this.color(ColorSelector.this.hue, i, 255 - j);
                }
            }
            this.stroke(ColorSelector.this.brightness > 50 ? 0 : 255);
            this.rect(this.lastX, this.lastY, 9.0f, 9.0f);
        }

        @Override
        public void mousePressed() {
            this.updateMouse();
        }

        @Override
        public void mouseDragged() {
            this.updateMouse();
        }

        public void updateMouse() {
            if (this.mouseX >= 0 && this.mouseX < 256 && this.mouseY >= 0 && this.mouseY < 256) {
                int nsaturation = (int)(100.0f * ((float)this.mouseX / 255.0f));
                int nbrightness = 100 - (int)(100.0f * ((float)this.mouseY / 255.0f));
                ColorSelector.this.saturationField.setText(String.valueOf(nsaturation));
                ColorSelector.this.brightnessField.setText(String.valueOf(nbrightness));
                this.lastX = this.mouseX;
                this.lastY = this.mouseY;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(256, 256);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(256, 256);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(256, 256);
        }

        @Override
        public void keyPressed() {
            if (this.key == '\u001b') {
                ColorSelector.this.frame.setVisible(false);
                this.key = '\u0000';
            }
        }
    }
}

