/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.tools.Tool;

public class FixEncoding
implements Tool {
    Editor editor;

    @Override
    public String getMenuTitle() {
        return I18n._("Fix Encoding & Reload");
    }

    @Override
    public void init(Editor editor) {
        this.editor = editor;
    }

    @Override
    public void run() {
        int result;
        Sketch sketch = this.editor.getSketch();
        if (sketch.isModified() && (result = JOptionPane.showConfirmDialog(this.editor, I18n._("Discard all changes and reload sketch?"), I18n._("Fix Encoding & Reload"), 0, 3)) == 1) {
            return;
        }
        try {
            for (int i = 0; i < sketch.getCodeCount(); ++i) {
                SketchCode code = sketch.getCode(i);
                code.setProgram(this.loadWithLocalEncoding(code.getFile()));
                code.setModified(true);
            }
            this.editor.setText(sketch.getCurrentCode().getProgram());
        }
        catch (IOException e) {
            String msg = I18n._("An error occurred while trying to fix the file encoding.\nDo not attempt to save this sketch as it may overwrite\nthe old version. Use Open to re-open the sketch and try again.\n") + e.getMessage();
            Base.showWarning(I18n._("Fix Encoding & Reload"), msg, e);
        }
    }

    protected String loadWithLocalEncoding(File file) throws IOException {
        FileReader fr = new FileReader(file);
        BufferedReader reader = new BufferedReader(fr);
        StringBuffer buffer = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append('\n');
        }
        reader.close();
        return buffer.toString();
    }
}

