/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static ResourceBundle i18n;
    static String PROMPT_YES;
    static String PROMPT_NO;
    static String PROMPT_CANCEL;
    static String PROMPT_OK;
    static String PROMPT_BROWSE;

    protected static void init(String language) throws MissingResourceException {
        try {
            if (language != null && language.trim().length() > 0) {
                Locale locale = new Locale(language);
                i18n = ResourceBundle.getBundle("processing.app.i18n.Resources", locale);
                Locale.setDefault(locale);
            } else {
                i18n = ResourceBundle.getBundle("processing.app.i18n.Resources", Locale.getDefault());
            }
            PROMPT_YES = I18n._("Yes");
            PROMPT_NO = I18n._("No");
            PROMPT_CANCEL = I18n._("Cancel");
            PROMPT_OK = I18n._("OK");
            PROMPT_BROWSE = I18n._("Browse");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static String _(String s) {
        String res;
        try {
            res = i18n.getString(s);
        }
        catch (MissingResourceException e) {
            res = s;
        }
        res = res.replace("%%", "%");
        return res;
    }

    public static String format(String fmt, Object ... args) {
        fmt = fmt.replace("''", "'");
        fmt = fmt.replace("'", "''");
        return MessageFormat.format(fmt, args);
    }

    protected static void unusedStrings() {
        I18n._("Arduino AVR Boards");
        I18n._("Arduino ARM (32-bits) Boards");
        I18n._("Processor");
    }
}

