/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Preferences;
import processing.core.PApplet;

public class UpdateCheck
implements Runnable {
    Base base;
    String downloadURL = I18n._("http://tool-cloud2.renesas.com/ide_ver.txt");
    static final long ONE_DAY = 86400000L;

    public UpdateCheck(Base base) {
        Thread thread = new Thread(this);
        this.base = base;
        thread.start();
    }

    @Override
    public void run() {
        Random r = new Random();
        long id = r.nextLong();
        String idString = Preferences.get("update.id");
        if (idString != null) {
            id = Long.parseLong(idString);
        } else {
            Preferences.set("update.id", String.valueOf(id));
        }
        try {
            long when;
            String info = URLEncoder.encode(id + "\t" + PApplet.nf(1100, 4) + "\t" + System.getProperty("java.version") + "\t" + System.getProperty("java.vendor") + "\t" + System.getProperty("os.name") + "\t" + System.getProperty("os.version") + "\t" + System.getProperty("os.arch"), "UTF-8");
            int latest = this.readInt(this.downloadURL + "?" + info);
            String lastString = Preferences.get("update.last");
            long now = System.currentTimeMillis();
            if (lastString != null && now - (when = Long.parseLong(lastString)) < 86400000L) {
                return;
            }
            Preferences.set("update.last", String.valueOf(now));
            String prompt = I18n._("A new version of IDE for GR is available,\nwould you like to visit the Gadget Renesas page?");
            if (this.base.activeEditor != null && latest > 1100) {
                Object[] options = new Object[]{I18n._("Yes"), I18n._("No")};
                int result = JOptionPane.showOptionDialog(this.base.activeEditor, prompt, I18n._("Update"), 0, 3, null, options, options[0]);
                if (result == 0) {
                    Base.openURL(I18n._("http://gadget.renesas.com"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int readInt(String filename) throws Exception {
        URL url = new URL(filename);
        InputStream stream = url.openStream();
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(isr);
        return Integer.parseInt(reader.readLine());
    }
}

