/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class FileUtils {
    public static boolean isSubDirectory(File base, File child) {
        try {
            base = base.getCanonicalFile();
            child = child.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        for (File parentFile = child; parentFile != null; parentFile = parentFile.getParentFile()) {
            if (!base.equals(parentFile)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(dest);
            byte[] buf = new byte[4096];
            int readBytes = -1;
            while ((readBytes = fis.read(buf, 0, buf.length)) != -1) {
                fos.write(buf, 0, readBytes);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void copy(File sourceFolder, File destFolder) throws IOException {
        for (File file : sourceFolder.listFiles()) {
            File destFile = new File(destFolder, file.getName());
            if (file.isDirectory()) {
                if (!destFile.mkdir()) {
                    throw new IOException("Unable to create folder: " + destFile);
                }
                FileUtils.copy(file, destFile);
                continue;
            }
            FileUtils.copyFile(file, destFile);
        }
    }

    public static void recursiveDelete(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            for (File current : file.listFiles()) {
                if (current.isDirectory()) {
                    FileUtils.recursiveDelete(current);
                    continue;
                }
                current.delete();
            }
        }
        file.delete();
    }

    public static File createTempFolder() throws IOException {
        File tmpFolder = new File(System.getProperty("java.io.tmpdir"), "arduino_" + new Random().nextInt(1000000));
        if (!tmpFolder.mkdir()) {
            throw new IOException("Unable to create temp folder " + tmpFolder);
        }
        return tmpFolder;
    }

    public static String relativePath(String origin, String target) {
        try {
            origin = new File(origin).getCanonicalPath();
            File targetFile = new File(target);
            target = targetFile.isAbsolute() ? targetFile.getCanonicalPath() : new File(origin, target).getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        if (origin.equals(target)) {
            return ".";
        }
        if (origin.equals(File.separator)) {
            return "." + target;
        }
        String prefix = "";
        String root = File.separator;
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            if (origin.startsWith("\\\\") || target.startsWith("\\\\")) {
                return null;
            }
            char originLetter = origin.charAt(0);
            char targetLetter = target.charAt(0);
            if (Character.isLetter(originLetter) && Character.isLetter(targetLetter) && originLetter != targetLetter) {
                return null;
            }
            prefix = "" + originLetter + ':';
            root = prefix + File.separator;
        }
        String relative = "";
        while (!target.startsWith(origin + File.separator)) {
            if ((origin = new File(origin).getParent()).equals(root)) {
                origin = prefix;
            }
            relative = relative + "..";
            relative = relative + File.separator;
        }
        return relative + target.substring(origin.length() + 1);
    }
}

