/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime;

import com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.internal.bind.marshaller.DataWriter;
import com.sun.xml.internal.bind.marshaller.DumbEscapeHandler;
import com.sun.xml.internal.bind.marshaller.MinimumEscapeHandler;
import com.sun.xml.internal.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.internal.bind.marshaller.NioEscapeHandler;
import com.sun.xml.internal.bind.marshaller.SAX2DOMEx;
import com.sun.xml.internal.bind.marshaller.XMLWriter;
import com.sun.xml.internal.bind.v2.runtime.AssociationMap;
import com.sun.xml.internal.bind.v2.runtime.DomPostInitAction;
import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.internal.bind.v2.runtime.Messages;
import com.sun.xml.internal.bind.v2.runtime.Name;
import com.sun.xml.internal.bind.v2.runtime.StAXPostInitAction;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.output.C14nXmlOutput;
import com.sun.xml.internal.bind.v2.runtime.output.Encoded;
import com.sun.xml.internal.bind.v2.runtime.output.ForkXmlOutput;
import com.sun.xml.internal.bind.v2.runtime.output.IndentingUTF8XmlOutput;
import com.sun.xml.internal.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.internal.bind.v2.runtime.output.SAXOutput;
import com.sun.xml.internal.bind.v2.runtime.output.UTF8XmlOutput;
import com.sun.xml.internal.bind.v2.runtime.output.XMLEventWriterOutput;
import com.sun.xml.internal.bind.v2.runtime.output.XMLStreamWriterOutput;
import com.sun.xml.internal.bind.v2.runtime.output.XmlOutput;
import com.sun.xml.internal.bind.v2.util.FatalAdapter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.helpers.AbstractMarshallerImpl;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public final class MarshallerImpl
extends AbstractMarshallerImpl
implements ValidationEventHandler {
    private String indent = "    ";
    private NamespacePrefixMapper prefixMapper = null;
    private CharacterEscapeHandler escapeHandler = null;
    private String header = null;
    final JAXBContextImpl context;
    protected final XMLSerializer serializer;
    private Schema schema;
    private Marshaller.Listener externalListener = null;
    private boolean c14nSupport;
    private Flushable toBeFlushed;
    private Closeable toBeClosed;
    protected static final String INDENT_STRING = "com.sun.xml.internal.bind.indentString";
    protected static final String PREFIX_MAPPER = "com.sun.xml.internal.bind.namespacePrefixMapper";
    protected static final String ENCODING_HANDLER = "com.sun.xml.internal.bind.characterEscapeHandler";
    protected static final String ENCODING_HANDLER2 = "com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler";
    protected static final String XMLDECLARATION = "com.sun.xml.internal.bind.xmlDeclaration";
    protected static final String XML_HEADERS = "com.sun.xml.internal.bind.xmlHeaders";
    protected static final String C14N = "com.sun.xml.internal.bind.c14n";
    protected static final String OBJECT_IDENTITY_CYCLE_DETECTION = "com.sun.xml.internal.bind.objectIdentitityCycleDetection";

    public MarshallerImpl(JAXBContextImpl jAXBContextImpl, AssociationMap associationMap) {
        this.context = jAXBContextImpl;
        this.serializer = new XMLSerializer(this);
        this.c14nSupport = this.context.c14nSupport;
        try {
            this.setEventHandler(this);
        }
        catch (JAXBException jAXBException) {
            throw new AssertionError((Object)jAXBException);
        }
    }

    public JAXBContextImpl getContext() {
        return this.context;
    }

    public void marshal(Object object, OutputStream outputStream, NamespaceContext namespaceContext) throws JAXBException {
        this.write(object, this.createWriter(outputStream), new StAXPostInitAction(namespaceContext, this.serializer));
    }

    @Override
    public void marshal(Object object, XMLStreamWriter xMLStreamWriter) throws JAXBException {
        this.write(object, XMLStreamWriterOutput.create(xMLStreamWriter, this.context), new StAXPostInitAction(xMLStreamWriter, this.serializer));
    }

    @Override
    public void marshal(Object object, XMLEventWriter xMLEventWriter) throws JAXBException {
        this.write(object, new XMLEventWriterOutput(xMLEventWriter), new StAXPostInitAction(xMLEventWriter, this.serializer));
    }

    public void marshal(Object object, XmlOutput xmlOutput) throws JAXBException {
        this.write(object, xmlOutput, null);
    }

    final XmlOutput createXmlOutput(Result result) throws JAXBException {
        if (result instanceof SAXResult) {
            return new SAXOutput(((SAXResult)result).getHandler());
        }
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)result).getNode();
            if (node == null) {
                Document document = JAXBContextImpl.createDom(this.getContext().disableSecurityProcessing);
                ((DOMResult)result).setNode(document);
                return new SAXOutput(new SAX2DOMEx(document));
            }
            return new SAXOutput(new SAX2DOMEx(node));
        }
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            if (streamResult.getWriter() != null) {
                return this.createWriter(streamResult.getWriter());
            }
            if (streamResult.getOutputStream() != null) {
                return this.createWriter(streamResult.getOutputStream());
            }
            if (streamResult.getSystemId() != null) {
                String string = streamResult.getSystemId();
                try {
                    string = new URI(string).getPath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    assert (this.toBeClosed == null);
                    this.toBeClosed = fileOutputStream;
                    return this.createWriter(fileOutputStream);
                }
                catch (IOException iOException) {
                    throw new MarshalException(iOException);
                }
            }
        }
        throw new MarshalException(Messages.UNSUPPORTED_RESULT.format(new Object[0]));
    }

    final Runnable createPostInitAction(Result result) {
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)result).getNode();
            return new DomPostInitAction(node, this.serializer);
        }
        return null;
    }

    @Override
    public void marshal(Object object, Result result) throws JAXBException {
        this.write(object, this.createXmlOutput(result), this.createPostInitAction(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> void write(Name name, JaxBeanInfo<T> jaxBeanInfo, T t, XmlOutput xmlOutput, Runnable runnable) throws JAXBException {
        try {
            try {
                this.prewrite(xmlOutput, true, runnable);
                this.serializer.startElement(name, null);
                if (jaxBeanInfo.jaxbType == Void.class || jaxBeanInfo.jaxbType == Void.TYPE) {
                    this.serializer.endNamespaceDecls(null);
                    this.serializer.endAttributes();
                } else if (t == null) {
                    this.serializer.writeXsiNilTrue();
                } else {
                    this.serializer.childAsXsiType(t, "root", jaxBeanInfo, false);
                }
                this.serializer.endElement();
                this.postwrite();
            }
            catch (SAXException sAXException) {
                throw new MarshalException(sAXException);
            }
            catch (IOException iOException) {
                throw new MarshalException(iOException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new MarshalException(xMLStreamException);
            }
            finally {
                this.serializer.close();
            }
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Object object, XmlOutput xmlOutput, Runnable runnable) throws JAXBException {
        try {
            if (object == null) {
                throw new IllegalArgumentException(Messages.NOT_MARSHALLABLE.format(new Object[0]));
            }
            if (this.schema != null) {
                ValidatorHandler validatorHandler = this.schema.newValidatorHandler();
                validatorHandler.setErrorHandler(new FatalAdapter(this.serializer));
                XMLFilterImpl xMLFilterImpl = new XMLFilterImpl(){

                    @Override
                    public void startPrefixMapping(String string, String string2) throws SAXException {
                        super.startPrefixMapping(string.intern(), string2.intern());
                    }
                };
                xMLFilterImpl.setContentHandler(validatorHandler);
                xmlOutput = new ForkXmlOutput(new SAXOutput(xMLFilterImpl){

                    @Override
                    public void startDocument(XMLSerializer xMLSerializer, boolean bl, int[] nArray, NamespaceContextImpl namespaceContextImpl) throws SAXException, IOException, XMLStreamException {
                        super.startDocument(xMLSerializer, false, nArray, namespaceContextImpl);
                    }

                    @Override
                    public void endDocument(boolean bl) throws SAXException, IOException, XMLStreamException {
                        super.endDocument(false);
                    }
                }, xmlOutput);
            }
            try {
                this.prewrite(xmlOutput, this.isFragment(), runnable);
                this.serializer.childAsRoot(object);
                this.postwrite();
            }
            catch (SAXException sAXException) {
                throw new MarshalException(sAXException);
            }
            catch (IOException iOException) {
                throw new MarshalException(iOException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new MarshalException(xMLStreamException);
            }
            finally {
                this.serializer.close();
            }
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        if (this.toBeFlushed != null) {
            try {
                this.toBeFlushed.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.toBeClosed != null) {
            try {
                this.toBeClosed.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.toBeFlushed = null;
        this.toBeClosed = null;
    }

    private void prewrite(XmlOutput xmlOutput, boolean bl, Runnable runnable) throws IOException, SAXException, XMLStreamException {
        String[] stringArray;
        this.serializer.startDocument(xmlOutput, bl, this.getSchemaLocation(), this.getNoNSSchemaLocation());
        if (runnable != null) {
            runnable.run();
        }
        if (this.prefixMapper != null && (stringArray = this.prefixMapper.getContextualNamespaceDecls()) != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                String string = stringArray[i];
                String string2 = stringArray[i + 1];
                if (string2 == null || string == null) continue;
                this.serializer.addInscopeBinding(string2, string);
            }
        }
        this.serializer.setPrefixMapper(this.prefixMapper);
    }

    private void postwrite() throws IOException, SAXException, XMLStreamException {
        this.serializer.endDocument();
        this.serializer.reconcileID();
    }

    protected CharacterEscapeHandler createEscapeHandler(String string) {
        if (this.escapeHandler != null) {
            return this.escapeHandler;
        }
        if (string.startsWith("UTF")) {
            return MinimumEscapeHandler.theInstance;
        }
        try {
            return new NioEscapeHandler(this.getJavaEncoding(string));
        }
        catch (Throwable throwable) {
            return DumbEscapeHandler.theInstance;
        }
    }

    public XmlOutput createWriter(Writer writer, String string) {
        XMLWriter xMLWriter;
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        assert (this.toBeFlushed == null);
        this.toBeFlushed = writer;
        CharacterEscapeHandler characterEscapeHandler = this.createEscapeHandler(string);
        if (this.isFormattedOutput()) {
            DataWriter dataWriter = new DataWriter(writer, string, characterEscapeHandler);
            dataWriter.setIndentStep(this.indent);
            xMLWriter = dataWriter;
        } else {
            xMLWriter = new XMLWriter(writer, string, characterEscapeHandler);
        }
        xMLWriter.setXmlDecl(!this.isFragment());
        xMLWriter.setHeader(this.header);
        return new SAXOutput(xMLWriter);
    }

    public XmlOutput createWriter(Writer writer) {
        return this.createWriter(writer, this.getEncoding());
    }

    public XmlOutput createWriter(OutputStream outputStream) throws JAXBException {
        return this.createWriter(outputStream, this.getEncoding());
    }

    public XmlOutput createWriter(OutputStream outputStream, String string) throws JAXBException {
        if (string.equals("UTF-8")) {
            Encoded[] encodedArray = this.context.getUTF8NameTable();
            UTF8XmlOutput uTF8XmlOutput = this.isFormattedOutput() ? new IndentingUTF8XmlOutput(outputStream, this.indent, encodedArray, this.escapeHandler) : (this.c14nSupport ? new C14nXmlOutput(outputStream, encodedArray, this.context.c14nSupport, this.escapeHandler) : new UTF8XmlOutput(outputStream, encodedArray, this.escapeHandler));
            if (this.header != null) {
                uTF8XmlOutput.setHeader(this.header);
            }
            return uTF8XmlOutput;
        }
        try {
            return this.createWriter(new OutputStreamWriter(outputStream, this.getJavaEncoding(string)), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MarshalException(Messages.UNSUPPORTED_ENCODING.format(string), unsupportedEncodingException);
        }
    }

    @Override
    public Object getProperty(String string) throws PropertyException {
        if (INDENT_STRING.equals(string)) {
            return this.indent;
        }
        if (ENCODING_HANDLER.equals(string) || ENCODING_HANDLER2.equals(string)) {
            return this.escapeHandler;
        }
        if (PREFIX_MAPPER.equals(string)) {
            return this.prefixMapper;
        }
        if (XMLDECLARATION.equals(string)) {
            return !this.isFragment();
        }
        if (XML_HEADERS.equals(string)) {
            return this.header;
        }
        if (C14N.equals(string)) {
            return this.c14nSupport;
        }
        if (OBJECT_IDENTITY_CYCLE_DETECTION.equals(string)) {
            return this.serializer.getObjectIdentityCycleDetection();
        }
        return super.getProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) throws PropertyException {
        if (INDENT_STRING.equals(string)) {
            this.checkString(string, object);
            this.indent = (String)object;
            return;
        }
        if (ENCODING_HANDLER.equals(string) || ENCODING_HANDLER2.equals(string)) {
            if (!(object instanceof CharacterEscapeHandler)) {
                throw new PropertyException(Messages.MUST_BE_X.format(string, CharacterEscapeHandler.class.getName(), object.getClass().getName()));
            }
            this.escapeHandler = (CharacterEscapeHandler)object;
            return;
        }
        if (PREFIX_MAPPER.equals(string)) {
            if (!(object instanceof NamespacePrefixMapper)) {
                throw new PropertyException(Messages.MUST_BE_X.format(string, NamespacePrefixMapper.class.getName(), object.getClass().getName()));
            }
            this.prefixMapper = (NamespacePrefixMapper)object;
            return;
        }
        if (XMLDECLARATION.equals(string)) {
            this.checkBoolean(string, object);
            super.setProperty("jaxb.fragment", (Boolean)object == false);
            return;
        }
        if (XML_HEADERS.equals(string)) {
            this.checkString(string, object);
            this.header = (String)object;
            return;
        }
        if (C14N.equals(string)) {
            this.checkBoolean(string, object);
            this.c14nSupport = (Boolean)object;
            return;
        }
        if (OBJECT_IDENTITY_CYCLE_DETECTION.equals(string)) {
            this.checkBoolean(string, object);
            this.serializer.setObjectIdentityCycleDetection((Boolean)object);
            return;
        }
        super.setProperty(string, object);
    }

    private void checkBoolean(String string, Object object) throws PropertyException {
        if (!(object instanceof Boolean)) {
            throw new PropertyException(Messages.MUST_BE_X.format(string, Boolean.class.getName(), object.getClass().getName()));
        }
    }

    private void checkString(String string, Object object) throws PropertyException {
        if (!(object instanceof String)) {
            throw new PropertyException(Messages.MUST_BE_X.format(string, String.class.getName(), object.getClass().getName()));
        }
    }

    @Override
    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.serializer.putAdapter(clazz, a);
    }

    @Override
    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (this.serializer.containsAdapter(clazz)) {
            return this.serializer.getAdapter(clazz);
        }
        return null;
    }

    @Override
    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        this.serializer.attachmentMarshaller = attachmentMarshaller;
    }

    @Override
    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.serializer.attachmentMarshaller;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public boolean handleEvent(ValidationEvent validationEvent) {
        return false;
    }

    @Override
    public Marshaller.Listener getListener() {
        return this.externalListener;
    }

    @Override
    public void setListener(Marshaller.Listener listener) {
        this.externalListener = listener;
    }
}

