/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.sun.xml.internal.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.internal.bind.v2.model.annotation.RuntimeInlineAnnotationReader;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.ws.model.AbstractWrapperBeanGenerator;
import com.sun.xml.internal.ws.model.FieldSignature;
import com.sun.xml.internal.ws.model.Injector;
import com.sun.xml.internal.ws.model.Utils;
import com.sun.xml.internal.ws.org.objectweb.asm.AnnotationVisitor;
import com.sun.xml.internal.ws.org.objectweb.asm.ClassWriter;
import com.sun.xml.internal.ws.org.objectweb.asm.FieldVisitor;
import com.sun.xml.internal.ws.org.objectweb.asm.Type;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;

public class WrapperBeanGenerator {
    private static final Logger LOGGER = Logger.getLogger(WrapperBeanGenerator.class.getName());
    private static final FieldFactory FIELD_FACTORY = new FieldFactory();
    private static final AbstractWrapperBeanGenerator RUNTIME_GENERATOR = new RuntimeWrapperBeanGenerator(new RuntimeInlineAnnotationReader(), Utils.REFLECTION_NAVIGATOR, FIELD_FACTORY);

    private static byte[] createBeanImage(String string, String string2, String string3, String string4, String string5, Collection<Field> collection) throws Exception {
        XmlElement xmlElement;
        Object object;
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(49, 33, WrapperBeanGenerator.replaceDotWithSlash(string), null, "java/lang/Object", null);
        AnnotationVisitor annotationVisitor = classWriter.visitAnnotation("Ljavax/xml/bind/annotation/XmlRootElement;", true);
        annotationVisitor.visit("name", string2);
        annotationVisitor.visit("namespace", string3);
        annotationVisitor.visitEnd();
        AnnotationVisitor annotationVisitor2 = classWriter.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        annotationVisitor2.visit("name", string4);
        annotationVisitor2.visit("namespace", string5);
        if (collection.size() > 1) {
            object = annotationVisitor2.visitArray("propOrder");
            for (Field field : collection) {
                object.visit("propOrder", field.fieldName);
            }
            object.visitEnd();
        }
        annotationVisitor2.visitEnd();
        for (Field field : collection) {
            FieldVisitor fieldVisitor = classWriter.visitField(1, field.fieldName, field.asmType.getDescriptor(), field.getSignature(), null);
            for (Object object2 : field.jaxbAnnotations) {
                Object object3;
                if (object2 instanceof XmlMimeType) {
                    object3 = fieldVisitor.visitAnnotation("Ljavax/xml/bind/annotation/XmlMimeType;", true);
                    object3.visit("value", ((XmlMimeType)object2).value());
                    object3.visitEnd();
                    continue;
                }
                if (object2 instanceof XmlJavaTypeAdapter) {
                    object3 = fieldVisitor.visitAnnotation("Ljavax/xml/bind/annotation/adapters/XmlJavaTypeAdapter;", true);
                    object3.visit("value", WrapperBeanGenerator.getASMType(((XmlJavaTypeAdapter)object2).value()));
                    object3.visitEnd();
                    continue;
                }
                if (object2 instanceof XmlAttachmentRef) {
                    object3 = fieldVisitor.visitAnnotation("Ljavax/xml/bind/annotation/XmlAttachmentRef;", true);
                    object3.visitEnd();
                    continue;
                }
                if (object2 instanceof XmlList) {
                    object3 = fieldVisitor.visitAnnotation("Ljavax/xml/bind/annotation/XmlList;", true);
                    object3.visitEnd();
                    continue;
                }
                if (object2 instanceof XmlElement) {
                    object3 = fieldVisitor.visitAnnotation("Ljavax/xml/bind/annotation/XmlElement;", true);
                    xmlElement = (XmlElement)object2;
                    object3.visit("name", xmlElement.name());
                    object3.visit("namespace", xmlElement.namespace());
                    if (xmlElement.nillable()) {
                        object3.visit("nillable", true);
                    }
                    if (xmlElement.required()) {
                        object3.visit("required", true);
                    }
                    object3.visitEnd();
                    continue;
                }
                throw new WebServiceException("Unknown JAXB annotation " + object2);
            }
            fieldVisitor.visitEnd();
        }
        object = classWriter.visitMethod(1, "<init>", "()V", null, null);
        object.visitCode();
        object.visitVarInsn(25, 0);
        object.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        object.visitInsn(177);
        object.visitMaxs(1, 1);
        object.visitEnd();
        classWriter.visitEnd();
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            stringBuilder.append("@XmlRootElement(name=").append(string2).append(", namespace=").append(string3).append(")");
            stringBuilder.append("\n");
            stringBuilder.append("@XmlType(name=").append(string4).append(", namespace=").append(string5);
            if (collection.size() > 1) {
                stringBuilder.append(", propOrder={");
                for (Field field : collection) {
                    stringBuilder.append(" ");
                    stringBuilder.append(field.fieldName);
                }
                stringBuilder.append(" }");
            }
            stringBuilder.append(")");
            stringBuilder.append("\n");
            stringBuilder.append("public class ").append(string).append(" {");
            for (Field field : collection) {
                stringBuilder.append("\n");
                for (Object object3 : field.jaxbAnnotations) {
                    stringBuilder.append("\n    ");
                    if (object3 instanceof XmlMimeType) {
                        stringBuilder.append("@XmlMimeType(value=").append(((XmlMimeType)object3).value()).append(")");
                        continue;
                    }
                    if (object3 instanceof XmlJavaTypeAdapter) {
                        stringBuilder.append("@XmlJavaTypeAdapter(value=").append(WrapperBeanGenerator.getASMType(((XmlJavaTypeAdapter)object3).value())).append(")");
                        continue;
                    }
                    if (object3 instanceof XmlAttachmentRef) {
                        stringBuilder.append("@XmlAttachmentRef");
                        continue;
                    }
                    if (object3 instanceof XmlList) {
                        stringBuilder.append("@XmlList");
                        continue;
                    }
                    if (object3 instanceof XmlElement) {
                        xmlElement = (XmlElement)object3;
                        stringBuilder.append("\n    ");
                        stringBuilder.append("@XmlElement(name=").append(xmlElement.name()).append(", namespace=").append(xmlElement.namespace());
                        if (xmlElement.nillable()) {
                            stringBuilder.append(", nillable=true");
                        }
                        if (xmlElement.required()) {
                            stringBuilder.append(", required=true");
                        }
                        stringBuilder.append(")");
                        continue;
                    }
                    throw new WebServiceException("Unknown JAXB annotation " + object3);
                }
                stringBuilder.append("\n    ");
                stringBuilder.append("public ");
                if (field.getSignature() == null) {
                    stringBuilder.append(field.asmType.getDescriptor());
                } else {
                    stringBuilder.append(field.getSignature());
                }
                stringBuilder.append(" ");
                stringBuilder.append(field.fieldName);
            }
            stringBuilder.append("\n\n}");
            LOGGER.fine(stringBuilder.toString());
        }
        return classWriter.toByteArray();
    }

    private static String replaceDotWithSlash(String string) {
        return string.replace('.', '/');
    }

    static Class createRequestWrapperBean(String string, Method method, QName qName, ClassLoader classLoader) {
        byte[] byArray;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Request Wrapper Class : {0}", string);
        }
        List<Field> list = RUNTIME_GENERATOR.collectRequestBeanMembers(method);
        try {
            byArray = WrapperBeanGenerator.createBeanImage(string, qName.getLocalPart(), qName.getNamespaceURI(), qName.getLocalPart(), qName.getNamespaceURI(), list);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        return Injector.inject(classLoader, string, byArray);
    }

    static Class createResponseWrapperBean(String string, Method method, QName qName, ClassLoader classLoader) {
        byte[] byArray;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Response Wrapper Class : {0}", string);
        }
        List<Field> list = RUNTIME_GENERATOR.collectResponseBeanMembers(method);
        try {
            byArray = WrapperBeanGenerator.createBeanImage(string, qName.getLocalPart(), qName.getNamespaceURI(), qName.getLocalPart(), qName.getNamespaceURI(), list);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        return Injector.inject(classLoader, string, byArray);
    }

    private static Type getASMType(java.lang.reflect.Type type) {
        java.lang.reflect.Type type2;
        assert (type != null);
        if (type instanceof Class) {
            return Type.getType((Class)type);
        }
        if (type instanceof ParameterizedType && (type2 = (ParameterizedType)type).getRawType() instanceof Class) {
            return Type.getType((Class)type2.getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Type.getType(FieldSignature.vms(type));
        }
        if (type instanceof WildcardType) {
            return Type.getType(FieldSignature.vms(type));
        }
        if (type instanceof TypeVariable && (type2 = (TypeVariable)type).getBounds()[0] instanceof Class) {
            return Type.getType((Class)type2.getBounds()[0]);
        }
        throw new IllegalArgumentException("Not creating ASM Type for type = " + type);
    }

    static Class createExceptionBean(String string, Class clazz, String string2, String string3, String string4, ClassLoader classLoader) {
        return WrapperBeanGenerator.createExceptionBean(string, clazz, string2, string3, string4, classLoader, true);
    }

    static Class createExceptionBean(String string, Class clazz, String string2, String string3, String string4, ClassLoader classLoader, boolean bl) {
        byte[] byArray;
        Collection<Field> collection = RUNTIME_GENERATOR.collectExceptionBeanMembers(clazz, bl);
        try {
            byArray = WrapperBeanGenerator.createBeanImage(string, string3, string4, clazz.getSimpleName(), string2, collection);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        return Injector.inject(classLoader, string, byArray);
    }

    static void write(byte[] byArray, String string) {
        string = string.substring(string.lastIndexOf(".") + 1);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string + ".class");
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Error Writing class", iOException);
        }
    }

    private static class Field
    implements Comparable<Field> {
        private final java.lang.reflect.Type reflectType;
        private final Type asmType;
        private final String fieldName;
        private final List<Annotation> jaxbAnnotations;

        Field(String string, java.lang.reflect.Type type, Type type2, List<Annotation> list) {
            this.reflectType = type;
            this.asmType = type2;
            this.fieldName = string;
            this.jaxbAnnotations = list;
        }

        String getSignature() {
            if (this.reflectType instanceof Class) {
                return null;
            }
            if (this.reflectType instanceof TypeVariable) {
                return null;
            }
            return FieldSignature.vms(this.reflectType);
        }

        @Override
        public int compareTo(Field field) {
            return this.fieldName.compareTo(field.fieldName);
        }
    }

    private static final class FieldFactory
    implements AbstractWrapperBeanGenerator.BeanMemberFactory<java.lang.reflect.Type, Field> {
        private FieldFactory() {
        }

        @Override
        public Field createWrapperBeanMember(java.lang.reflect.Type type, String string, List<Annotation> list) {
            return new Field(string, type, WrapperBeanGenerator.getASMType(type), list);
        }
    }

    private static final class RuntimeWrapperBeanGenerator
    extends AbstractWrapperBeanGenerator<java.lang.reflect.Type, Class, Method, Field> {
        protected RuntimeWrapperBeanGenerator(AnnotationReader<java.lang.reflect.Type, Class, ?, Method> annotationReader, Navigator<java.lang.reflect.Type, Class, ?, Method> navigator, AbstractWrapperBeanGenerator.BeanMemberFactory<java.lang.reflect.Type, Field> beanMemberFactory) {
            super(annotationReader, navigator, beanMemberFactory);
        }

        @Override
        protected java.lang.reflect.Type getSafeType(java.lang.reflect.Type type) {
            return type;
        }

        @Override
        protected java.lang.reflect.Type getHolderValueType(java.lang.reflect.Type type) {
            ParameterizedType parameterizedType;
            if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Holder.class)) {
                return parameterizedType.getActualTypeArguments()[0];
            }
            return null;
        }

        @Override
        protected boolean isVoidType(java.lang.reflect.Type type) {
            return type == Void.TYPE;
        }
    }
}

