/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;
import sun.security.ssl.SunJSSE;
import sun.security.util.ECUtil;

final class JsseJce {
    private static final ProviderList fipsProviderList;
    private static Boolean ecAvailable;
    private static final boolean kerberosAvailable;
    static final String CIPHER_RSA_PKCS1 = "RSA/ECB/PKCS1Padding";
    static final String CIPHER_RC4 = "RC4";
    static final String CIPHER_DES = "DES/CBC/NoPadding";
    static final String CIPHER_3DES = "DESede/CBC/NoPadding";
    static final String CIPHER_AES = "AES/CBC/NoPadding";
    static final String CIPHER_AES_GCM = "AES/GCM/NoPadding";
    static final String SIGNATURE_DSA = "DSA";
    static final String SIGNATURE_ECDSA = "SHA1withECDSA";
    static final String SIGNATURE_RAWDSA = "RawDSA";
    static final String SIGNATURE_RAWECDSA = "NONEwithECDSA";
    static final String SIGNATURE_RAWRSA = "NONEwithRSA";
    static final String SIGNATURE_SSLRSA = "MD5andSHA1withRSA";

    private JsseJce() {
    }

    static synchronized boolean isEcAvailable() {
        if (ecAvailable == null) {
            try {
                JsseJce.getSignature(SIGNATURE_ECDSA);
                JsseJce.getSignature(SIGNATURE_RAWECDSA);
                JsseJce.getKeyAgreement("ECDH");
                JsseJce.getKeyFactory("EC");
                JsseJce.getKeyPairGenerator("EC");
                ecAvailable = true;
            }
            catch (Exception exception) {
                ecAvailable = false;
            }
        }
        return ecAvailable;
    }

    static synchronized void clearEcAvailable() {
        ecAvailable = null;
    }

    static boolean isKerberosAvailable() {
        return kerberosAvailable;
    }

    static Cipher getCipher(String string) throws NoSuchAlgorithmException {
        try {
            if (SunJSSE.cryptoProvider == null) {
                return Cipher.getInstance(string);
            }
            return Cipher.getInstance(string, SunJSSE.cryptoProvider);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException);
        }
    }

    static Signature getSignature(String string) throws NoSuchAlgorithmException {
        if (SunJSSE.cryptoProvider == null) {
            return Signature.getInstance(string);
        }
        if (string == SIGNATURE_SSLRSA && SunJSSE.cryptoProvider.getService("Signature", string) == null) {
            try {
                return Signature.getInstance(string, "SunJSSE");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException(noSuchProviderException);
            }
        }
        return Signature.getInstance(string, SunJSSE.cryptoProvider);
    }

    static KeyGenerator getKeyGenerator(String string) throws NoSuchAlgorithmException {
        if (SunJSSE.cryptoProvider == null) {
            return KeyGenerator.getInstance(string);
        }
        return KeyGenerator.getInstance(string, SunJSSE.cryptoProvider);
    }

    static KeyPairGenerator getKeyPairGenerator(String string) throws NoSuchAlgorithmException {
        if (SunJSSE.cryptoProvider == null) {
            return KeyPairGenerator.getInstance(string);
        }
        return KeyPairGenerator.getInstance(string, SunJSSE.cryptoProvider);
    }

    static KeyAgreement getKeyAgreement(String string) throws NoSuchAlgorithmException {
        if (SunJSSE.cryptoProvider == null) {
            return KeyAgreement.getInstance(string);
        }
        return KeyAgreement.getInstance(string, SunJSSE.cryptoProvider);
    }

    static Mac getMac(String string) throws NoSuchAlgorithmException {
        if (SunJSSE.cryptoProvider == null) {
            return Mac.getInstance(string);
        }
        return Mac.getInstance(string, SunJSSE.cryptoProvider);
    }

    static KeyFactory getKeyFactory(String string) throws NoSuchAlgorithmException {
        if (SunJSSE.cryptoProvider == null) {
            return KeyFactory.getInstance(string);
        }
        return KeyFactory.getInstance(string, SunJSSE.cryptoProvider);
    }

    static SecureRandom getSecureRandom() throws KeyManagementException {
        if (SunJSSE.cryptoProvider == null) {
            return new SecureRandom();
        }
        try {
            return SecureRandom.getInstance("PKCS11", SunJSSE.cryptoProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            for (Provider.Service service : SunJSSE.cryptoProvider.getServices()) {
                if (!service.getType().equals("SecureRandom")) continue;
                try {
                    return SecureRandom.getInstance(service.getAlgorithm(), SunJSSE.cryptoProvider);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                }
            }
            throw new KeyManagementException("FIPS mode: no SecureRandom  implementation found in provider " + SunJSSE.cryptoProvider.getName());
        }
    }

    static MessageDigest getMD5() {
        return JsseJce.getMessageDigest("MD5");
    }

    static MessageDigest getSHA() {
        return JsseJce.getMessageDigest("SHA");
    }

    static MessageDigest getMessageDigest(String string) {
        try {
            if (SunJSSE.cryptoProvider == null) {
                return MessageDigest.getInstance(string);
            }
            return MessageDigest.getInstance(string, SunJSSE.cryptoProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Algorithm " + string + " not available", noSuchAlgorithmException);
        }
    }

    static int getRSAKeyLength(PublicKey publicKey) {
        BigInteger bigInteger;
        if (publicKey instanceof RSAPublicKey) {
            bigInteger = ((RSAPublicKey)publicKey).getModulus();
        } else {
            RSAPublicKeySpec rSAPublicKeySpec = JsseJce.getRSAPublicKeySpec(publicKey);
            bigInteger = rSAPublicKeySpec.getModulus();
        }
        return bigInteger.bitLength();
    }

    static RSAPublicKeySpec getRSAPublicKeySpec(PublicKey publicKey) {
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        try {
            KeyFactory keyFactory = JsseJce.getKeyFactory("RSA");
            return keyFactory.getKeySpec(publicKey, RSAPublicKeySpec.class);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static ECParameterSpec getECParameterSpec(String string) {
        return ECUtil.getECParameterSpec(SunJSSE.cryptoProvider, string);
    }

    static String getNamedCurveOid(ECParameterSpec eCParameterSpec) {
        return ECUtil.getCurveName(SunJSSE.cryptoProvider, eCParameterSpec);
    }

    static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        return ECUtil.decodePoint(byArray, ellipticCurve);
    }

    static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        return ECUtil.encodePoint(eCPoint, ellipticCurve);
    }

    static Object beginFipsProvider() {
        if (fipsProviderList == null) {
            return null;
        }
        return Providers.beginThreadProviderList(fipsProviderList);
    }

    static void endFipsProvider(Object object) {
        if (fipsProviderList != null) {
            Providers.endThreadProviderList((ProviderList)object);
        }
    }

    static {
        boolean bl;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Class.forName("sun.security.krb5.PrincipalName", true, null);
                    return null;
                }
            });
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        kerberosAvailable = bl;
        if (!SunJSSE.isFIPS()) {
            fipsProviderList = null;
        } else {
            Provider provider = Security.getProvider("SUN");
            if (provider == null) {
                throw new RuntimeException("FIPS mode: SUN provider must be installed");
            }
            SunCertificates sunCertificates = new SunCertificates(provider);
            fipsProviderList = ProviderList.newList(SunJSSE.cryptoProvider, sunCertificates);
        }
    }

    private static final class SunCertificates
    extends Provider {
        private static final long serialVersionUID = -3284138292032213752L;

        SunCertificates(final Provider provider) {
            super("SunCertificates", 1.8, "SunJSSE internal");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (Map.Entry<Object, Object> entry : provider.entrySet()) {
                        String string = (String)entry.getKey();
                        if (!string.startsWith("CertPathValidator.") && !string.startsWith("CertPathBuilder.") && !string.startsWith("CertStore.") && !string.startsWith("CertificateFactory.")) continue;
                        this.put(string, entry.getValue());
                    }
                    return null;
                }
            });
        }
    }
}

