;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text

; AX    - the input/output value
; C/E/L - the number of bits to rotate

.macro SHIFT_FUNC name, reg, saddr, shift

  START_FUNC \name\reg
      cmp0   \saddr
      bz     $2f
  1:  \shift ax, 1
      dec    \reg
      bnz    $1b
  2:  ret
  END_FUNC \name\reg

.endm

SHIFT_FUNC ___ashlhi3, c, c,   shlw
SHIFT_FUNC ___ashlhi3, e, r_4, shlw
SHIFT_FUNC ___ashlhi3, l, r_6, shlw

SHIFT_FUNC ___ashrhi3, c, c,   sarw
SHIFT_FUNC ___ashrhi3, e, r_4, sarw
SHIFT_FUNC ___ashrhi3, l, r_6, sarw

SHIFT_FUNC ___lshrhi3, c, c,   shrw
SHIFT_FUNC ___lshrhi3, e, r_4, shrw
SHIFT_FUNC ___lshrhi3, l, r_6, shrw
