TARGET = rx
TYPE = elf
AR := $(TARGET)-$(TYPE)-ar
CC := $(TARGET)-$(TYPE)-gcc
CCOPTS = -W -Wall -Wno-narrowing -Wwrite-strings -Wcast-qual -Wstrict-prototypes -Wold-style-definition -Os -ffunction-sections -fdata-sections -O2 -fbuilding-libgcc -fno-stack-protector -fvisibility=hidden
ASOPTS = -c -xassembler-with-cpp -ffunction-sections -fdata-sections
FLAGS1 = -DIN_GCC -DCROSS_DIRECTORY_STRUCTURE -Dinhibit_libc -DIN_LIBGCC2 -DHAVE_CC_TLS -DUSE_EMUTLS -DHIDE_EXPORTS
FLAGS_DIVMOD = -fexceptions -fnon-call-exceptions
FLAGS_FPBIT = -DFINE_GRAINED_LIBRARIES -DFLOAT
FLAGS_DPBIT = -DFINE_GRAINED_LIBRARIES
INC = "$(SRCDIR)/include"
AR_SW = -rcus
LIBPATH = ./libgcc.a
CCUOPTS =
ASUOPTS =

all: _muldi3.o _negdi2.o _lshrdi3.o _ashldi3.o _ashrdi3.o _cmpdi2.o _ucmpdi2.o _clear_cache.o _trampoline.o __main.o _absvsi2.o _absvdi2.o _addvsi3.o _addvdi3.o _subvsi3.o \
  _subvdi3.o _mulvsi3.o _mulvdi3.o _negvsi2.o _negvdi2.o _ctors.o _ffssi2.o _ffsdi2.o _clz.o _clzsi2.o _clzdi2.o _ctzsi2.o _ctzdi2.o _popcount_tab.o _popcountsi2.o \
  _popcountdi2.o _paritysi2.o _paritydi2.o _powisf2.o _powidf2.o _powixf2.o _powitf2.o _mulsc3.o _muldc3.o _mulxc3.o _multc3.o _divsc3.o _divdc3.o _divxc3.o _divtc3.o \
  _bswapsi2.o _bswapdi2.o _clrsbsi2.o _clrsbdi2.o _fixunssfsi.o _fixunsdfsi.o _fixunsxfsi.o _fixsfdi.o _fixdfdi.o _fixxfdi.o _fixtfdi.o _fixunssfdi.o _fixunsdfdi.o \
  _fixunsxfdi.o _fixunstfdi.o _floatdisf.o _floatdidf.o _floatdixf.o _floatditf.o _floatundisf.o _floatundidf.o _floatundixf.o _floatunditf.o _eprintf.o __gcc_bcmp.o \
  _divdi3.o _moddi3.o _udivdi3.o _umoddi3.o _udiv_w_sdiv.o _udivmoddi4.o _pack_sf.o _unpack_sf.o _addsub_sf.o _mul_sf.o _div_sf.o _fpcmp_parts_sf.o _compare_sf.o \
  _eq_sf.o _ne_sf.o _gt_sf.o _ge_sf.o _lt_sf.o _le_sf.o _unord_sf.o _si_to_sf.o _sf_to_si.o _negate_sf.o _make_sf.o _sf_to_df.o _thenan_sf.o _sf_to_usi.o \
  _usi_to_sf.o _pack_df.o _unpack_df.o _addsub_df.o _mul_df.o _div_df.o _fpcmp_parts_df.o _compare_df.o _eq_df.o _ne_df.o _gt_df.o _ge_df.o _lt_df.o \
  _le_df.o _unord_df.o _si_to_df.o _df_to_si.o _negate_df.o _make_df.o _df_to_sf.o _thenan_df.o _df_to_usi.o _usi_to_df.o rx-abi-functions.o \
  enable-execute-stack.o unwind-dw2.o unwind-dw2-fde.o unwind-sjlj.o unwind-c.o emutls.o
	@$(AR) $(AR_SW) "$(LIBPATH)" $^

lib: $(patsubst lib,,$(MAKECMDGOALS))
	@$(AR) $(AR_SW) "$(LIBPATH)" *.o

clean:
	-@$(RM) *.o


_muldi3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_muldi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_negdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_negdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_lshrdi3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_lshrdi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_ashldi3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ashldi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_ashrdi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/ashr64.S" $(ASUOPTS) -I $(INC)

_cmpdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_cmpdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_ucmpdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ucmpdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_clear_cache.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clear_cache -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_trampoline.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_trampoline -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

__main.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL__main -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_absvsi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_absvsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_absvdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_absvdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_addvsi3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_addvsi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_addvdi3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_addvdi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_subvsi3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_subvsi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_subvdi3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_subvdi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_mulvsi3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_mulvsi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_mulvdi3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_mulvdi3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_negvsi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_negvsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_negvdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_negvdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_ctors.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ctors -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_ffssi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ffssi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_ffsdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ffsdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_clz.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clz -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_clzsi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clzsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_clzdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clzdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_ctzsi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ctzsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_ctzdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ctzdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_popcount_tab.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_popcount_tab -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_popcountsi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_popcountsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_popcountdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_popcountdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_paritysi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_paritysi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_paritydi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_paritydi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_powisf2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_powisf2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_powidf2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_powidf2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_powixf2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_powixf2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_powitf2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_powitf2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_mulsc3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_mulsc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_muldc3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_muldc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_mulxc3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_mulxc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_multc3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_multc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_divsc3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_divsc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_divdc3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_divdc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_divxc3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_divxc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_divtc3.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_divtc3 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_bswapsi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_bswapsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_bswapdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_bswapdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_clrsbsi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clrsbsi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_clrsbdi2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_clrsbdi2 -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_fixunssfsi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunssfsi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_fixunsdfsi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunsdfsi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_fixunsxfsi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunsxfsi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_fixsfdi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/fixsfdi.S" $(ASUOPTS) -I $(INC)

_fixdfdi.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/fixdfdi.S" $(ASUOPTS) -I $(INC)

_fixxfdi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixxfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_fixtfdi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixtfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_fixunssfdi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunssfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_fixunsdfdi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunsdfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_fixunsxfdi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunsxfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_fixunstfdi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fixunstfdi -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_floatdisf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatdisf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_floatdidf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatdidf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_floatdixf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatdixf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_floatditf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatditf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_floatundisf.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/floatundidf.S" $(ASUOPTS) -I $(INC)

_floatundidf.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/floatundidf.S" $(ASUOPTS) -I $(INC)

_floatundixf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatundixf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_floatunditf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_floatunditf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_eprintf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_eprintf -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

__gcc_bcmp.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL__gcc_bcmp -c "$(SRCDIR)/libgcc2.c" $(CCUOPTS) -I $(INC)

_divdi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/div64s.S" $(FLAGS_DIVMOD) $(ASUOPTS) -I $(INC)

_moddi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/mod64s.S" $(ASUOPTS) -I $(INC)

_udivdi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/div64u.S" $(FLAGS_DIVMOD) $(ASUOPTS) -I $(INC)

_umoddi3.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/mod64u.S" $(FLAGS_DIVMOD) $(ASUOPTS) -I $(INC)

_udiv_w_sdiv.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_udiv_w_sdiv -c "$(SRCDIR)/libgcc2.c" $(FLAGS_DIVMOD) $(CCUOPTS) -I $(INC)

_udivmoddi4.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_udivmoddi4 -c "$(SRCDIR)/libgcc2.c" $(FLAGS_DIVMOD) $(CCUOPTS) -I $(INC)

_pack_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_pack_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_unpack_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_unpack_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_addsub_sf.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/addsf3.S" $(FLAGS_FPBIT) $(ASUOPTS) -I $(INC)

_mul_sf.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/mulsf3.S" $(FLAGS_FPBIT) $(ASUOPTS) -I $(INC)

_div_sf.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/divsf3.S" $(FLAGS_FPBIT) $(ASUOPTS) -I $(INC)

_fpcmp_parts_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fpcmp_parts_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_compare_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_compare_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_eq_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_eq_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_ne_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ne_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_gt_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_gt_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_ge_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_ge_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_lt_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_lt_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_le_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_le_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_unord_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_unord_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_si_to_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_si_to_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_sf_to_si.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_sf_to_si -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_negate_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_negate_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_make_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_make_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_sf_to_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_sf_to_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_thenan_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_thenan_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_sf_to_usi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_sf_to_usi -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_usi_to_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_usi_to_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_FPBIT) $(CCUOPTS) -I $(INC)

_pack_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_pack_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_unpack_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_unpack_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_addsub_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/adddf3.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_mul_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/muldf3.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_div_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/divdf3.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_fpcmp_parts_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_fpcmp_parts_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_compare_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_compare_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_eq_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/eqdf2.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_ne_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/nedf2.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_gt_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/gtdf2.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_ge_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/gedf2.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_lt_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/ltdf2.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_le_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/ledf2.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_unord_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_unord_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_si_to_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_si_to_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_df_to_si.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_df_to_si -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_negate_df.o:
	@$(CC) $(ASOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/nedf2.S" $(FLAGS_DPBIT) $(ASUOPTS) -I $(INC)

_make_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_make_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_df_to_sf.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_df_to_sf -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_thenan_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_thenan_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_df_to_usi.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_df_to_usi -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

_usi_to_df.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -DL_usi_to_df -c "$(SRCDIR)/fp-bit.c" $(FLAGS_DPBIT) $(CCUOPTS) -I $(INC)

rx-abi-functions.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/rx-abi-functions.c" $(CCUOPTS) -I $(INC)

enable-execute-stack.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/enable-execute-stack.c" $(CCUOPTS) -I $(INC)

unwind-dw2.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/unwind-dw2.c" -fexceptions $(CCUOPTS) -I $(INC)

unwind-dw2-fde.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/unwind-dw2-fde.c" -fexceptions $(CCUOPTS) -I $(INC)

unwind-sjlj.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/unwind-sjlj.c" -fexceptions $(CCUOPTS) -I $(INC)

unwind-c.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/unwind-c.c" -fexceptions $(CCUOPTS) -I $(INC)

emutls.o:
	@$(CC) $(CCOPTS) $(FLAGS1) -o $@ -c "$(SRCDIR)/emutls.c" -fexceptions $(CCUOPTS) -I $(INC)
