TARGET:=rx
TYPE:=elf
AR:=$(TARGET)-$(TYPE)-ar
CC:=$(TARGET)-$(TYPE)-gcc
CXX:=$(TARGET)-$(TYPE)-g++
CCOPTS:=-ffunction-sections -fdata-sections
CXXOPTS:=-ffunction-sections -fdata-sections -fno-implicit-templates -fdiagnostics-show-location=once
CXXUOPTS:=
CXX11OPTS:=-std=c++11
SINC:=-isystem "$(SRCDIR)/$(TARGET)-$(TYPE)/sys-include" -I"$(SRCDIR)/include" -I"$(SRCDIR)/libsupc++" -L"$(SRCDIR)/src"
LIBPATH:=./libstdc++.a
CCUOPTS=
ASUOPTS=
AR_SW = -rcus

lib: libstdcpp

libstdcpp: allocator-inst.o array_type_info.o atexit_arm.o atexit_thread.o atomicity.o bad_alloc.o bad_cast.o bad_typeid.o basic_file.o \
  bitmap_allocator.o c++locale.o chrono.o class_type_info.o codecvt.o codecvt_members.o collate_members.o \
  compatibility-atomic-c++0x.o compatibility-c++0x.o compatibility-chrono.o compatibility-debug_list-2.o \
  compatibility-debug_list.o compatibility-thread-c++0x.o compatibility.o complex_io.o concept-inst.o condition_variable.o \
  ctype.o ctype_configure_char.o ctype_members.o debug.o del_op.o del_opnt.o del_opv.o del_opvnt.o dyncast.o \
  eh_alloc.o eh_arm.o eh_aux_runtime.o eh_call.o eh_catch.o eh_exception.o eh_globals.o eh_personality.o eh_ptr.o eh_terminate.o \
  eh_term_handler.o eh_throw.o eh_tm.o eh_type.o eh_unex_handler.o enum_type_info.o ext-inst.o fstream-inst.o \
  functexcept.o functional.o function_type_info.o fundamental_type_info.o future.o globals_io.o guard.o guard_error.o \
  hashtable_c++0x.o hashtable_tr1.o hash_bytes.o hash_c++0x.o hash_tr1.o ios-inst.o ios.o iostream-inst.o ios_failure.o ios_init.o \
  ios_locale.o istream-inst.o istream.o limits.o list-aux-2.o list-aux.o list.o list_associated-2.o list_associated.o \
  locale-inst.o locale.o localename.o locale_facets.o locale_init.o math_stubs_float.o math_stubs_long_double.o \
  messages_members.o misc-inst.o monetary_members.o mt_allocator.o mutex.o nested_exception.o new_handler.o new_op.o new_opnt.o \
  new_opv.o new_opvnt.o numeric_members.o ostream-inst.o parallel_settings.o pbase_type_info.o placeholders.o pmem_type_info.o \
  pointer_type_info.o pool_allocator.o pure.o random.o regex.o shared_ptr.o si_class_type_info.o sstream-inst.o stdexcept.o \
  streambuf-inst.o streambuf.o string-inst.o strstream.o system_error.o thread.o time_members.o tinfo.o tinfo2.o tree.o valarray.o \
  vec.o vmi_class_type_info.o vterminate.o wlocale-inst.o wstring-inst.o cp-demangle.o
	$(AR) $(AR_SW) $(LIBPATH) $^

libsupcpp:

allocator-inst.o:
	@$(CXX) -std=gnu++98 -c "$(SRCDIR)/src/c++98/allocator-inst.cc" $(CXXUOPTS) -o $@ $(SINC)

array_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/array_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

atexit_arm.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/atexit_arm.cc" -o $@ $(CXXUOPTS) $(SINC)

atexit_thread.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/atexit_thread.cc" -o $@ $(CXXUOPTS) $(SINC)

atomicity.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/atomicity.cc" -o $@ $(CXXUOPTS) $(SINC)

bad_alloc.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/bad_alloc.cc" -o $@ $(CXXUOPTS) $(SINC)

bad_cast.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/bad_cast.cc" -o $@ $(CXXUOPTS) $(SINC)

bad_typeid.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/bad_typeid.cc" -o $@ $(CXXUOPTS) $(SINC)

basic_file.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/basic_file.cc" -o $@ $(CXXUOPTS) $(SINC)

bitmap_allocator.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/bitmap_allocator.cc" -o $@ $(CXXUOPTS) $(SINC)

c++locale.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/c++locale.cc" -o $@ $(CXXUOPTS) $(SINC)

chrono.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/chrono.cc" -o $@ $(CXXUOPTS) $(SINC)

class_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/class_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

codecvt.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/codecvt.cc" -o $@ $(CXXUOPTS) $(SINC)

codecvt_members.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/codecvt_members.cc" -o $@ $(CXXUOPTS) $(SINC)

collate_members.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/collate_members.cc" -o $@ $(CXXUOPTS) $(SINC)

compatibility-atomic-c++0x.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/compatibility-atomic-c++0x.cc" -o $@ $(CXXUOPTS) $(SINC)

compatibility-c++0x.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/compatibility-c++0x.cc" -o $@ $(CXXUOPTS) $(SINC)

compatibility-chrono.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/compatibility-chrono.cc" -o $@ $(CXXUOPTS) $(SINC)

compatibility-debug_list-2.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++98/compatibility-debug_list-2.cc" -o $@ $(CXXUOPTS) $(SINC)

compatibility-debug_list.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/compatibility-debug_list.cc" -o $@ $(CXXUOPTS) $(SINC)

compatibility-thread-c++0x.o:
	@$(CXX) $(CXXOPTS) -std=gnu++0x -c "$(SRCDIR)/src/c++11/compatibility-thread-c++0x.cc" -o $@ $(CXXUOPTS) $(SINC)

compatibility.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/compatibility.cc" -o $@ $(CXXUOPTS) $(SINC)

complex_io.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/complex_io.cc" -o $@ $(CXXUOPTS) $(SINC)

concept-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/concept-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

condition_variable.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/condition_variable.cc" -o $@ $(CXXUOPTS) $(SINC)

cp-demangle.o:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libsupc++/cp-demangle.c" -o $@ $(CXXUOPTS) $(SINC)

ctype.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ctype.cc" -o $@ $(CXXUOPTS) $(SINC)

ctype_configure_char.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ctype_configure_char.cc" -o $@ $(CXXUOPTS) $(SINC)

ctype_members.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ctype_members.cc" -o $@ $(CXXUOPTS) $(SINC)

debug.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/debug.cc" -o $@ $(CXXUOPTS) $(SINC)

del_op.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/del_op.cc" -o $@ $(CXXUOPTS) $(SINC)

del_opnt.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/del_opnt.cc" -o $@ $(CXXUOPTS) $(SINC)

del_opv.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/del_opv.cc" -o $@ $(CXXUOPTS) $(SINC)

del_opvnt.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/del_opvnt.cc" -o $@ $(CXXUOPTS) $(SINC)

dyncast.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/dyncast.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_alloc.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_alloc.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_arm.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_arm.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_aux_runtime.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_aux_runtime.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_call.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_call.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_catch.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_catch.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_exception.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_exception.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_globals.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_globals.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_personality.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_personality.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_ptr.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_ptr.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_terminate.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_terminate.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_term_handler.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_term_handler.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_throw.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_throw.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_tm.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_tm.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_type.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_type.cc" -o $@ $(CXXUOPTS) $(SINC)

eh_unex_handler.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/eh_unex_handler.cc" -o $@ $(CXXUOPTS) $(SINC)

enum_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/enum_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

ext-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ext-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

fstream-inst.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/fstream-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

functexcept.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/functexcept.cc" -o $@ $(CXXUOPTS) $(SINC)

functional.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/functional.cc" -o $@ $(CXXUOPTS) $(SINC)

function_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/function_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

fundamental_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/fundamental_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

future.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/future.cc" -o $@ $(CXXUOPTS) $(SINC)

globals_io.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/globals_io.cc" -o $@ $(CXXUOPTS) $(SINC)

guard.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/guard.cc" -o $@ $(CXXUOPTS) $(SINC)

guard_error.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/guard_error.cc" -o $@ $(CXXUOPTS) $(SINC)

hashtable_c++0x.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/hashtable_c++0x.cc" -o $@ $(CXXUOPTS) $(SINC)

hashtable_tr1.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/hashtable_tr1.cc" -o $@ $(CXXUOPTS) $(SINC)

hash_bytes.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/hash_bytes.cc" -o $@ $(CXXUOPTS) $(SINC)

hash_c++0x.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/hash_c++0x.cc" -o $@ $(CXXUOPTS) $(SINC)

hash_tr1.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/hash_tr1.cc" -o $@ $(CXXUOPTS) $(SINC)

ios-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ios-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

ios.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ios.cc" -o $@ $(CXXUOPTS) $(SINC)

iostream-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/iostream-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

ios_failure.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ios_failure.cc" -o $@ $(CXXUOPTS) $(SINC)

ios_init.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ios_init.cc" -o $@ $(CXXUOPTS) $(SINC)

ios_locale.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ios_locale.cc" -o $@ $(CXXUOPTS) $(SINC)

istream-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/istream-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

istream.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/istream.cc" -o $@ $(CXXUOPTS) $(SINC)

limits.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/limits.cc" -o $@ $(CXXUOPTS) $(SINC)

list-aux-2.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/list-aux-2.cc" -o $@ $(CXXUOPTS) $(SINC)

list-aux.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/list-aux.cc" -o $@ $(CXXUOPTS) $(SINC)

list.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/list.cc" -o $@ $(CXXUOPTS) $(SINC)

list_associated-2.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/list_associated-2.cc" -o $@ $(CXXUOPTS) $(SINC)

list_associated.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/list_associated.cc" -o $@ $(CXXUOPTS) $(SINC)

locale-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/locale-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

locale.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/locale.cc" -o $@ $(CXXUOPTS) $(SINC)

localename.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/localename.cc" -o $@ $(CXXUOPTS) $(SINC)

locale_facets.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/locale_facets.cc" -o $@ $(CXXUOPTS) $(SINC)

locale_init.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/locale_init.cc" -o $@ $(CXXUOPTS) $(SINC)

math_stubs_float.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/math_stubs_float.cc" -o $@ $(CXXUOPTS) $(SINC)

math_stubs_long_double.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/math_stubs_long_double.cc" -o $@ $(CXXUOPTS) $(SINC)

messages_members.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/messages_members.cc" -o $@ $(CXXUOPTS) $(SINC)

misc-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/misc-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

monetary_members.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/monetary_members.cc" -o $@ $(CXXUOPTS) $(SINC)

mt_allocator.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/mt_allocator.cc" -o $@ $(CXXUOPTS) $(SINC)

mutex.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/mutex.cc" -o $@ $(CXXUOPTS) $(SINC)

nested_exception.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/nested_exception.cc" -o $@ $(CXXUOPTS) $(SINC)

new_handler.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/new_handler.cc" -o $@ $(CXXUOPTS) $(SINC)

new_op.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/new_op.cc" -o $@ $(CXXUOPTS) $(SINC)

new_opnt.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/new_opnt.cc" -o $@ $(CXXUOPTS) $(SINC)

new_opv.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/new_opv.cc" -o $@ $(CXXUOPTS) $(SINC)

new_opvnt.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/new_opvnt.cc" -o $@ $(CXXUOPTS) $(SINC)

numeric_members.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/numeric_members.cc" -o $@ $(CXXUOPTS) $(SINC)

ostream-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/ostream-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

parallel_settings.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/parallel_settings.cc" -o $@ $(CXXUOPTS) $(SINC)

pbase_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/pbase_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

placeholders.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/placeholders.cc" -o $@ $(CXXUOPTS) $(SINC)

pmem_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/pmem_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

pointer_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/pointer_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

pool_allocator.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/pool_allocator.cc" -o $@ $(CXXUOPTS) $(SINC)

pure.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/pure.cc" -o $@ $(CXXUOPTS) $(SINC)

random.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/random.cc" -o $@ $(CXXUOPTS) $(SINC)

regex.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/regex.cc" -o $@ $(CXXUOPTS) $(SINC)

shared_ptr.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/shared_ptr.cc" -o $@ $(CXXUOPTS) $(SINC)

si_class_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/si_class_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

sstream-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/sstream-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

stdexcept.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/stdexcept.cc" -o $@ $(CXXUOPTS) $(SINC)

streambuf-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/streambuf-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

streambuf.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/streambuf.cc" -o $@ $(CXXUOPTS) $(SINC)

string-inst.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/string-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

strstream.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/strstream.cc" -o $@ $(CXXUOPTS) $(SINC)

system_error.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/system_error.cc" -o $@ $(CXXUOPTS) $(SINC)

thread.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/thread.cc" -o $@ $(CXXUOPTS) $(SINC)

time_members.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/time_members.cc" -o $@ $(CXXUOPTS) $(SINC)

tinfo.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/tinfo.cc" -o $@ $(CXXUOPTS) $(SINC)

tinfo2.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/tinfo2.cc" -o $@ $(CXXUOPTS) $(SINC)

tree.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/tree.cc" -o $@ $(CXXUOPTS) $(SINC)

valarray.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/valarray.cc" -o $@ $(CXXUOPTS) $(SINC)

vec.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/vec.cc" -o $@ $(CXXUOPTS) $(SINC)

vmi_class_type_info.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/vmi_class_type_info.cc" -o $@ $(CXXUOPTS) $(SINC)

vterminate.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/libsupc++/vterminate.cc" -o $@ $(CXXUOPTS) $(SINC)

wlocale-inst.o:
	@$(CXX) $(CXXOPTS) -c "$(SRCDIR)/src/c++98/wlocale-inst.cc" -o $@ $(CXXUOPTS) $(SINC)

wstring-inst.o:
	@$(CXX) $(CXXOPTS) $(CXX11OPTS) -c "$(SRCDIR)/src/c++11/wstring-inst.cc" -o $@ $(CXXUOPTS) $(SINC)



#clean
clean:
	@echo Cleaning...
	-@$(RM) *.o
