;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text

; arithmetic left shift
; inputs: [sp+4]..[sp+10] - the DI value to shift
;         [sp+12]         - the number of bit positions to shift
; output: r8..15
START_FUNC ___ashldi3

    movw  ax, [sp+4]
    movw  r8, ax

    movw  ax, [sp+6]
    movw  r10, ax

    movw  ax, [sp+8]
    movw  r12, ax

    movw  ax, [sp+10]
    movw  r14, ax

    mov   a, [sp+12]
    and   a, #63
    bz    $1f

    mov   e, a

0:  movw  ax, r8
    shlw  ax, 1
    movw  r8, ax

    movw  ax, r10
    rolwc ax, 1
    movw  r10, ax

    movw  ax, r12
    rolwc ax, 1
    movw  r12, ax

    movw  ax, r14
    rolwc ax, 1
    movw  r14, ax

    dec   e
    bnz   $0b

1:  ret

END_FUNC ___ashldi3
