/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xml;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.xml.XMLAttribute;
import com.sun.deploy.xml.XMLNode;
import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    private XMLNode _root;
    private String _source;
    private Stack<XMLNode> _inProgress;
    private String _characters;
    private static final String DTD_DOWNLOAD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static SAXParserFactory spf = SAXParserFactory.newInstance();

    public XMLParser(String string) {
        this._source = string.trim();
        Trace.println("XMLParser with _source:\n" + this._source, TraceLevel.BASIC);
    }

    public XMLNode parse() throws SAXException {
        return this.parse(false);
    }

    public XMLNode parse(boolean bl) throws SAXException {
        this._root = null;
        this._inProgress = new Stack();
        try {
            InputSource inputSource = new InputSource(new StringReader(this._source));
            spf.setValidating(bl);
            try {
                spf.setFeature(DTD_DOWNLOAD, bl);
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            SAXParser sAXParser = spf.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Trace.ignored(parserConfigurationException);
            throw new SAXException(parserConfigurationException);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            throw new SAXException(iOException);
        }
        return this._root;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        XMLAttribute xMLAttribute = null;
        XMLAttribute xMLAttribute2 = null;
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttribute xMLAttribute3 = new XMLAttribute(attributes.getQName(i).trim(), attributes.getValue(i).trim());
            if (xMLAttribute == null) {
                xMLAttribute = xMLAttribute3;
            }
            if (xMLAttribute2 != null) {
                xMLAttribute2.setNext(xMLAttribute3);
            }
            xMLAttribute2 = xMLAttribute3;
        }
        this._inProgress.push(new XMLNode(string3, xMLAttribute));
        this._characters = null;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4;
        XMLNode xMLNode = this._inProgress.pop();
        if (xMLNode != null && xMLNode.getNested() != null && this._characters != null && ((string4 = this._characters.trim()) == null || string4.length() == 0)) {
            this._characters = null;
        }
        if (this._characters != null && this._characters.trim().length() > 0) {
            this.addChild(xMLNode, new XMLNode(this._characters));
        }
        if (this._inProgress.isEmpty()) {
            this._root = xMLNode;
        } else {
            this.addChild(this._inProgress.peek(), xMLNode);
        }
        this._characters = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this._characters = this._characters == null ? string : this._characters + string;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this._characters = this._characters == null ? string : this._characters + string;
    }

    private void addChild(XMLNode xMLNode, XMLNode xMLNode2) {
        xMLNode2.setParent(xMLNode);
        XMLNode xMLNode3 = xMLNode.getNested();
        if (xMLNode3 == null) {
            xMLNode.setNested(xMLNode2);
        } else {
            while (xMLNode3.getNext() != null) {
                xMLNode3 = xMLNode3.getNext();
            }
            xMLNode3.setNext(xMLNode2);
        }
    }
}

