/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import sun.font.FontUtilities;
import sun.font.TrueTypeFont;

abstract class CMap {
    static final short ShiftJISEncoding = 2;
    static final short GBKEncoding = 3;
    static final short Big5Encoding = 4;
    static final short WansungEncoding = 5;
    static final short JohabEncoding = 6;
    static final short MSUnicodeSurrogateEncoding = 10;
    static final char noSuchChar = '\ufffd';
    static final int SHORTMASK = 65535;
    static final int INTMASK = -1;
    static final char[][] converterMaps = new char[7][];
    char[] xlat;
    public static final NullCMapClass theNullCmap = new NullCMapClass();

    CMap() {
    }

    static CMap initialize(TrueTypeFont trueTypeFont) {
        CMap cMap = null;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl = false;
        ByteBuffer byteBuffer = trueTypeFont.getTableBuffer(1668112752);
        int n10 = trueTypeFont.getTableSize(1668112752);
        int n11 = byteBuffer.getShort(2);
        block10: for (int i = 0; i < n11; ++i) {
            byteBuffer.position(i * 8 + 4);
            short s = byteBuffer.getShort();
            if (s != 3) continue;
            bl = true;
            n = byteBuffer.getShort();
            int n12 = byteBuffer.getInt();
            switch (n) {
                case 0: {
                    n2 = n12;
                    continue block10;
                }
                case 1: {
                    n3 = n12;
                    continue block10;
                }
                case 2: {
                    n4 = n12;
                    continue block10;
                }
                case 3: {
                    n5 = n12;
                    continue block10;
                }
                case 4: {
                    n6 = n12;
                    continue block10;
                }
                case 5: {
                    n7 = n12;
                    continue block10;
                }
                case 6: {
                    n8 = n12;
                    continue block10;
                }
                case 10: {
                    n9 = n12;
                }
            }
        }
        if (bl) {
            if (n9 != 0) {
                cMap = CMap.createCMap(byteBuffer, n9, null);
            } else if (n2 != 0) {
                cMap = CMap.createCMap(byteBuffer, n2, null);
            } else if (n3 != 0) {
                cMap = CMap.createCMap(byteBuffer, n3, null);
            } else if (n4 != 0) {
                cMap = CMap.createCMap(byteBuffer, n4, CMap.getConverterMap((short)2));
            } else if (n5 != 0) {
                cMap = CMap.createCMap(byteBuffer, n5, CMap.getConverterMap((short)3));
            } else if (n6 != 0) {
                cMap = FontUtilities.isSolaris && trueTypeFont.platName != null && (trueTypeFont.platName.startsWith("/usr/openwin/lib/locale/zh_CN.EUC/X11/fonts/TrueType") || trueTypeFont.platName.startsWith("/usr/openwin/lib/locale/zh_CN/X11/fonts/TrueType") || trueTypeFont.platName.startsWith("/usr/openwin/lib/locale/zh/X11/fonts/TrueType")) ? CMap.createCMap(byteBuffer, n6, CMap.getConverterMap((short)3)) : CMap.createCMap(byteBuffer, n6, CMap.getConverterMap((short)4));
            } else if (n7 != 0) {
                cMap = CMap.createCMap(byteBuffer, n7, CMap.getConverterMap((short)5));
            } else if (n8 != 0) {
                cMap = CMap.createCMap(byteBuffer, n8, CMap.getConverterMap((short)6));
            }
        } else {
            cMap = CMap.createCMap(byteBuffer, byteBuffer.getInt(8), null);
        }
        return cMap;
    }

    static char[] getConverter(short s) {
        String string;
        int n = 32768;
        int n2 = 65535;
        switch (s) {
            case 2: {
                n = 33088;
                n2 = 64764;
                string = "SJIS";
                break;
            }
            case 3: {
                n = 33088;
                n2 = 65184;
                string = "GBK";
                break;
            }
            case 4: {
                n = 41280;
                n2 = 65278;
                string = "Big5";
                break;
            }
            case 5: {
                n = 41377;
                n2 = 65246;
                string = "EUC_KR";
                break;
            }
            case 6: {
                n = 33089;
                n2 = 65022;
                string = "Johab";
                break;
            }
            default: {
                return null;
            }
        }
        try {
            int n3;
            char[] cArray = new char[65536];
            for (int i = 0; i < 65536; ++i) {
                cArray[i] = 65533;
            }
            byte[] byArray = new byte[(n2 - n + 1) * 2];
            char[] cArray2 = new char[n2 - n + 1];
            int n4 = 0;
            if (s == 2) {
                for (n3 = n; n3 <= n2; ++n3) {
                    int n5 = n3 >> 8 & 0xFF;
                    if (n5 >= 161 && n5 <= 223) {
                        byArray[n4++] = -1;
                        byArray[n4++] = -1;
                        continue;
                    }
                    byArray[n4++] = (byte)n5;
                    byArray[n4++] = (byte)(n3 & 0xFF);
                }
            } else {
                for (n3 = n; n3 <= n2; ++n3) {
                    byArray[n4++] = (byte)(n3 >> 8 & 0xFF);
                    byArray[n4++] = (byte)(n3 & 0xFF);
                }
            }
            Charset.forName(string).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("\u0000").decode(ByteBuffer.wrap(byArray, 0, byArray.length), CharBuffer.wrap(cArray2, 0, cArray2.length), true);
            for (n3 = 32; n3 <= 126; ++n3) {
                cArray[n3] = (char)n3;
            }
            if (s == 2) {
                for (n3 = 161; n3 <= 223; ++n3) {
                    cArray[n3] = (char)(n3 - 161 + 65377);
                }
            }
            System.arraycopy(cArray2, 0, cArray, n, cArray2.length);
            char[] cArray3 = new char[65536];
            for (int i = 0; i < 65536; ++i) {
                if (cArray[i] == '\ufffd') continue;
                cArray3[cArray[i]] = (char)i;
            }
            return cArray3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static char[] getConverterMap(short s) {
        if (converterMaps[s] == null) {
            CMap.converterMaps[s] = CMap.getConverter(s);
        }
        return converterMaps[s];
    }

    static CMap createCMap(ByteBuffer byteBuffer, int n, char[] cArray) {
        char c = byteBuffer.getChar(n);
        long l = c < '\b' ? (long)byteBuffer.getChar(n + 2) : (long)(byteBuffer.getInt(n + 4) & 0xFFFFFFFF);
        if ((long)n + l > (long)byteBuffer.capacity() && FontUtilities.isLogging()) {
            FontUtilities.getLogger().warning("Cmap subtable overflows buffer.");
        }
        switch (c) {
            case '\u0000': {
                return new CMapFormat0(byteBuffer, n);
            }
            case '\u0002': {
                return new CMapFormat2(byteBuffer, n, cArray);
            }
            case '\u0004': {
                return new CMapFormat4(byteBuffer, n, cArray);
            }
            case '\u0006': {
                return new CMapFormat6(byteBuffer, n, cArray);
            }
            case '\b': {
                return new CMapFormat8(byteBuffer, n, cArray);
            }
            case '\n': {
                return new CMapFormat10(byteBuffer, n, cArray);
            }
            case '\f': {
                return new CMapFormat12(byteBuffer, n, cArray);
            }
        }
        throw new RuntimeException("Cmap format unimplemented: " + byteBuffer.getChar(n));
    }

    abstract char getGlyph(int var1);

    final int getControlCodeGlyph(int n, boolean bl) {
        if (n < 16) {
            switch (n) {
                case 9: 
                case 10: 
                case 13: {
                    return 65535;
                }
            }
        } else if (n >= 8204) {
            if (n <= 8207 || n >= 8232 && n <= 8238 || n >= 8298 && n <= 8303) {
                return 65535;
            }
            if (bl && n >= 65535) {
                return 0;
            }
        }
        return -1;
    }

    static class CMapFormat0
    extends CMap {
        byte[] cmap;

        CMapFormat0(ByteBuffer byteBuffer, int n) {
            char c = byteBuffer.getChar(n + 2);
            this.cmap = new byte[c - 6];
            byteBuffer.position(n + 6);
            byteBuffer.get(this.cmap);
        }

        @Override
        char getGlyph(int n) {
            if (n < 256) {
                if (n < 16) {
                    switch (n) {
                        case 9: 
                        case 10: 
                        case 13: {
                            return '\uffff';
                        }
                    }
                }
                return (char)(0xFF & this.cmap[n]);
            }
            return '\u0000';
        }
    }

    static class CMapFormat10
    extends CMap {
        long firstCode;
        int entryCount;
        char[] glyphIdArray;

        CMapFormat10(ByteBuffer byteBuffer, int n, char[] cArray) {
            this.firstCode = byteBuffer.getInt() & 0xFFFFFFFF;
            this.entryCount = byteBuffer.getInt() & 0xFFFFFFFF;
            byteBuffer.position(n + 20);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            this.glyphIdArray = new char[this.entryCount];
            for (int i = 0; i < this.entryCount; ++i) {
                this.glyphIdArray[i] = charBuffer.get();
            }
        }

        @Override
        char getGlyph(int n) {
            if (this.xlat != null) {
                throw new RuntimeException("xlat array for cmap fmt=10");
            }
            int n2 = (int)((long)n - this.firstCode);
            if (n2 < 0 || n2 >= this.entryCount) {
                return '\u0000';
            }
            return this.glyphIdArray[n2];
        }
    }

    static class CMapFormat12
    extends CMap {
        int numGroups;
        int highBit = 0;
        int power;
        int extra;
        long[] startCharCode;
        long[] endCharCode;
        int[] startGlyphID;

        CMapFormat12(ByteBuffer byteBuffer, int n, char[] cArray) {
            int n2;
            if (cArray != null) {
                throw new RuntimeException("xlat array for cmap fmt=12");
            }
            this.numGroups = byteBuffer.getInt(n + 12);
            this.startCharCode = new long[this.numGroups];
            this.endCharCode = new long[this.numGroups];
            this.startGlyphID = new int[this.numGroups];
            byteBuffer.position(n + 16);
            byteBuffer = byteBuffer.slice();
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (n2 = 0; n2 < this.numGroups; ++n2) {
                this.startCharCode[n2] = intBuffer.get() & 0xFFFFFFFF;
                this.endCharCode[n2] = intBuffer.get() & 0xFFFFFFFF;
                this.startGlyphID[n2] = intBuffer.get() & 0xFFFFFFFF;
            }
            n2 = this.numGroups;
            if (n2 >= 65536) {
                n2 >>= 16;
                this.highBit += 16;
            }
            if (n2 >= 256) {
                n2 >>= 8;
                this.highBit += 8;
            }
            if (n2 >= 16) {
                n2 >>= 4;
                this.highBit += 4;
            }
            if (n2 >= 4) {
                n2 >>= 2;
                this.highBit += 2;
            }
            if (n2 >= 2) {
                n2 >>= 1;
                ++this.highBit;
            }
            this.power = 1 << this.highBit;
            this.extra = this.numGroups - this.power;
        }

        @Override
        char getGlyph(int n) {
            int n2 = this.getControlCodeGlyph(n, false);
            if (n2 >= 0) {
                return (char)n2;
            }
            int n3 = this.power;
            int n4 = 0;
            if (this.startCharCode[this.extra] <= (long)n) {
                n4 = this.extra;
            }
            while (n3 > 1) {
                if (this.startCharCode[n4 + (n3 >>= 1)] > (long)n) continue;
                n4 += n3;
            }
            if (this.startCharCode[n4] <= (long)n && this.endCharCode[n4] >= (long)n) {
                return (char)((long)this.startGlyphID[n4] + ((long)n - this.startCharCode[n4]));
            }
            return '\u0000';
        }
    }

    static class CMapFormat2
    extends CMap {
        char[] subHeaderKey = new char[256];
        char[] firstCodeArray;
        char[] entryCountArray;
        short[] idDeltaArray;
        char[] idRangeOffSetArray;
        char[] glyphIndexArray;

        CMapFormat2(ByteBuffer byteBuffer, int n, char[] cArray) {
            int n2;
            int n3;
            this.xlat = cArray;
            char c = byteBuffer.getChar(n + 2);
            byteBuffer.position(n + 6);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            char c2 = '\u0000';
            for (n3 = 0; n3 < 256; ++n3) {
                this.subHeaderKey[n3] = charBuffer.get();
                if (this.subHeaderKey[n3] <= c2) continue;
                c2 = this.subHeaderKey[n3];
            }
            n3 = (c2 >> 3) + 1;
            this.firstCodeArray = new char[n3];
            this.entryCountArray = new char[n3];
            this.idDeltaArray = new short[n3];
            this.idRangeOffSetArray = new char[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.firstCodeArray[n2] = charBuffer.get();
                this.entryCountArray[n2] = charBuffer.get();
                this.idDeltaArray[n2] = (short)charBuffer.get();
                this.idRangeOffSetArray[n2] = charBuffer.get();
            }
            n2 = (c - 518 - n3 * 8) / 2;
            this.glyphIndexArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                this.glyphIndexArray[i] = charBuffer.get();
            }
        }

        @Override
        char getGlyph(int n) {
            int n2;
            int n3;
            char c;
            char c2;
            int n4 = this.getControlCodeGlyph(n, true);
            if (n4 >= 0) {
                return (char)n4;
            }
            if (this.xlat != null) {
                n = this.xlat[n];
            }
            char c3 = (char)(n >> 8);
            char c4 = (char)(n & 0xFF);
            int n5 = this.subHeaderKey[c3] >> 3;
            if (n5 != 0) {
                c2 = c4;
            } else {
                c2 = c3;
                if (c2 == '\u0000') {
                    c2 = c4;
                }
            }
            char c5 = this.firstCodeArray[n5];
            if (c2 < c5) {
                return '\u0000';
            }
            if ((c2 = (char)(c2 - c5)) < this.entryCountArray[n5] && (c = this.glyphIndexArray[(n3 = (this.idRangeOffSetArray[n5] - (n2 = (this.idRangeOffSetArray.length - n5) * 8 - 6)) / 2) + c2]) != '\u0000') {
                c = (char)(c + this.idDeltaArray[n5]);
                return c;
            }
            return '\u0000';
        }
    }

    static class CMapFormat4
    extends CMap {
        int segCount;
        int entrySelector;
        int rangeShift;
        char[] endCount;
        char[] startCount;
        short[] idDelta;
        char[] idRangeOffset;
        char[] glyphIds;

        CMapFormat4(ByteBuffer byteBuffer, int n, char[] cArray) {
            int n2;
            int n3;
            this.xlat = cArray;
            byteBuffer.position(n);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            charBuffer.get();
            int n4 = charBuffer.get();
            if (n + n4 > byteBuffer.capacity()) {
                n4 = byteBuffer.capacity() - n;
            }
            charBuffer.get();
            this.segCount = charBuffer.get() / 2;
            char c = charBuffer.get();
            this.entrySelector = charBuffer.get();
            this.rangeShift = charBuffer.get() / 2;
            this.startCount = new char[this.segCount];
            this.endCount = new char[this.segCount];
            this.idDelta = new short[this.segCount];
            this.idRangeOffset = new char[this.segCount];
            for (n3 = 0; n3 < this.segCount; ++n3) {
                this.endCount[n3] = charBuffer.get();
            }
            charBuffer.get();
            for (n3 = 0; n3 < this.segCount; ++n3) {
                this.startCount[n3] = charBuffer.get();
            }
            for (n3 = 0; n3 < this.segCount; ++n3) {
                this.idDelta[n3] = (short)charBuffer.get();
            }
            for (n3 = 0; n3 < this.segCount; ++n3) {
                n2 = charBuffer.get();
                this.idRangeOffset[n3] = (char)(n2 >> 1 & 0xFFFF);
            }
            n3 = (this.segCount * 8 + 16) / 2;
            charBuffer.position(n3);
            n2 = n4 / 2 - n3;
            this.glyphIds = new char[n2];
            for (int i = 0; i < n2; ++i) {
                this.glyphIds[i] = charBuffer.get();
            }
        }

        @Override
        char getGlyph(int n) {
            int n2 = 0;
            char c = '\u0000';
            int n3 = this.getControlCodeGlyph(n, true);
            if (n3 >= 0) {
                return (char)n3;
            }
            if (this.xlat != null) {
                n = this.xlat[n];
            }
            int n4 = 0;
            int n5 = this.startCount.length;
            n2 = this.startCount.length >> 1;
            while (n4 < n5) {
                if (this.endCount[n2] < n) {
                    n4 = n2 + 1;
                } else {
                    n5 = n2;
                }
                n2 = n4 + n5 >> 1;
            }
            if (n >= this.startCount[n2] && n <= this.endCount[n2]) {
                char c2 = this.idRangeOffset[n2];
                if (c2 == '\u0000') {
                    c = (char)(n + this.idDelta[n2]);
                } else {
                    int n6 = c2 - this.segCount + n2 + (n - this.startCount[n2]);
                    c = this.glyphIds[n6];
                    if (c != '\u0000') {
                        c = (char)(c + this.idDelta[n2]);
                    }
                }
            }
            if (c != '\u0000') {
                // empty if block
            }
            return c;
        }
    }

    static class CMapFormat6
    extends CMap {
        char firstCode;
        char entryCount;
        char[] glyphIdArray;

        CMapFormat6(ByteBuffer byteBuffer, int n, char[] cArray) {
            byteBuffer.position(n + 6);
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            this.firstCode = charBuffer.get();
            this.entryCount = charBuffer.get();
            this.glyphIdArray = new char[this.entryCount];
            for (int i = 0; i < this.entryCount; ++i) {
                this.glyphIdArray[i] = charBuffer.get();
            }
        }

        @Override
        char getGlyph(int n) {
            int n2 = this.getControlCodeGlyph(n, true);
            if (n2 >= 0) {
                return (char)n2;
            }
            if (this.xlat != null) {
                n = this.xlat[n];
            }
            if ((n -= this.firstCode) < 0 || n >= this.entryCount) {
                return '\u0000';
            }
            return this.glyphIdArray[n];
        }
    }

    static class CMapFormat8
    extends CMap {
        byte[] is32 = new byte[8192];
        int nGroups;
        int[] startCharCode;
        int[] endCharCode;
        int[] startGlyphID;

        CMapFormat8(ByteBuffer byteBuffer, int n, char[] cArray) {
            byteBuffer.position(12);
            byteBuffer.get(this.is32);
            this.nGroups = byteBuffer.getInt();
            this.startCharCode = new int[this.nGroups];
            this.endCharCode = new int[this.nGroups];
            this.startGlyphID = new int[this.nGroups];
        }

        @Override
        char getGlyph(int n) {
            if (this.xlat != null) {
                throw new RuntimeException("xlat array for cmap fmt=8");
            }
            return '\u0000';
        }
    }

    static class NullCMapClass
    extends CMap {
        NullCMapClass() {
        }

        @Override
        char getGlyph(int n) {
            return '\u0000';
        }
    }
}

