// Sample for GR-PEACH
//
// Required hardware: Ethernet or ESP32, A0 input and following files stored in SD
//  index.htm : http://gadget.renesas.com/software/peach2/index.htm
//  mbedrpc.js : http://gadget.renesas.com/software/peach2/mbedrpc.js
//
// Public Domain

#include <Arduino.h>
#include "HTTPServer.h"
#include "mbed_rpc.h"
#include "SdUsbConnect.h"

#define USE_WIFI

#ifdef USE_WIFI
#include "ESP32Interface.h"
ESP32Interface network;
#define WLAN_SSID            ("xxxxxxxx")
#define WLAN_PSK             ("xxxxxxxx")
#define WLAN_SECURITY        NSAPI_SECURITY_WPA_WPA2
#else
#include "EthernetInterface.h"
EthernetInterface network;
#endif

/** Network setting **/
#define USE_DHCP               (1)
#if (USE_DHCP == 0)
#define IP_ADDRESS           ("192.168.11.2")     /* IP address      */
#define SUBNET_MASK          ("255.255.255.0")    /* Subnet mask     */
#define DEFAULT_GATEWAY      ("192.168.11.3")     /* Default gateway */
#endif

SdUsbConnect storage("storage");
void AnalogRead(Arguments* arg, Reply* r);
int char_to_int(char* c, int len);

int char_to_int(char* c, int len){
  int r = 0;
  for (int i = 0; i < len; i++) {
    if (c[i] == 0) break;
    r = r * 10 + c[i] - '0';
  }
  return r;
}

void AnalogRead(Arguments* arg, Reply* r){

  int pin;
  int ret;
  char rpc_analogread_buf[4];

  if (arg != NULL) {
    pin = char_to_int(arg->argv[0], 2);

    /* command analysis and execute */
    ret = analogRead(pin);
    sprintf(rpc_analogread_buf, "%d", ret);
    r->putData<const char*>(rpc_analogread_buf);
    //delay(1);
  }
}

void setup(void) {

  Serial.begin(9600);
  Serial.println("********* PROGRAM START ***********");

  // SD & USB
  Serial.print("Finding strage..");
  storage.wait_connect();
  Serial.println("done");

  RPCFunction rpc_sensorread(&AnalogRead, "AnalogRead");

  Serial.print("Network Setting up...\r\n");
#if (USE_DHCP == 0)
  network.set_dhcp(false);
  if (network.set_network(IP_ADDRESS, SUBNET_MASK, DEFAULT_GATEWAY) != 0) { //for Static IP Address (IPAddress, NetMasks, Gateway)
    Serial.println("Error");
  }
#endif
#ifdef USE_WIFI
  network.set_credentials(WLAN_SSID, WLAN_PSK, WLAN_SECURITY);
#endif
  if (network.connect() != 0) {
    return;
  }

  Serial.print("MAC Address is ");
  Serial.println(network.get_mac_address());
  Serial.print("IP Address is ");
  Serial.println(network.get_ip_address());
  Serial.print("NetMask is ");
  Serial.println(network.get_netmask());
  Serial.print("Gateway Address is ");
  Serial.println(network.get_gateway());
  Serial.println("Network Setup OK\r\n");

  FSHandler::mount("/storage", "/");
  HTTPServerAddHandler<FSHandler>("/");
  HTTPServerAddHandler<RPCHandler>("/rpc");
  HTTPServerStart(&network, 80);

}

void loop() {
}


