/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.util.ValueArray;
import com.sun.xml.internal.fastinfoset.util.ValueArrayResourceException;

public class StringArray
extends ValueArray {
    public String[] _array;
    private StringArray _readOnlyArray;
    private boolean _clear;

    public StringArray(int n, int n2, boolean bl) {
        this._array = new String[n];
        this._maximumCapacity = n2;
        this._clear = bl;
    }

    public StringArray() {
        this(10, Integer.MAX_VALUE, false);
    }

    @Override
    public final void clear() {
        if (this._clear) {
            for (int i = this._readOnlyArraySize; i < this._size; ++i) {
                this._array[i] = null;
            }
        }
        this._size = this._readOnlyArraySize;
    }

    public final String[] getArray() {
        if (this._array == null) {
            return null;
        }
        String[] stringArray = new String[this._array.length];
        System.arraycopy(this._array, 0, stringArray, 0, this._array.length);
        return stringArray;
    }

    @Override
    public final void setReadOnlyArray(ValueArray valueArray, boolean bl) {
        if (!(valueArray instanceof StringArray)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{valueArray}));
        }
        this.setReadOnlyArray((StringArray)valueArray, bl);
    }

    public final void setReadOnlyArray(StringArray stringArray, boolean bl) {
        if (stringArray != null) {
            this._readOnlyArray = stringArray;
            this._readOnlyArraySize = stringArray.getSize();
            if (bl) {
                this.clear();
            }
            this._array = this.getCompleteArray();
            this._size = this._readOnlyArraySize;
        }
    }

    public final String[] getCompleteArray() {
        if (this._readOnlyArray == null) {
            return this.getArray();
        }
        String[] stringArray = this._readOnlyArray.getCompleteArray();
        String[] stringArray2 = new String[this._readOnlyArraySize + this._array.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, this._readOnlyArraySize);
        return stringArray2;
    }

    public final String get(int n) {
        return this._array[n];
    }

    public final int add(String string) {
        if (this._size == this._array.length) {
            this.resize();
        }
        this._array[this._size++] = string;
        return this._size;
    }

    protected final void resize() {
        if (this._size == this._maximumCapacity) {
            throw new ValueArrayResourceException(CommonResourceBundle.getInstance().getString("message.arrayMaxCapacity"));
        }
        int n = this._size * 3 / 2 + 1;
        if (n > this._maximumCapacity) {
            n = this._maximumCapacity;
        }
        String[] stringArray = new String[n];
        System.arraycopy(this._array, 0, stringArray, 0, this._size);
        this._array = stringArray;
    }
}

