/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public final class SketchImportUtility {
    private static final String FORMAT_GET_PROJECT_INFO = "http://tool-cloud2.renesas.com/system/api/?key=%s&module=projects&action=list";
    private static final String FORMAT_GET_PROJECT_FILE_LIST = "http://tool-cloud2.renesas.com/system/api/?key=%s&module=structure&action=list&project=%s&path=%s";
    private static final String FORMAT_GET_FILE = "http://tool-cloud2.renesas.com/system/api/?key=%s&module=object&action=getdata&project=%s&path=%s&name=%s";
    public static final String JSON_KEY_NAME = "name";
    public static final String JSON_KEY_PATH = "path";
    public static final String JSON_KEY_TYPE = "type";
    public static final String JSON_KEY_STRUCTURE = "structure";
    public static final String FILE_TYPE_1 = "1";
    public static final String FILE_TYPE_2 = "2";
    public static final String PATH_SEPARATOR = "/";
    public static final int CODE_GET_PROJECT_INFO = 0;
    public static final int CODE_GET_IMPORT_FILE = 1;

    private static String getString(String url, String crlf) throws IOException {
        StringBuilder result = new StringBuilder();
        URL targetUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)targetUrl.openConnection();
        connection.setRequestMethod("GET");
        if (connection.getResponseCode() == 200) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                    result.append(crlf);
                }
            }
        }
        return result.toString();
    }

    public static String getProjcetInfo(String apiKey) throws IOException {
        Formatter formatter = new Formatter();
        formatter.format(FORMAT_GET_PROJECT_INFO, apiKey);
        return SketchImportUtility.getString(formatter.toString(), "");
    }

    public static String[] getProjectFiles(String apiKey, String projectName, String projectPath) throws IOException {
        JSONObject structure;
        ArrayList<String> result = new ArrayList<String>();
        Formatter formatter = new Formatter();
        formatter.format(FORMAT_GET_PROJECT_FILE_LIST, apiKey, projectName, projectPath);
        String info = SketchImportUtility.getString(formatter.toString(), "");
        if (info != null && 0 < info.length() && (structure = JSONObject.fromObject((Object)info)).containsKey((Object)JSON_KEY_STRUCTURE)) {
            JSONArray array = structure.getJSONArray(JSON_KEY_STRUCTURE);
            for (JSONObject project : array) {
                if (!project.containsKey((Object)JSON_KEY_TYPE)) continue;
                String type = project.getString(JSON_KEY_TYPE);
                String name = project.getString(JSON_KEY_NAME);
                if (type.equals(FILE_TYPE_2)) {
                    if (!name.endsWith(".c") && !name.endsWith(".cpp")) continue;
                    result.add(name);
                    continue;
                }
                if (!type.equals(FILE_TYPE_1)) continue;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getFile(String apiKey, String name, String path, String target) throws IOException {
        Formatter formatter = new Formatter();
        formatter.format(FORMAT_GET_FILE, apiKey, name, path, target);
        return SketchImportUtility.getString(formatter.toString(), SketchImportUtility.getSeparator());
    }

    public static String getSeparator() {
        return System.getProperty("line.separator");
    }
}

