/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.util.ArrayList;
import java.util.Map;

public class StringReplacer {
    public static String[] formatAndSplit(String src, Map<String, String> dict, boolean recursive) throws Exception {
        for (int i = 0; i < 10; ++i) {
            String res = StringReplacer.replaceFromMapping(src, dict);
            if (!recursive || res.equals(src)) break;
            src = res;
        }
        return StringReplacer.quotedSplit(src, "\"'", false);
    }

    public static String[] quotedSplit(String src, String quoteChars, boolean acceptEmptyArguments) throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        String escapedArg = null;
        String escapingChar = null;
        for (String i : src.split(" ")) {
            if (escapingChar == null) {
                String first = null;
                if (i.length() > 0) {
                    first = i.substring(0, 1);
                }
                if (first == null || !quoteChars.contains(first)) {
                    if (i.trim().length() == 0 && !acceptEmptyArguments) continue;
                    res.add(i);
                    continue;
                }
                escapingChar = first;
                i = i.substring(1);
                escapedArg = "";
            }
            if (!i.endsWith(escapingChar)) {
                escapedArg = escapedArg + i + " ";
                continue;
            }
            if ((escapedArg = escapedArg + i.substring(0, i.length() - 1)).trim().length() != 0 || acceptEmptyArguments) {
                res.add(escapedArg);
            }
            escapingChar = null;
        }
        if (escapingChar != null) {
            throw new Exception("Invalid quoting: no closing [" + escapingChar + "] char found.");
        }
        return res.toArray(new String[0]);
    }

    public static String replaceFromMapping(String src, Map<String, String> map) {
        return StringReplacer.replaceFromMapping(src, map, "{", "}");
    }

    public static String replaceFromMapping(String src, Map<String, String> map, String leftDelimiter, String rightDelimiter) {
        for (String k : map.keySet()) {
            String keyword = leftDelimiter + k + rightDelimiter;
            src = src.replace(keyword, map.get(k));
        }
        return src;
    }
}

