/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;

public class PPolygon
implements PConstants {
    static final int DEFAULT_SIZE = 64;
    float[][] vertices = new float[64][36];
    int vertexCount;
    float[] r = new float[64];
    float[] dr = new float[64];
    float[] l = new float[64];
    float[] dl = new float[64];
    float[] sp = new float[64];
    float[] sdp = new float[64];
    protected boolean interpX;
    protected boolean interpUV;
    protected boolean interpARGB;
    private int rgba;
    private int r2;
    private int g2;
    private int b2;
    private int a2;
    private int a2orig;
    PGraphics parent;
    int[] pixels;
    int width;
    int height;
    int width1;
    int height1;
    PImage timage;
    int[] tpixels;
    int theight;
    int twidth;
    int theight1;
    int twidth1;
    int tformat;
    static final int SUBXRES = 8;
    static final int SUBXRES1 = 7;
    static final int SUBYRES = 8;
    static final int SUBYRES1 = 7;
    static final int MAX_COVERAGE = 64;
    boolean smooth;
    int firstModY;
    int lastModY;
    int lastY;
    int[] aaleft = new int[8];
    int[] aaright = new int[8];
    int aaleftmin;
    int aarightmin;
    int aaleftmax;
    int aarightmax;
    int aaleftfull;
    int aarightfull;

    private final int MODYRES(int y) {
        return y & 7;
    }

    public PPolygon(PGraphics iparent) {
        this.parent = iparent;
        this.reset(0);
    }

    protected void reset(int count) {
        this.vertexCount = count;
        this.interpX = true;
        this.interpUV = false;
        this.interpARGB = true;
        this.timage = null;
    }

    protected float[] nextVertex() {
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
            this.r = new float[this.vertices.length];
            this.dr = new float[this.vertices.length];
            this.l = new float[this.vertices.length];
            this.dl = new float[this.vertices.length];
            this.sp = new float[this.vertices.length];
            this.sdp = new float[this.vertices.length];
        }
        return this.vertices[this.vertexCount++];
    }

    protected void texture(PImage image) {
        this.timage = image;
        if (image != null) {
            this.tpixels = image.pixels;
            this.twidth = image.width;
            this.theight = image.height;
            this.tformat = image.format;
            this.twidth1 = this.twidth - 1;
            this.theight1 = this.theight - 1;
            this.interpUV = true;
        } else {
            this.interpUV = false;
        }
    }

    protected void renderPolygon(float[][] v, int count) {
        this.vertices = v;
        this.vertexCount = count;
        if (this.r.length < this.vertexCount) {
            this.r = new float[this.vertexCount];
            this.dr = new float[this.vertexCount];
            this.l = new float[this.vertexCount];
            this.dl = new float[this.vertexCount];
            this.sp = new float[this.vertexCount];
            this.sdp = new float[this.vertexCount];
        }
        this.render();
        this.checkExpand();
    }

    protected void renderTriangle(float[] v1, float[] v2, float[] v3) {
        this.vertices[0] = v1;
        this.vertices[1] = v2;
        this.vertices[2] = v3;
        this.render();
        this.checkExpand();
    }

    protected void checkExpand() {
        if (this.smooth) {
            for (int i = 0; i < this.vertexCount; ++i) {
                float[] fArray = this.vertices[i];
                fArray[18] = fArray[18] / 8.0f;
                float[] fArray2 = this.vertices[i];
                fArray2[19] = fArray2[19] / 8.0f;
            }
        }
    }

    protected void render() {
        int i;
        if (this.vertexCount < 3) {
            return;
        }
        this.pixels = this.parent.pixels;
        this.smooth = this.parent.smooth;
        this.width = this.smooth ? this.parent.width * 8 : this.parent.width;
        this.height = this.smooth ? this.parent.height * 8 : this.parent.height;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        if (!this.interpARGB) {
            this.r2 = (int)(this.vertices[0][3] * 255.0f);
            this.g2 = (int)(this.vertices[0][4] * 255.0f);
            this.b2 = (int)(this.vertices[0][5] * 255.0f);
            this.a2orig = this.a2 = (int)(this.vertices[0][6] * 255.0f);
            this.rgba = 0xFF000000 | this.r2 << 16 | this.g2 << 8 | this.b2;
        }
        for (i = 0; i < this.vertexCount; ++i) {
            this.r[i] = 0.0f;
            this.dr[i] = 0.0f;
            this.l[i] = 0.0f;
            this.dl[i] = 0.0f;
        }
        if (this.smooth) {
            for (i = 0; i < this.vertexCount; ++i) {
                float[] fArray = this.vertices[i];
                fArray[18] = fArray[18] * 8.0f;
                float[] fArray2 = this.vertices[i];
                fArray2[19] = fArray2[19] * 8.0f;
            }
            this.firstModY = -1;
        }
        int topi = 0;
        float ymin = this.vertices[0][19];
        float ymax = this.vertices[0][19];
        for (int i2 = 1; i2 < this.vertexCount; ++i2) {
            if (this.vertices[i2][19] < ymin) {
                ymin = this.vertices[i2][19];
                topi = i2;
            }
            if (!(this.vertices[i2][19] > ymax)) continue;
            ymax = this.vertices[i2][19];
        }
        this.lastY = (int)(ymax - 0.5f);
        int lefti = topi;
        int righti = topi;
        int y = (int)(ymin + 0.5f);
        int lefty = y - 1;
        int righty = y - 1;
        this.interpX = true;
        int remaining = this.vertexCount;
        while (remaining > 0) {
            int i3;
            while (lefty <= y && remaining > 0) {
                --remaining;
                i3 = lefti != 0 ? lefti - 1 : this.vertexCount - 1;
                this.incrementalizeY(this.vertices[lefti], this.vertices[i3], this.l, this.dl, y);
                lefty = (int)(this.vertices[i3][19] + 0.5f);
                lefti = i3;
            }
            while (righty <= y && remaining > 0) {
                --remaining;
                i3 = righti != this.vertexCount - 1 ? righti + 1 : 0;
                this.incrementalizeY(this.vertices[righti], this.vertices[i3], this.r, this.dr, y);
                righty = (int)(this.vertices[i3][19] + 0.5f);
                righti = i3;
            }
            while (y < lefty && y < righty) {
                if (y >= 0 && y < this.height) {
                    if (this.l[18] <= this.r[18]) {
                        this.scanline(y, this.l, this.r);
                    } else {
                        this.scanline(y, this.r, this.l);
                    }
                }
                ++y;
                this.increment(this.l, this.dl);
                this.increment(this.r, this.dr);
            }
        }
    }

    private void scanline(int y, float[] l, float[] r) {
        int rx;
        for (int i = 0; i < this.vertexCount; ++i) {
            this.sp[i] = 0.0f;
            this.sdp[i] = 0.0f;
        }
        int lx = (int)(l[18] + 0.49999f);
        if (lx < 0) {
            lx = 0;
        }
        if ((rx = (int)(r[18] - 0.5f)) > this.width1) {
            rx = this.width1;
        }
        if (lx > rx) {
            return;
        }
        if (this.smooth) {
            int mody = this.MODYRES(y);
            this.aaleft[mody] = lx;
            this.aaright[mody] = rx;
            if (this.firstModY == -1) {
                this.firstModY = mody;
                this.aaleftmin = lx;
                this.aaleftmax = lx;
                this.aarightmin = rx;
                this.aarightmax = rx;
            } else {
                if (this.aaleftmin > this.aaleft[mody]) {
                    this.aaleftmin = this.aaleft[mody];
                }
                if (this.aaleftmax < this.aaleft[mody]) {
                    this.aaleftmax = this.aaleft[mody];
                }
                if (this.aarightmin > this.aaright[mody]) {
                    this.aarightmin = this.aaright[mody];
                }
                if (this.aarightmax < this.aaright[mody]) {
                    this.aarightmax = this.aaright[mody];
                }
            }
            this.lastModY = mody;
            if (mody != 7 && y != this.lastY) {
                return;
            }
            this.aaleftfull = this.aaleftmax / 8 + 1;
            this.aarightfull = this.aarightmin / 8 - 1;
        }
        this.incrementalizeX(l, r, this.sp, this.sdp, lx);
        int offset = this.smooth ? this.parent.width * (y / 8) : this.parent.width * y;
        int truelx = 0;
        int truerx = 0;
        if (this.smooth) {
            truelx = lx / 8;
            truerx = (rx + 7) / 8;
            lx = this.aaleftmin / 8;
            rx = (this.aarightmax + 7) / 8;
            if (lx < 0) {
                lx = 0;
            }
            if (rx > this.parent.width1) {
                rx = this.parent.width1;
            }
        }
        this.interpX = false;
        for (int x = lx; x <= rx; ++x) {
            if (this.interpUV) {
                int weight;
                int tb;
                int tg;
                int tr;
                int p11;
                int p10;
                int p01;
                int p00;
                int ta;
                int px1;
                int px0;
                int pixel11;
                int tu = (int)(this.sp[7] * (float)this.twidth);
                int tv = (int)(this.sp[8] * (float)this.theight);
                if (tu > this.twidth1) {
                    tu = this.twidth1;
                }
                if (tv > this.theight1) {
                    tv = this.theight1;
                }
                if (tu < 0) {
                    tu = 0;
                }
                if (tv < 0) {
                    tv = 0;
                }
                int txy = tv * this.twidth + tu;
                int tuf1 = (int)(255.0f * (this.sp[7] * (float)this.twidth - (float)tu));
                int tvf1 = (int)(255.0f * (this.sp[8] * (float)this.theight - (float)tv));
                int tuf = 255 - tuf1;
                int tvf = 255 - tvf1;
                int pixel00 = this.tpixels[txy];
                int pixel01 = tv < this.theight1 ? this.tpixels[txy + this.twidth] : this.tpixels[txy];
                int pixel10 = tu < this.twidth1 ? this.tpixels[txy + 1] : this.tpixels[txy];
                int n = pixel11 = tv < this.theight1 && tu < this.twidth1 ? this.tpixels[txy + this.twidth + 1] : this.tpixels[txy];
                if (this.tformat == 4) {
                    px0 = pixel00 * tuf + pixel10 * tuf1 >> 8;
                    px1 = pixel01 * tuf + pixel11 * tuf1 >> 8;
                    ta = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                } else if (this.tformat == 2) {
                    p00 = pixel00 >> 24 & 0xFF;
                    p01 = pixel01 >> 24 & 0xFF;
                    p10 = pixel10 >> 24 & 0xFF;
                    p11 = pixel11 >> 24 & 0xFF;
                    px0 = p00 * tuf + p10 * tuf1 >> 8;
                    px1 = p01 * tuf + p11 * tuf1 >> 8;
                    ta = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                } else {
                    int n2 = ta = this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig;
                }
                if (this.tformat == 1 || this.tformat == 2) {
                    p00 = pixel00 >> 16 & 0xFF;
                    p01 = pixel01 >> 16 & 0xFF;
                    p10 = pixel10 >> 16 & 0xFF;
                    p11 = pixel11 >> 16 & 0xFF;
                    px0 = p00 * tuf + p10 * tuf1 >> 8;
                    px1 = p01 * tuf + p11 * tuf1 >> 8;
                    tr = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[3] * 255.0f) : this.r2) >> 8;
                    p00 = pixel00 >> 8 & 0xFF;
                    p01 = pixel01 >> 8 & 0xFF;
                    p10 = pixel10 >> 8 & 0xFF;
                    p11 = pixel11 >> 8 & 0xFF;
                    px0 = p00 * tuf + p10 * tuf1 >> 8;
                    px1 = p01 * tuf + p11 * tuf1 >> 8;
                    tg = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[4] * 255.0f) : this.g2) >> 8;
                    p00 = pixel00 & 0xFF;
                    p01 = pixel01 & 0xFF;
                    p10 = pixel10 & 0xFF;
                    p11 = pixel11 & 0xFF;
                    px0 = p00 * tuf + p10 * tuf1 >> 8;
                    px1 = p01 * tuf + p11 * tuf1 >> 8;
                    tb = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[5] * 255.0f) : this.b2) >> 8;
                } else if (this.interpARGB) {
                    tr = (int)(this.sp[3] * 255.0f);
                    tg = (int)(this.sp[4] * 255.0f);
                    tb = (int)(this.sp[5] * 255.0f);
                } else {
                    tr = this.r2;
                    tg = this.g2;
                    tb = this.b2;
                }
                int n3 = weight = this.smooth ? this.coverage(x) : 255;
                if (weight != 255) {
                    ta = ta * weight >> 8;
                }
                if (ta == 254 || ta == 255) {
                    this.pixels[offset + x] = 0xFF000000 | tr << 16 | tg << 8 | tb;
                } else {
                    int a1 = 255 - ta;
                    int r1 = this.pixels[offset + x] >> 16 & 0xFF;
                    int g1 = this.pixels[offset + x] >> 8 & 0xFF;
                    int b1 = this.pixels[offset + x] & 0xFF;
                    this.pixels[offset + x] = 0xFF000000 | tr * ta + r1 * a1 >> 8 << 16 | tg * ta + g1 * a1 & 0xFF00 | tb * ta + b1 * a1 >> 8;
                }
            } else {
                int weight;
                int n = weight = this.smooth ? this.coverage(x) : 255;
                if (this.interpARGB) {
                    this.r2 = (int)(this.sp[3] * 255.0f);
                    this.g2 = (int)(this.sp[4] * 255.0f);
                    this.b2 = (int)(this.sp[5] * 255.0f);
                    if (this.sp[6] != 1.0f) {
                        weight = weight * (int)(this.sp[6] * 255.0f) >> 8;
                    }
                    if (weight == 255) {
                        this.rgba = 0xFF000000 | this.r2 << 16 | this.g2 << 8 | this.b2;
                    }
                } else if (this.a2orig != 255) {
                    weight = weight * this.a2orig >> 8;
                }
                if (weight == 255) {
                    this.pixels[offset + x] = this.rgba;
                } else {
                    int r1 = this.pixels[offset + x] >> 16 & 0xFF;
                    int g1 = this.pixels[offset + x] >> 8 & 0xFF;
                    int b1 = this.pixels[offset + x] & 0xFF;
                    this.a2 = weight;
                    int a1 = 255 - this.a2;
                    this.pixels[offset + x] = 0xFF000000 | r1 * a1 + this.r2 * this.a2 >> 8 << 16 | g1 * a1 + this.g2 * this.a2 >> 8 << 8 | b1 * a1 + this.b2 * this.a2 >> 8;
                }
            }
            if (this.smooth && (x < truelx || x > truerx)) continue;
            this.increment(this.sp, this.sdp);
        }
        this.firstModY = -1;
        this.interpX = true;
    }

    private int coverage(int x) {
        if (x >= this.aaleftfull && x <= this.aarightfull && this.firstModY == 0 && this.lastModY == 7) {
            return 255;
        }
        int pixelLeft = x * 8;
        int pixelRight = pixelLeft + 8;
        int amt = 0;
        for (int i = this.firstModY; i <= this.lastModY; ++i) {
            if (this.aaleft[i] > pixelRight || this.aaright[i] < pixelLeft) continue;
            amt += (this.aaright[i] < pixelRight ? this.aaright[i] : pixelRight) - (this.aaleft[i] > pixelLeft ? this.aaleft[i] : pixelLeft);
        }
        return (amt <<= 2) == 256 ? 255 : amt;
    }

    private void incrementalizeY(float[] p1, float[] p2, float[] p, float[] dp, int y) {
        float delta = p2[19] - p1[19];
        if (delta == 0.0f) {
            delta = 1.0f;
        }
        float fraction = (float)y + 0.5f - p1[19];
        if (this.interpX) {
            dp[18] = (p2[18] - p1[18]) / delta;
            p[18] = p1[18] + dp[18] * fraction;
        }
        if (this.interpARGB) {
            dp[3] = (p2[3] - p1[3]) / delta;
            dp[4] = (p2[4] - p1[4]) / delta;
            dp[5] = (p2[5] - p1[5]) / delta;
            dp[6] = (p2[6] - p1[6]) / delta;
            p[3] = p1[3] + dp[3] * fraction;
            p[4] = p1[4] + dp[4] * fraction;
            p[5] = p1[5] + dp[5] * fraction;
            p[6] = p1[6] + dp[6] * fraction;
        }
        if (this.interpUV) {
            dp[7] = (p2[7] - p1[7]) / delta;
            dp[8] = (p2[8] - p1[8]) / delta;
            p[7] = p1[7] + dp[7] * fraction;
            p[8] = p1[8] + dp[8] * fraction;
        }
    }

    private void incrementalizeX(float[] p1, float[] p2, float[] p, float[] dp, int x) {
        float delta = p2[18] - p1[18];
        if (delta == 0.0f) {
            delta = 1.0f;
        }
        float fraction = (float)x + 0.5f - p1[18];
        if (this.smooth) {
            delta /= 8.0f;
            fraction /= 8.0f;
        }
        if (this.interpX) {
            dp[18] = (p2[18] - p1[18]) / delta;
            p[18] = p1[18] + dp[18] * fraction;
        }
        if (this.interpARGB) {
            dp[3] = (p2[3] - p1[3]) / delta;
            dp[4] = (p2[4] - p1[4]) / delta;
            dp[5] = (p2[5] - p1[5]) / delta;
            dp[6] = (p2[6] - p1[6]) / delta;
            p[3] = p1[3] + dp[3] * fraction;
            p[4] = p1[4] + dp[4] * fraction;
            p[5] = p1[5] + dp[5] * fraction;
            p[6] = p1[6] + dp[6] * fraction;
        }
        if (this.interpUV) {
            dp[7] = (p2[7] - p1[7]) / delta;
            dp[8] = (p2[8] - p1[8]) / delta;
            p[7] = p1[7] + dp[7] * fraction;
            p[8] = p1[8] + dp[8] * fraction;
        }
    }

    private void increment(float[] p, float[] dp) {
        if (this.interpX) {
            p[18] = p[18] + dp[18];
        }
        if (this.interpARGB) {
            p[3] = p[3] + dp[3];
            p[4] = p[4] + dp[4];
            p[5] = p[5] + dp[5];
            p[6] = p[6] + dp[6];
        }
        if (this.interpUV) {
            p[7] = p[7] + dp[7];
            p[8] = p[8] + dp[8];
        }
    }
}

