;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text

; +12 code bytes, speeds up shifts of 16+ bits (while slightly slowing -16 ones)
;#define COMPROMISE

; arithmetic right shift
; input/output in BC(high):AX(low) registers
; E contains on entry the number of bit positions to shift
START_FUNC ___ashrsi3

#ifdef COMPROMISE
    cmp   r_4, #16
    bc    $2f
    sub   r_4, #16
    movw  ax, bc
    sarw  ax, 15
    xchw  ax, bc
#endif

2:  cmp0  r_4
    bz    $1f

0:  shrw  ax, 1   ; shift the low part (highest bit missing)
    xchw  ax, bc
    sarw  ax, 1   ; shift the high part (bit 0 into CY)
    xchw  ax, bc
    mov1  a.7, CY ; copy CY to highest bit of the lowest part

    dec   e
    bnz   $0b

1:  ret

END_FUNC ___ashrsi3
