/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.SerialNotFoundException;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;
import processing.app.helpers.ProcessUtils;

public abstract class Uploader
implements MessageConsumer {
    static final String BUGS_URL = I18n._("https://developer.berlios.de/bugs/?group_id=3590");
    static final String SUPER_BADNESS = I18n.format(I18n._("Compiler error, please submit this code to {0}"), BUGS_URL);
    RunnerException exception;
    static InputStream serialInput;
    static OutputStream serialOutput;
    boolean verbose;
    boolean firstErrorFound;
    boolean secondErrorFound;
    boolean notFoundError;

    public abstract boolean uploadUsingPreferences(String var1, String var2, boolean var3) throws Exception;

    public abstract boolean burnBootloader() throws Exception;

    protected void flushSerialBuffer() throws Exception {
        try {
            Serial serialPort = new Serial();
            while (serialPort.available() > 0) {
                serialPort.readBytes();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            serialPort.setDTR(false);
            serialPort.setRTS(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            serialPort.setDTR(true);
            serialPort.setRTS(true);
            serialPort.dispose();
        }
        catch (SerialNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RunnerException(e.getMessage());
        }
    }

    protected boolean executeUploadCommand(Collection<String> commandDownloader) throws Exception {
        String[] commandArray = new String[commandDownloader.size()];
        commandDownloader.toArray(commandArray);
        return this.executeUploadCommand(commandArray);
    }

    protected boolean executeUploadCommand(String[] commandArray) throws Exception {
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        this.notFoundError = false;
        int result = 0;
        try {
            if (this.verbose || Preferences.getBoolean("upload.verbose")) {
                for (int i = 0; i < commandArray.length; ++i) {
                    System.out.print(commandArray[i] + " ");
                }
                System.out.println();
            }
            Process process = ProcessUtils.exec(commandArray);
            new MessageSiphon(process.getInputStream(), this);
            new MessageSiphon(process.getErrorStream(), this);
            boolean compiling = true;
            while (compiling) {
                try {
                    result = process.waitFor();
                    compiling = false;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.exception != null) {
                this.exception.hideStackTrace();
                throw this.exception;
            }
            if (result != 0) {
                return false;
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.indexOf("uisp: not found") != -1 && msg.indexOf("avrdude: not found") != -1) {
                return false;
            }
            e.printStackTrace();
            result = -1;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (result != 0 && result != 1) {
            this.exception = new RunnerException(SUPER_BADNESS);
        }
        return result == 0;
    }

    @Override
    public void message(String s) {
        if (!(Preferences.getBoolean("upload.verbose") || s.indexOf("Connecting to programmer:") == -1 && s.indexOf("Found programmer: Id = \"CATERIN\"; type = S") == -1 && s.indexOf("Software Version = 1.0; No Hardware Version given.") == -1 && s.indexOf("Programmer supports auto addr increment.") == -1 && s.indexOf("Programmer supports buffered memory access with buffersize=128 bytes.") == -1 && s.indexOf("Programmer supports the following devices:") == -1 && s.indexOf("Device code: 0x44") == -1)) {
            s = "";
        }
        System.err.print(s);
        if (s.indexOf("Error") != -1) {
            this.notFoundError = true;
            return;
        }
        if (this.notFoundError) {
            this.exception = new RunnerException(I18n.format(I18n._("the selected serial port {0} does not exist or your board is not connected"), s));
            return;
        }
        if (s.indexOf("Device is not responding") != -1) {
            this.exception = new RunnerException(I18n._("Device is not responding, check the right serial port is selected or RESET the board right before exporting"));
            return;
        }
        if (s.indexOf("Programmer is not responding") != -1 || s.indexOf("programmer is not responding") != -1 || s.indexOf("protocol error") != -1 || s.indexOf("avrdude: ser_open(): can't open device") != -1 || s.indexOf("avrdude: ser_drain(): read error") != -1 || s.indexOf("avrdude: ser_send(): write error") != -1 || s.indexOf("avrdude: error: buffered memory access not supported.") != -1) {
            this.exception = new RunnerException(I18n._("Problem uploading to board.  See http://www.arduino.cc/en/Guide/Troubleshooting#upload for suggestions."));
            return;
        }
        if (s.indexOf("Expected signature") != -1) {
            this.exception = new RunnerException(I18n._("Wrong microcontroller found.  Did you select the right board from the Tools > Board menu?"));
            return;
        }
    }
}

