/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import processing.xml.CDATAReader;
import processing.xml.ContentReader;
import processing.xml.PIReader;
import processing.xml.StdXMLBuilder;
import processing.xml.StdXMLReader;
import processing.xml.XMLEntityResolver;
import processing.xml.XMLException;
import processing.xml.XMLUtil;
import processing.xml.XMLValidator;

public class StdXMLParser {
    private StdXMLBuilder builder = null;
    private StdXMLReader reader = null;
    private XMLEntityResolver entityResolver = new XMLEntityResolver();
    private XMLValidator validator = null;

    protected void finalize() throws Throwable {
        this.builder = null;
        this.reader = null;
        this.entityResolver = null;
        this.validator = null;
        super.finalize();
    }

    public void setBuilder(StdXMLBuilder builder) {
        this.builder = builder;
    }

    public StdXMLBuilder getBuilder() {
        return this.builder;
    }

    public void setValidator(XMLValidator validator) {
        this.validator = validator;
    }

    public XMLValidator getValidator() {
        return this.validator;
    }

    public void setResolver(XMLEntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public XMLEntityResolver getResolver() {
        return this.entityResolver;
    }

    public void setReader(StdXMLReader reader) {
        this.reader = reader;
    }

    public StdXMLReader getReader() {
        return this.reader;
    }

    public Object parse() throws XMLException {
        try {
            this.builder.startBuilding(this.reader.getSystemID(), this.reader.getLineNr());
            this.scanData();
            return this.builder.getResult();
        }
        catch (XMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XMLException(e);
        }
    }

    protected void scanData() throws Exception {
        block4: while (!this.reader.atEOF() && this.builder.getResult() == null) {
            String str = XMLUtil.read(this.reader, '&');
            char ch = str.charAt(0);
            if (ch == '&') {
                XMLUtil.processEntity(str, this.reader, this.entityResolver);
                continue;
            }
            switch (ch) {
                case '<': {
                    this.scanSomeTag(false, null, new Properties());
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
            }
            XMLUtil.errorInvalidInput(this.reader.getSystemID(), this.reader.getLineNr(), "`" + ch + "' (0x" + Integer.toHexString(ch) + ')');
        }
    }

    protected void scanSomeTag(boolean allowCDATA, String defaultNamespace, Properties namespaces) throws Exception {
        String str = XMLUtil.read(this.reader, '&');
        char ch = str.charAt(0);
        if (ch == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), str);
        }
        switch (ch) {
            case '?': {
                this.processPI();
                break;
            }
            case '!': {
                this.processSpecialTag(allowCDATA);
                break;
            }
            default: {
                this.reader.unread(ch);
                this.processElement(defaultNamespace, namespaces);
            }
        }
    }

    protected void processPI() throws Exception {
        XMLUtil.skipWhitespace(this.reader, null);
        String target = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        PIReader r = new PIReader(this.reader);
        if (!target.equalsIgnoreCase("xml")) {
            this.builder.newProcessingInstruction(target, r);
        }
        ((Reader)r).close();
    }

    protected void processSpecialTag(boolean allowCDATA) throws Exception {
        String str = XMLUtil.read(this.reader, '&');
        char ch = str.charAt(0);
        if (ch == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), str);
        }
        switch (ch) {
            case '[': {
                if (allowCDATA) {
                    this.processCDATA();
                } else {
                    XMLUtil.errorUnexpectedCDATA(this.reader.getSystemID(), this.reader.getLineNr());
                }
                return;
            }
            case 'D': {
                this.processDocType();
                return;
            }
            case '-': {
                XMLUtil.skipComment(this.reader);
                return;
            }
        }
    }

    protected void processCDATA() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "CDATA[")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<![[CDATA[");
        }
        this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
        CDATAReader r = new CDATAReader(this.reader);
        this.builder.addPCData(r, this.reader.getSystemID(), this.reader.getLineNr());
        ((Reader)r).close();
    }

    protected void processDocType() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "OCTYPE")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<!DOCTYPE");
            return;
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String systemID = null;
        StringBuffer publicID = new StringBuffer();
        XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        char ch = this.reader.read();
        if (ch == 'P') {
            systemID = XMLUtil.scanPublicID(publicID, this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            ch = this.reader.read();
        } else if (ch == 'S') {
            systemID = XMLUtil.scanSystemID(this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            ch = this.reader.read();
        }
        if (ch == '[') {
            this.validator.parseDTD(publicID.toString(), this.reader, this.entityResolver, false);
            XMLUtil.skipWhitespace(this.reader, null);
            ch = this.reader.read();
        }
        if (ch != '>') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
        }
    }

    protected void processElement(String defaultNamespace, Properties namespaces) throws Exception {
        String value;
        String key;
        int i;
        char ch;
        String fullName;
        String name = fullName = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        String prefix = null;
        int colonIndex = name.indexOf(58);
        if (colonIndex > 0) {
            prefix = name.substring(0, colonIndex);
            name = name.substring(colonIndex + 1);
        }
        Vector<String> attrNames = new Vector<String>();
        Vector<String> attrValues = new Vector<String>();
        Vector<String> attrTypes = new Vector<String>();
        this.validator.elementStarted(fullName, this.reader.getSystemID(), this.reader.getLineNr());
        while ((ch = this.reader.read()) != '/' && ch != '>') {
            this.reader.unread(ch);
            this.processAttribute(attrNames, attrValues, attrTypes);
            XMLUtil.skipWhitespace(this.reader, null);
        }
        Properties extraAttributes = new Properties();
        this.validator.elementAttributesProcessed(fullName, extraAttributes, this.reader.getSystemID(), this.reader.getLineNr());
        Enumeration<Object> en = extraAttributes.keys();
        while (en.hasMoreElements()) {
            String key2 = (String)en.nextElement();
            String value2 = extraAttributes.getProperty(key2);
            attrNames.addElement(key2);
            attrValues.addElement(value2);
            attrTypes.addElement("CDATA");
        }
        for (i = 0; i < attrNames.size(); ++i) {
            key = attrNames.elementAt(i);
            value = attrValues.elementAt(i);
            if (key.equals("xmlns")) {
                defaultNamespace = value;
                continue;
            }
            if (!key.startsWith("xmlns:")) continue;
            namespaces.put(key.substring(6), value);
        }
        if (prefix == null) {
            this.builder.startElement(name, prefix, defaultNamespace, this.reader.getSystemID(), this.reader.getLineNr());
        } else {
            this.builder.startElement(name, prefix, namespaces.getProperty(prefix), this.reader.getSystemID(), this.reader.getLineNr());
        }
        for (i = 0; i < attrNames.size(); ++i) {
            key = attrNames.elementAt(i);
            if (key.startsWith("xmlns")) continue;
            value = attrValues.elementAt(i);
            String type = attrTypes.elementAt(i);
            colonIndex = key.indexOf(58);
            if (colonIndex > 0) {
                String attPrefix = key.substring(0, colonIndex);
                key = key.substring(colonIndex + 1);
                this.builder.addAttribute(key, attPrefix, namespaces.getProperty(attPrefix), value, type);
                continue;
            }
            this.builder.addAttribute(key, null, null, value, type);
        }
        if (prefix == null) {
            this.builder.elementAttributesProcessed(name, prefix, defaultNamespace);
        } else {
            this.builder.elementAttributesProcessed(name, prefix, namespaces.getProperty(prefix));
        }
        if (ch == '/') {
            if (this.reader.read() != '>') {
                XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
            }
            this.validator.elementEnded(name, this.reader.getSystemID(), this.reader.getLineNr());
            if (prefix == null) {
                this.builder.endElement(name, prefix, defaultNamespace);
            } else {
                this.builder.endElement(name, prefix, namespaces.getProperty(prefix));
            }
            return;
        }
        StringBuffer buffer = new StringBuffer(16);
        while (true) {
            String str;
            buffer.setLength(0);
            while (true) {
                XMLUtil.skipWhitespace(this.reader, buffer);
                str = XMLUtil.read(this.reader, '&');
                if (str.charAt(0) != '&' || str.charAt(1) == '#') break;
                XMLUtil.processEntity(str, this.reader, this.entityResolver);
            }
            if (str.charAt(0) == '<') {
                str = XMLUtil.read(this.reader, '\u0000');
                if (str.charAt(0) == '/') {
                    XMLUtil.skipWhitespace(this.reader, null);
                    str = XMLUtil.scanIdentifier(this.reader);
                    if (!str.equals(fullName)) {
                        XMLUtil.errorWrongClosingTag(this.reader.getSystemID(), this.reader.getLineNr(), name, str);
                    }
                    XMLUtil.skipWhitespace(this.reader, null);
                    if (this.reader.read() != '>') {
                        XMLUtil.errorClosingTagNotEmpty(this.reader.getSystemID(), this.reader.getLineNr());
                    }
                    this.validator.elementEnded(fullName, this.reader.getSystemID(), this.reader.getLineNr());
                    if (prefix == null) {
                        this.builder.endElement(name, prefix, defaultNamespace);
                        break;
                    }
                    this.builder.endElement(name, prefix, namespaces.getProperty(prefix));
                    break;
                }
                this.reader.unread(str.charAt(0));
                this.scanSomeTag(true, defaultNamespace, (Properties)namespaces.clone());
                continue;
            }
            if (str.charAt(0) == '&') {
                ch = XMLUtil.processCharLiteral(str);
                buffer.append(ch);
            } else {
                this.reader.unread(str.charAt(0));
            }
            this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
            ContentReader r = new ContentReader(this.reader, this.entityResolver, buffer.toString());
            this.builder.addPCData(r, this.reader.getSystemID(), this.reader.getLineNr());
            ((Reader)r).close();
        }
    }

    protected void processAttribute(Vector<String> attrNames, Vector<String> attrValues, Vector<String> attrTypes) throws Exception {
        String key = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        if (!XMLUtil.read(this.reader, '&').equals("=")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`='");
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String value = XMLUtil.scanString(this.reader, '&', this.entityResolver);
        attrNames.addElement(key);
        attrValues.addElement(value);
        attrTypes.addElement("CDATA");
        this.validator.attributeAdded(key, value, this.reader.getSystemID(), this.reader.getLineNr());
    }
}

