/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.api.server.DocumentAddressResolver;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.developer.SchemaValidationFeature;
import com.sun.xml.internal.ws.developer.ValidationErrorHandler;
import com.sun.xml.internal.ws.server.SDDocumentImpl;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.SDDocumentResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractSchemaValidationTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(AbstractSchemaValidationTube.class.getName());
    protected final WSBinding binding;
    protected final SchemaValidationFeature feature;
    protected final DocumentAddressResolver resolver = new ValidationDocumentAddressResolver();
    protected final SchemaFactory sf;

    public AbstractSchemaValidationTube(WSBinding wSBinding, Tube tube) {
        super(tube);
        this.binding = wSBinding;
        this.feature = wSBinding.getFeature(SchemaValidationFeature.class);
        this.sf = XmlUtil.allowExternalAccess(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema"), "file", false);
    }

    protected AbstractSchemaValidationTube(AbstractSchemaValidationTube abstractSchemaValidationTube, TubeCloner tubeCloner) {
        super(abstractSchemaValidationTube, tubeCloner);
        this.binding = abstractSchemaValidationTube.binding;
        this.feature = abstractSchemaValidationTube.feature;
        this.sf = abstractSchemaValidationTube.sf;
    }

    protected abstract Validator getValidator();

    protected abstract boolean isNoValidation();

    private Document createDOM(SDDocument sDDocument) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        try {
            sDDocument.writeTo(null, this.resolver, byteArrayBuffer);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        Transformer transformer = XmlUtil.newTransformer();
        StreamSource streamSource = new StreamSource(byteArrayBuffer.newInputStream(), null);
        DOMResult dOMResult = new DOMResult();
        try {
            transformer.transform(streamSource, dOMResult);
        }
        catch (TransformerException transformerException) {
            throw new WebServiceException(transformerException);
        }
        return (Document)dOMResult.getNode();
    }

    private void updateMultiSchemaForTns(String string, String string2, Map<String, List<String>> map) {
        List<String> list = map.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(string, list);
        }
        list.add(string2);
    }

    /*
     * WARNING - void declaration
     */
    protected Source[] getSchemaSources(Iterable<SDDocument> iterable, MetadataResolverImpl metadataResolverImpl) {
        Object object;
        Object object2;
        HashMap<String, DOMSource> hashMap = new HashMap<String, DOMSource>();
        HashMap<String, List<String>> hashMap2 = new HashMap<String, List<String>>();
        for (SDDocument object3 : iterable) {
            if (object3.isWSDL()) {
                object2 = this.createDOM(object3);
                this.addSchemaFragmentSource((Document)object2, object3.getURL().toExternalForm(), hashMap);
                continue;
            }
            if (!object3.isSchema()) continue;
            this.updateMultiSchemaForTns(((SDDocument.Schema)object3).getTargetNamespace(), object3.getURL().toExternalForm(), hashMap2);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "WSDL inlined schema fragment documents(these are used to create a pseudo schema) = {0}", hashMap.keySet());
        }
        for (DOMSource dOMSource : hashMap.values()) {
            object2 = this.getTargetNamespace(dOMSource);
            this.updateMultiSchemaForTns((String)object2, dOMSource.getSystemId(), hashMap2);
        }
        if (hashMap2.isEmpty()) {
            return new Source[0];
        }
        if (hashMap2.size() == 1 && ((List)hashMap2.values().iterator().next()).size() == 1) {
            object = (String)((List)hashMap2.values().iterator().next()).get(0);
            return new Source[]{(Source)hashMap.get(object)};
        }
        metadataResolverImpl.addSchemas(hashMap.values());
        object = new HashMap();
        boolean bl = false;
        for (Map.Entry entry : hashMap2.entrySet()) {
            String string;
            List list = (List)entry.getValue();
            if (list.size() > 1) {
                void var6_10;
                string = "file:x-jax-ws-include-" + (int)(++var6_10);
                Source source = this.createSameTnsPseudoSchema((String)entry.getKey(), list, string);
                metadataResolverImpl.addSchema(source);
            } else {
                string = (String)list.get(0);
            }
            object.put(entry.getKey(), string);
        }
        object2 = this.createMasterPseudoSchema((Map<String, String>)object);
        return new Source[]{object2};
    }

    @Nullable
    private void addSchemaFragmentSource(Document document, String string, Map<String, DOMSource> map) {
        Element element = document.getDocumentElement();
        assert (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/"));
        assert (element.getLocalName().equals("definitions"));
        NodeList nodeList = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "types");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2 = ((Element)nodeList.item(i)).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                NamespaceSupport namespaceSupport = new NamespaceSupport();
                this.buildNamespaceSupport(namespaceSupport, element2);
                this.patchDOMFragment(namespaceSupport, element2);
                String string2 = string + "#schema" + j;
                map.put(string2, new DOMSource(element2, string2));
            }
        }
    }

    private void buildNamespaceSupport(NamespaceSupport namespaceSupport, Node node) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        this.buildNamespaceSupport(namespaceSupport, node.getParentNode());
        namespaceSupport.pushContext();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if ("xmlns".equals(attr.getPrefix())) {
                namespaceSupport.declarePrefix(attr.getLocalName(), attr.getValue());
                continue;
            }
            if (!"xmlns".equals(attr.getName())) continue;
            namespaceSupport.declarePrefix("", attr.getValue());
        }
    }

    @Nullable
    private void patchDOMFragment(NamespaceSupport namespaceSupport, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Enumeration enumeration = namespaceSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if ("xmlns".equals(attr.getPrefix()) && attr.getLocalName().equals(string)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Patching with xmlns:{0}={1}", new Object[]{string, namespaceSupport.getURI(string)});
                }
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, namespaceSupport.getURI(string));
            }
        }
    }

    @Nullable
    private Source createSameTnsPseudoSchema(String string, Collection<String> collection, String string2) {
        assert (collection.size() > 1);
        final StringBuilder stringBuilder = new StringBuilder("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'");
        if (!string.equals("")) {
            stringBuilder.append(" targetNamespace='").append(string).append("'");
        }
        stringBuilder.append(">\n");
        for (String string3 : collection) {
            stringBuilder.append("<xsd:include schemaLocation='").append(string3).append("'/>\n");
        }
        stringBuilder.append("</xsd:schema>\n");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Pseudo Schema for the same tns={0}is {1}", new Object[]{string, stringBuilder});
        }
        return new StreamSource(string2){

            @Override
            public Reader getReader() {
                return new StringReader(stringBuilder.toString());
            }
        };
    }

    private Source createMasterPseudoSchema(Map<String, String> map) {
        final StringBuilder stringBuilder = new StringBuilder("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema' targetNamespace='urn:x-jax-ws-master'>\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getValue();
            String string2 = entry.getKey();
            stringBuilder.append("<xsd:import schemaLocation='").append(string).append("'");
            if (!string2.equals("")) {
                stringBuilder.append(" namespace='").append(string2).append("'");
            }
            stringBuilder.append("/>\n");
        }
        stringBuilder.append("</xsd:schema>");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Master Pseudo Schema = {0}", stringBuilder);
        }
        return new StreamSource("file:x-jax-ws-master-doc"){

            @Override
            public Reader getReader() {
                return new StringReader(stringBuilder.toString());
            }
        };
    }

    protected void doProcess(Packet packet) throws SAXException {
        ValidationErrorHandler validationErrorHandler;
        this.getValidator().reset();
        Class<? extends ValidationErrorHandler> clazz = this.feature.getErrorHandler();
        try {
            validationErrorHandler = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        validationErrorHandler.setPacket(packet);
        this.getValidator().setErrorHandler(validationErrorHandler);
        Message message = packet.getMessage().copy();
        Source source = message.readPayloadAsSource();
        try {
            this.getValidator().validate(source);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    private String getTargetNamespace(DOMSource dOMSource) {
        Element element = (Element)dOMSource.getNode();
        return element.getAttribute("targetNamespace");
    }

    protected class MetadataResolverImpl
    implements SDDocumentResolver,
    LSResourceResolver {
        final Map<String, SDDocument> docs = new HashMap<String, SDDocument>();
        final Map<String, SDDocument> nsMapping = new HashMap<String, SDDocument>();

        public MetadataResolverImpl() {
        }

        public MetadataResolverImpl(Iterable<SDDocument> iterable) {
            for (SDDocument sDDocument : iterable) {
                if (!sDDocument.isSchema()) continue;
                this.docs.put(sDDocument.getURL().toExternalForm(), sDDocument);
                this.nsMapping.put(((SDDocument.Schema)sDDocument).getTargetNamespace(), sDDocument);
            }
        }

        void addSchema(Source source) {
            assert (source.getSystemId() != null);
            String string = source.getSystemId();
            try {
                XMLStreamBufferResult xMLStreamBufferResult = XmlUtil.identityTransform(source, new XMLStreamBufferResult());
                SDDocumentSource sDDocumentSource = SDDocumentSource.create(new URL(string), xMLStreamBufferResult.getXMLStreamBuffer());
                SDDocumentImpl sDDocumentImpl = SDDocumentImpl.create(sDDocumentSource, new QName(""), new QName(""));
                this.docs.put(string, sDDocumentImpl);
                this.nsMapping.put(((SDDocument.Schema)((Object)sDDocumentImpl)).getTargetNamespace(), sDDocumentImpl);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception in adding schemas to resolver", exception);
            }
        }

        void addSchemas(Collection<? extends Source> collection) {
            for (Source source : collection) {
                this.addSchema(source);
            }
        }

        @Override
        public SDDocument resolve(String string) {
            SDDocument sDDocument = this.docs.get(string);
            if (sDDocument == null) {
                SDDocumentSource sDDocumentSource;
                try {
                    sDDocumentSource = SDDocumentSource.create(new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new WebServiceException(malformedURLException);
                }
                sDDocument = SDDocumentImpl.create(sDDocumentSource, new QName(""), new QName(""));
                this.docs.put(string, sDDocument);
            }
            return sDDocument;
        }

        @Override
        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "type={0} namespaceURI={1} publicId={2} systemId={3} baseURI={4}", new Object[]{string, string2, string3, string4, string5});
            }
            try {
                SDDocument sDDocument;
                if (string4 == null) {
                    sDDocument = this.nsMapping.get(string2);
                } else {
                    URI uRI = string5 != null ? new URI(string5).resolve(string4) : new URI(string4);
                    sDDocument = this.docs.get(uRI.toString());
                }
                if (sDDocument != null) {
                    return new LSInput(){

                        @Override
                        public Reader getCharacterStream() {
                            return null;
                        }

                        @Override
                        public void setCharacterStream(Reader reader) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public InputStream getByteStream() {
                            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                            try {
                                sDDocument.writeTo(null, AbstractSchemaValidationTube.this.resolver, byteArrayBuffer);
                            }
                            catch (IOException iOException) {
                                throw new WebServiceException(iOException);
                            }
                            return byteArrayBuffer.newInputStream();
                        }

                        @Override
                        public void setByteStream(InputStream inputStream) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getStringData() {
                            return null;
                        }

                        @Override
                        public void setStringData(String string) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getSystemId() {
                            return sDDocument.getURL().toExternalForm();
                        }

                        @Override
                        public void setSystemId(String string) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getPublicId() {
                            return null;
                        }

                        @Override
                        public void setPublicId(String string) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getBaseURI() {
                            return sDDocument.getURL().toExternalForm();
                        }

                        @Override
                        public void setBaseURI(String string) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getEncoding() {
                            return null;
                        }

                        @Override
                        public void setEncoding(String string) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean getCertifiedText() {
                            return false;
                        }

                        @Override
                        public void setCertifiedText(boolean bl) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception in LSResourceResolver impl", exception);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Don''t know about systemId={0} baseURI={1}", new Object[]{string4, string5});
            }
            return null;
        }
    }

    private static class ValidationDocumentAddressResolver
    implements DocumentAddressResolver {
        private ValidationDocumentAddressResolver() {
        }

        @Override
        @Nullable
        public String getRelativeAddressFor(@NotNull SDDocument sDDocument, @NotNull SDDocument sDDocument2) {
            LOGGER.log(Level.FINE, "Current = {0} resolved relative={1}", new Object[]{sDDocument.getURL(), sDDocument2.getURL()});
            return sDDocument2.getURL().toExternalForm();
        }
    }
}

