/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.jaxb;

import com.sun.istack.internal.FragmentContentHandler;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.StreamingSOAP;
import com.sun.xml.internal.ws.encoding.TagInfoset;
import com.sun.xml.internal.ws.message.AbstractMessageImpl;
import com.sun.xml.internal.ws.message.AttachmentSetImpl;
import com.sun.xml.internal.ws.message.RootElementSniffer;
import com.sun.xml.internal.ws.message.jaxb.AttachmentMarshallerImpl;
import com.sun.xml.internal.ws.message.jaxb.JAXBBridgeSource;
import com.sun.xml.internal.ws.message.stream.StreamMessage;
import com.sun.xml.internal.ws.spi.db.BindingContext;
import com.sun.xml.internal.ws.spi.db.BindingContextFactory;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import com.sun.xml.internal.ws.streaming.MtomStreamWriter;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterUtil;
import com.sun.xml.internal.ws.util.xml.XMLReaderComposite;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class JAXBMessage
extends AbstractMessageImpl
implements StreamingSOAP {
    private MessageHeaders headers;
    private final Object jaxbObject;
    private final XMLBridge bridge;
    private final JAXBContext rawContext;
    private String nsUri;
    private String localName;
    private XMLStreamBuffer infoset;

    public static Message create(BindingContext bindingContext, Object object, SOAPVersion sOAPVersion, MessageHeaders messageHeaders, AttachmentSet attachmentSet) {
        if (!bindingContext.hasSwaRef()) {
            return new JAXBMessage(bindingContext, object, sOAPVersion, messageHeaders, attachmentSet);
        }
        try {
            MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
            Marshaller marshaller = bindingContext.createMarshaller();
            AttachmentMarshallerImpl attachmentMarshallerImpl = new AttachmentMarshallerImpl(attachmentSet);
            marshaller.setAttachmentMarshaller(attachmentMarshallerImpl);
            attachmentMarshallerImpl.cleanup();
            marshaller.marshal(object, mutableXMLStreamBuffer.createFromXMLStreamWriter());
            return new StreamMessage(messageHeaders, attachmentSet, mutableXMLStreamBuffer.readAsXMLStreamReader(), sOAPVersion);
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    public static Message create(BindingContext bindingContext, Object object, SOAPVersion sOAPVersion) {
        return JAXBMessage.create(bindingContext, object, sOAPVersion, null, null);
    }

    public static Message create(JAXBContext jAXBContext, Object object, SOAPVersion sOAPVersion) {
        return JAXBMessage.create(BindingContextFactory.create(jAXBContext), object, sOAPVersion, null, null);
    }

    public static Message createRaw(JAXBContext jAXBContext, Object object, SOAPVersion sOAPVersion) {
        return new JAXBMessage(jAXBContext, object, sOAPVersion, null, null);
    }

    private JAXBMessage(BindingContext bindingContext, Object object, SOAPVersion sOAPVersion, MessageHeaders messageHeaders, AttachmentSet attachmentSet) {
        super(sOAPVersion);
        this.bridge = bindingContext.createFragmentBridge();
        this.rawContext = null;
        this.jaxbObject = object;
        this.headers = messageHeaders;
        this.attachmentSet = attachmentSet;
    }

    private JAXBMessage(JAXBContext jAXBContext, Object object, SOAPVersion sOAPVersion, MessageHeaders messageHeaders, AttachmentSet attachmentSet) {
        super(sOAPVersion);
        this.rawContext = jAXBContext;
        this.bridge = null;
        this.jaxbObject = object;
        this.headers = messageHeaders;
        this.attachmentSet = attachmentSet;
    }

    public static Message create(XMLBridge xMLBridge, Object object, SOAPVersion sOAPVersion) {
        if (!xMLBridge.context().hasSwaRef()) {
            return new JAXBMessage(xMLBridge, object, sOAPVersion);
        }
        try {
            MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
            AttachmentSetImpl attachmentSetImpl = new AttachmentSetImpl();
            AttachmentMarshallerImpl attachmentMarshallerImpl = new AttachmentMarshallerImpl(attachmentSetImpl);
            xMLBridge.marshal(object, mutableXMLStreamBuffer.createFromXMLStreamWriter(), (AttachmentMarshaller)attachmentMarshallerImpl);
            attachmentMarshallerImpl.cleanup();
            return new StreamMessage(null, attachmentSetImpl, mutableXMLStreamBuffer.readAsXMLStreamReader(), sOAPVersion);
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    private JAXBMessage(XMLBridge xMLBridge, Object object, SOAPVersion sOAPVersion) {
        super(sOAPVersion);
        this.bridge = xMLBridge;
        this.rawContext = null;
        this.jaxbObject = object;
        QName qName = xMLBridge.getTypeInfo().tagName;
        this.nsUri = qName.getNamespaceURI();
        this.localName = qName.getLocalPart();
        this.attachmentSet = new AttachmentSetImpl();
    }

    public JAXBMessage(JAXBMessage jAXBMessage) {
        super(jAXBMessage);
        this.headers = jAXBMessage.headers;
        if (this.headers != null) {
            this.headers = new HeaderList(this.headers);
        }
        this.attachmentSet = jAXBMessage.attachmentSet;
        this.jaxbObject = jAXBMessage.jaxbObject;
        this.bridge = jAXBMessage.bridge;
        this.rawContext = jAXBMessage.rawContext;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null && this.headers.hasHeaders();
    }

    @Override
    public MessageHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HeaderList(this.getSOAPVersion());
        }
        return this.headers;
    }

    @Override
    public String getPayloadLocalPart() {
        if (this.localName == null) {
            this.sniff();
        }
        return this.localName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        if (this.nsUri == null) {
            this.sniff();
        }
        return this.nsUri;
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    private void sniff() {
        RootElementSniffer rootElementSniffer = new RootElementSniffer(false);
        try {
            if (this.rawContext != null) {
                Marshaller marshaller = this.rawContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
                marshaller.marshal(this.jaxbObject, rootElementSniffer);
            } else {
                this.bridge.marshal(this.jaxbObject, rootElementSniffer, null);
            }
        }
        catch (JAXBException jAXBException) {
            this.nsUri = rootElementSniffer.getNsUri();
            this.localName = rootElementSniffer.getLocalName();
        }
    }

    @Override
    public Source readPayloadAsSource() {
        return new JAXBBridgeSource(this.bridge, this.jaxbObject);
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        JAXBResult jAXBResult = new JAXBResult(unmarshaller);
        try {
            jAXBResult.getHandler().startDocument();
            if (this.rawContext != null) {
                Marshaller marshaller = this.rawContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
                marshaller.marshal(this.jaxbObject, jAXBResult);
            } else {
                this.bridge.marshal(this.jaxbObject, jAXBResult);
            }
            jAXBResult.getHandler().endDocument();
        }
        catch (SAXException sAXException) {
            throw new JAXBException(sAXException);
        }
        return (T)jAXBResult.getResult();
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        try {
            Object object;
            if (this.infoset == null) {
                if (this.rawContext != null) {
                    object = new XMLStreamBufferResult();
                    Marshaller marshaller = this.rawContext.createMarshaller();
                    marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
                    marshaller.marshal(this.jaxbObject, (Result)object);
                    this.infoset = ((XMLStreamBufferResult)object).getXMLStreamBuffer();
                } else {
                    object = new MutableXMLStreamBuffer();
                    this.writePayloadTo(((MutableXMLStreamBuffer)object).createFromXMLStreamWriter());
                    this.infoset = object;
                }
            }
            if ((object = this.infoset.readAsXMLStreamReader()).getEventType() == 7) {
                XMLStreamReaderUtil.nextElementContent((XMLStreamReader)object);
            }
            return object;
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }

    @Override
    protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
        try {
            if (bl) {
                contentHandler = new FragmentContentHandler(contentHandler);
            }
            AttachmentMarshallerImpl attachmentMarshallerImpl = new AttachmentMarshallerImpl(this.attachmentSet);
            if (this.rawContext != null) {
                Marshaller marshaller = this.rawContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
                marshaller.setAttachmentMarshaller(attachmentMarshallerImpl);
                marshaller.marshal(this.jaxbObject, contentHandler);
            } else {
                this.bridge.marshal(this.jaxbObject, contentHandler, (AttachmentMarshaller)attachmentMarshallerImpl);
            }
            attachmentMarshallerImpl.cleanup();
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException.getMessage(), jAXBException);
        }
    }

    @Override
    public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        try {
            OutputStream outputStream;
            AttachmentMarshaller attachmentMarshaller = xMLStreamWriter instanceof MtomStreamWriter ? ((MtomStreamWriter)((Object)xMLStreamWriter)).getAttachmentMarshaller() : new AttachmentMarshallerImpl(this.attachmentSet);
            String string = XMLStreamWriterUtil.getEncoding(xMLStreamWriter);
            OutputStream outputStream2 = outputStream = this.bridge.supportOutputStream() ? XMLStreamWriterUtil.getOutputStream(xMLStreamWriter) : null;
            if (this.rawContext != null) {
                Marshaller marshaller = this.rawContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
                marshaller.setAttachmentMarshaller(attachmentMarshaller);
                if (outputStream != null) {
                    marshaller.marshal(this.jaxbObject, outputStream);
                } else {
                    marshaller.marshal(this.jaxbObject, xMLStreamWriter);
                }
            } else if (outputStream != null && string != null && string.equalsIgnoreCase("utf-8")) {
                this.bridge.marshal(this.jaxbObject, outputStream, xMLStreamWriter.getNamespaceContext(), attachmentMarshaller);
            } else {
                this.bridge.marshal(this.jaxbObject, xMLStreamWriter, attachmentMarshaller);
            }
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }

    @Override
    public Message copy() {
        return new JAXBMessage(this);
    }

    @Override
    public XMLStreamReader readEnvelope() {
        int n = this.soapVersion.ordinal() * 3;
        this.envelopeTag = (TagInfoset)DEFAULT_TAGS.get(n);
        this.bodyTag = (TagInfoset)DEFAULT_TAGS.get(n + 2);
        ArrayList<XMLStreamReader> arrayList = new ArrayList<XMLStreamReader>();
        XMLReaderComposite.ElemInfo elemInfo = new XMLReaderComposite.ElemInfo(this.envelopeTag, null);
        XMLReaderComposite.ElemInfo elemInfo2 = new XMLReaderComposite.ElemInfo(this.bodyTag, elemInfo);
        for (Header object2 : this.getHeaders().asList()) {
            try {
                arrayList.add(object2.readHeader());
            }
            catch (XMLStreamException xMLStreamException) {
                throw new RuntimeException(xMLStreamException);
            }
        }
        Object object3 = null;
        if (arrayList.size() > 0) {
            this.headerTag = (TagInfoset)DEFAULT_TAGS.get(n + 1);
            XMLReaderComposite.ElemInfo xMLStreamException = new XMLReaderComposite.ElemInfo(this.headerTag, elemInfo);
            object3 = new XMLReaderComposite(xMLStreamException, arrayList.toArray(new XMLStreamReader[arrayList.size()]));
        }
        try {
            XMLStreamReader[] xMLStreamReaderArray;
            XMLStreamReader xMLStreamReader = this.readPayload();
            XMLReaderComposite xMLReaderComposite = new XMLReaderComposite(elemInfo2, new XMLStreamReader[]{xMLStreamReader});
            if (object3 != null) {
                XMLStreamReader[] xMLStreamReaderArray2 = new XMLStreamReader[2];
                xMLStreamReaderArray2[0] = object3;
                xMLStreamReaderArray = xMLStreamReaderArray2;
                xMLStreamReaderArray2[1] = xMLReaderComposite;
            } else {
                XMLStreamReader[] xMLStreamReaderArray3 = new XMLStreamReader[1];
                xMLStreamReaderArray = xMLStreamReaderArray3;
                xMLStreamReaderArray3[0] = xMLReaderComposite;
            }
            XMLStreamReader[] xMLStreamReaderArray4 = xMLStreamReaderArray;
            return new XMLReaderComposite(elemInfo, xMLStreamReaderArray4);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException);
        }
    }
}

