/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.swing.text.Document;
import processing.app.Base;
import processing.app.I18n;
import processing.app.LastUndoableEditAwareUndoManager;

public class SketchCode {
    private String prettyName;
    private File file;
    private String extension;
    private String program;
    private Document document;
    private LastUndoableEditAwareUndoManager undo = new LastUndoableEditAwareUndoManager();
    private int selectionStart;
    private int selectionStop;
    private int scrollPosition;
    private boolean modified;
    private int preprocOffset;

    public SketchCode(File file, String extension) {
        this.file = file;
        this.extension = extension;
        this.makePrettyName();
        try {
            this.load();
        }
        catch (IOException e) {
            System.err.println(I18n.format(I18n._("Error while loading code {0}"), file.getName()));
        }
    }

    protected void makePrettyName() {
        this.prettyName = this.file.getName();
        int dot = this.prettyName.indexOf(46);
        this.prettyName = this.prettyName.substring(0, dot);
    }

    public File getFile() {
        return this.file;
    }

    protected boolean fileExists() {
        return this.file.exists();
    }

    protected boolean fileReadOnly() {
        return !this.file.canWrite();
    }

    protected boolean deleteFile(File tempBuildFolder) {
        File[] compiledFiles;
        if (!this.file.delete()) {
            return false;
        }
        for (File compiledFile : compiledFiles = tempBuildFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(SketchCode.this.getFileName());
            }
        })) {
            compiledFile.delete();
        }
        return true;
    }

    protected boolean renameTo(File what, String ext) {
        boolean success = this.file.renameTo(what);
        if (success) {
            this.file = what;
            this.extension = ext;
            this.makePrettyName();
        }
        return success;
    }

    protected void copyTo(File dest) throws IOException {
        Base.saveFile(this.program, dest);
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isExtension(String what) {
        return this.extension.equals(what);
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String replacement) {
        this.program = replacement;
    }

    public int getLineCount() {
        return Base.countLines(this.program);
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setPreprocOffset(int preprocOffset) {
        this.preprocOffset = preprocOffset;
    }

    public int getPreprocOffset() {
        return this.preprocOffset;
    }

    public void addPreprocOffset(int extra) {
        this.preprocOffset += extra;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document d) {
        this.document = d;
    }

    public LastUndoableEditAwareUndoManager getUndo() {
        return this.undo;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStop() {
        return this.selectionStop;
    }

    public int getScrollPosition() {
        return this.scrollPosition;
    }

    protected void setState(String p, int start, int stop, int pos) {
        this.program = p;
        this.selectionStart = start;
        this.selectionStop = stop;
        this.scrollPosition = pos;
    }

    public void load() throws IOException {
        this.program = Base.loadFile(this.file);
        if (this.program.indexOf(65533) != -1) {
            System.err.println(I18n.format(I18n._("\"{0}\" contains unrecognized characters.If this code was created with an older version of Processing,you may need to use Tools -> Fix Encoding & Reload to updatethe sketch to use UTF-8 encoding. If not, you may need todelete the bad characters to get rid of this warning."), this.file.getName()));
            System.err.println();
        }
        this.setModified(false);
    }

    public void save() throws IOException {
        Base.saveFile(this.program, this.file);
        this.setModified(false);
    }

    public void saveAs(File newFile) throws IOException {
        Base.saveFile(this.program, newFile);
    }
}

