/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.Encodings;

public final class EncodingInfo {
    final String name;
    final String javaName;
    private InEncoding m_encoding;

    public boolean isInEncoding(char c) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl();
        }
        return this.m_encoding.isInEncoding(c);
    }

    public boolean isInEncoding(char c, char c2) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl();
        }
        return this.m_encoding.isInEncoding(c, c2);
    }

    public EncodingInfo(String string, String string2) {
        this.name = string;
        this.javaName = string2;
    }

    private static boolean inEncoding(char c, String string) {
        boolean bl;
        block2: {
            try {
                char[] cArray = new char[]{c};
                String string2 = new String(cArray);
                byte[] byArray = string2.getBytes(string);
                bl = EncodingInfo.inEncoding(c, byArray);
            }
            catch (Exception exception) {
                bl = false;
                if (string != null) break block2;
                bl = true;
            }
        }
        return bl;
    }

    private static boolean inEncoding(char c, char c2, String string) {
        boolean bl;
        try {
            char[] cArray = new char[]{c, c2};
            String string2 = new String(cArray);
            byte[] byArray = string2.getBytes(string);
            bl = EncodingInfo.inEncoding(c, byArray);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private static boolean inEncoding(char c, byte[] byArray) {
        boolean bl = byArray == null || byArray.length == 0 ? false : (byArray[0] == 0 ? false : byArray[0] != 63 || c == '?');
        return bl;
    }

    private class EncodingImpl
    implements InEncoding {
        private final String m_encoding;
        private final int m_first;
        private final int m_explFirst;
        private final int m_explLast;
        private final int m_last;
        private InEncoding m_before;
        private InEncoding m_after;
        private static final int RANGE = 128;
        private final boolean[] m_alreadyKnown = new boolean[128];
        private final boolean[] m_isInEncoding = new boolean[128];

        @Override
        public boolean isInEncoding(char c) {
            boolean bl;
            int n = Encodings.toCodePoint(c);
            if (n < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, n);
                }
                bl = this.m_before.isInEncoding(c);
            } else if (this.m_explLast < n) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, n);
                }
                bl = this.m_after.isInEncoding(c);
            } else {
                int n2 = n - this.m_explFirst;
                if (this.m_alreadyKnown[n2]) {
                    bl = this.m_isInEncoding[n2];
                } else {
                    bl = EncodingInfo.inEncoding(c, this.m_encoding);
                    this.m_alreadyKnown[n2] = true;
                    this.m_isInEncoding[n2] = bl;
                }
            }
            return bl;
        }

        @Override
        public boolean isInEncoding(char c, char c2) {
            boolean bl;
            int n = Encodings.toCodePoint(c, c2);
            if (n < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, n);
                }
                bl = this.m_before.isInEncoding(c, c2);
            } else if (this.m_explLast < n) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, n);
                }
                bl = this.m_after.isInEncoding(c, c2);
            } else {
                int n2 = n - this.m_explFirst;
                if (this.m_alreadyKnown[n2]) {
                    bl = this.m_isInEncoding[n2];
                } else {
                    bl = EncodingInfo.inEncoding(c, c2, this.m_encoding);
                    this.m_alreadyKnown[n2] = true;
                    this.m_isInEncoding[n2] = bl;
                }
            }
            return bl;
        }

        private EncodingImpl() {
            this(encodingInfo.javaName, 0, Integer.MAX_VALUE, 0);
        }

        private EncodingImpl(String string, int n, int n2, int n3) {
            this.m_first = n;
            this.m_last = n2;
            this.m_explFirst = n3 / 128 * 128;
            this.m_explLast = this.m_explFirst + 127;
            this.m_encoding = string;
            if (EncodingInfo.this.javaName != null) {
                int n4;
                if (0 <= this.m_explFirst && this.m_explFirst <= 127 && ("UTF8".equals(EncodingInfo.this.javaName) || "UTF-16".equals(EncodingInfo.this.javaName) || "ASCII".equals(EncodingInfo.this.javaName) || "US-ASCII".equals(EncodingInfo.this.javaName) || "Unicode".equals(EncodingInfo.this.javaName) || "UNICODE".equals(EncodingInfo.this.javaName) || EncodingInfo.this.javaName.startsWith("ISO8859"))) {
                    for (n4 = 1; n4 < 127; ++n4) {
                        int n5 = n4 - this.m_explFirst;
                        if (0 > n5 || n5 >= 128) continue;
                        this.m_alreadyKnown[n5] = true;
                        this.m_isInEncoding[n5] = true;
                    }
                }
                if (EncodingInfo.this.javaName == null) {
                    for (n4 = 0; n4 < this.m_alreadyKnown.length; ++n4) {
                        this.m_alreadyKnown[n4] = true;
                        this.m_isInEncoding[n4] = true;
                    }
                }
            }
        }
    }

    private static interface InEncoding {
        public boolean isInEncoding(char var1);

        public boolean isInEncoding(char var1, char var2);
    }
}

