/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.webservices.internal.api.databinding;

import com.sun.xml.internal.ws.api.databinding.MetadataReader;
import com.sun.xml.internal.ws.model.ExternalMetadataReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.ws.WebServiceFeature;

public class ExternalMetadataFeature
extends WebServiceFeature {
    private static final String ID = "com.oracle.webservices.internal.api.databinding.ExternalMetadataFeature";
    private boolean enabled = true;
    private List<String> resourceNames;
    private List<File> files;
    private MetadataReader reader;

    private ExternalMetadataFeature() {
    }

    public void addResources(String ... stringArray) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        Collections.addAll(this.resourceNames, stringArray);
    }

    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public void addFiles(File ... fileArray) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        Collections.addAll(this.files, fileArray);
    }

    public List<File> getFiles() {
        return this.files;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public String getID() {
        return ID;
    }

    public MetadataReader getMetadataReader(ClassLoader classLoader, boolean bl) {
        if (this.reader != null && this.enabled) {
            return this.reader;
        }
        return this.enabled ? new ExternalMetadataReader(this.files, this.resourceNames, classLoader, true, bl) : null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExternalMetadataFeature externalMetadataFeature = (ExternalMetadataFeature)object;
        if (this.enabled != externalMetadataFeature.enabled) {
            return false;
        }
        if (this.files != null ? !this.files.equals(externalMetadataFeature.files) : externalMetadataFeature.files != null) {
            return false;
        }
        return !(this.resourceNames != null ? !this.resourceNames.equals(externalMetadataFeature.resourceNames) : externalMetadataFeature.resourceNames != null);
    }

    public int hashCode() {
        int n = this.enabled ? 1 : 0;
        n = 31 * n + (this.resourceNames != null ? this.resourceNames.hashCode() : 0);
        n = 31 * n + (this.files != null ? this.files.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "[" + this.getID() + ", enabled=" + this.enabled + ", resourceNames=" + this.resourceNames + ", files=" + this.files + ']';
    }

    public static Builder builder() {
        return new Builder(new ExternalMetadataFeature());
    }

    public static final class Builder {
        private final ExternalMetadataFeature o;

        Builder(ExternalMetadataFeature externalMetadataFeature) {
            this.o = externalMetadataFeature;
        }

        public ExternalMetadataFeature build() {
            return this.o;
        }

        public Builder addResources(String ... stringArray) {
            this.o.addResources(stringArray);
            return this;
        }

        public Builder addFiles(File ... fileArray) {
            this.o.addFiles(fileArray);
            return this;
        }

        public Builder setEnabled(boolean bl) {
            this.o.setEnabled(bl);
            return this;
        }

        public Builder setReader(MetadataReader metadataReader) {
            this.o.reader = metadataReader;
            return this;
        }
    }
}

