/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.CoreDOMImplementationImpl;
import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.NamedNodeMapImpl;
import com.sun.org.apache.xerces.internal.dom.NodeImpl;
import com.sun.org.apache.xerces.internal.dom.ParentNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public class DocumentTypeImpl
extends ParentNode
implements DocumentType {
    static final long serialVersionUID = 7751299192316526485L;
    protected String name;
    protected NamedNodeMapImpl entities;
    protected NamedNodeMapImpl notations;
    protected NamedNodeMapImpl elements;
    protected String publicID;
    protected String systemID;
    protected String internalSubset;
    private int doctypeNumber = 0;
    private Map<String, ParentNode.UserDataRecord> userData = null;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", String.class), new ObjectStreamField("entities", NamedNodeMapImpl.class), new ObjectStreamField("notations", NamedNodeMapImpl.class), new ObjectStreamField("elements", NamedNodeMapImpl.class), new ObjectStreamField("publicID", String.class), new ObjectStreamField("systemID", String.class), new ObjectStreamField("internalSubset", String.class), new ObjectStreamField("doctypeNumber", Integer.TYPE), new ObjectStreamField("userData", Hashtable.class)};

    public DocumentTypeImpl(CoreDocumentImpl coreDocumentImpl, String string) {
        super(coreDocumentImpl);
        this.name = string;
        this.entities = new NamedNodeMapImpl(this);
        this.notations = new NamedNodeMapImpl(this);
        this.elements = new NamedNodeMapImpl(this);
    }

    public DocumentTypeImpl(CoreDocumentImpl coreDocumentImpl, String string, String string2, String string3) {
        this(coreDocumentImpl, string);
        this.publicID = string2;
        this.systemID = string3;
    }

    @Override
    public String getPublicId() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.publicID;
    }

    @Override
    public String getSystemId() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.systemID;
    }

    public void setInternalSubset(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.internalSubset = string;
    }

    @Override
    public String getInternalSubset() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalSubset;
    }

    @Override
    public short getNodeType() {
        return 10;
    }

    @Override
    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public Node cloneNode(boolean bl) {
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)super.cloneNode(bl);
        documentTypeImpl.entities = this.entities.cloneMap(documentTypeImpl);
        documentTypeImpl.notations = this.notations.cloneMap(documentTypeImpl);
        documentTypeImpl.elements = this.elements.cloneMap(documentTypeImpl);
        return documentTypeImpl;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public void setTextContent(String string) throws DOMException {
    }

    @Override
    public boolean isEqualNode(Node node) {
        Node node2;
        if (!super.isEqualNode(node)) {
            return false;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)node;
        if (this.getPublicId() == null && documentTypeImpl.getPublicId() != null || this.getPublicId() != null && documentTypeImpl.getPublicId() == null || this.getSystemId() == null && documentTypeImpl.getSystemId() != null || this.getSystemId() != null && documentTypeImpl.getSystemId() == null || this.getInternalSubset() == null && documentTypeImpl.getInternalSubset() != null || this.getInternalSubset() != null && documentTypeImpl.getInternalSubset() == null) {
            return false;
        }
        if (this.getPublicId() != null && !this.getPublicId().equals(documentTypeImpl.getPublicId())) {
            return false;
        }
        if (this.getSystemId() != null && !this.getSystemId().equals(documentTypeImpl.getSystemId())) {
            return false;
        }
        if (this.getInternalSubset() != null && !this.getInternalSubset().equals(documentTypeImpl.getInternalSubset())) {
            return false;
        }
        NamedNodeMapImpl namedNodeMapImpl = documentTypeImpl.entities;
        if (this.entities == null && namedNodeMapImpl != null || this.entities != null && namedNodeMapImpl == null) {
            return false;
        }
        if (this.entities != null && namedNodeMapImpl != null) {
            if (this.entities.getLength() != namedNodeMapImpl.getLength()) {
                return false;
            }
            int n = 0;
            while (this.entities.item(n) != null) {
                Node node3 = this.entities.item(n);
                if (!((NodeImpl)node3).isEqualNode((NodeImpl)(node2 = namedNodeMapImpl.getNamedItem(node3.getNodeName())))) {
                    return false;
                }
                ++n;
            }
        }
        NamedNodeMapImpl namedNodeMapImpl2 = documentTypeImpl.notations;
        if (this.notations == null && namedNodeMapImpl2 != null || this.notations != null && namedNodeMapImpl2 == null) {
            return false;
        }
        if (this.notations != null && namedNodeMapImpl2 != null) {
            if (this.notations.getLength() != namedNodeMapImpl2.getLength()) {
                return false;
            }
            int n = 0;
            while (this.notations.item(n) != null) {
                Node node4;
                node2 = this.notations.item(n);
                if (!((NodeImpl)node2).isEqualNode((NodeImpl)(node4 = namedNodeMapImpl2.getNamedItem(node2.getNodeName())))) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    @Override
    void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        super.setOwnerDocument(coreDocumentImpl);
        this.entities.setOwnerDocument(coreDocumentImpl);
        this.notations.setOwnerDocument(coreDocumentImpl);
        this.elements.setOwnerDocument(coreDocumentImpl);
    }

    @Override
    protected int getNodeNumber() {
        if (this.getOwnerDocument() != null) {
            return super.getNodeNumber();
        }
        if (this.doctypeNumber == 0) {
            CoreDOMImplementationImpl coreDOMImplementationImpl = (CoreDOMImplementationImpl)CoreDOMImplementationImpl.getDOMImplementation();
            this.doctypeNumber = coreDOMImplementationImpl.assignDocTypeNumber();
        }
        return this.doctypeNumber;
    }

    @Override
    public String getName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public NamedNodeMap getEntities() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.entities;
    }

    @Override
    public NamedNodeMap getNotations() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.notations;
    }

    @Override
    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        super.setReadOnly(bl, bl2);
        this.elements.setReadOnly(bl, true);
        this.entities.setReadOnly(bl, true);
        this.notations.setReadOnly(bl, true);
    }

    public NamedNodeMap getElements() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.elements;
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new HashMap<String, ParentNode.UserDataRecord>();
        }
        if (object == null) {
            ParentNode.UserDataRecord userDataRecord;
            if (this.userData != null && (userDataRecord = this.userData.remove(string)) != null) {
                return userDataRecord.fData;
            }
            return null;
        }
        ParentNode.UserDataRecord userDataRecord = this.userData.put(string, new ParentNode.UserDataRecord(this, object, userDataHandler));
        if (userDataRecord != null) {
            return userDataRecord.fData;
        }
        return null;
    }

    @Override
    public Object getUserData(String string) {
        if (this.userData == null) {
            return null;
        }
        ParentNode.UserDataRecord userDataRecord = this.userData.get(string);
        if (userDataRecord != null) {
            return userDataRecord.fData;
        }
        return null;
    }

    @Override
    protected Map<String, ParentNode.UserDataRecord> getUserDataRecord() {
        return this.userData;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, ParentNode.UserDataRecord> hashtable = this.userData == null ? null : new Hashtable<String, ParentNode.UserDataRecord>(this.userData);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("name", this.name);
        putField.put("entities", this.entities);
        putField.put("notations", this.notations);
        putField.put("elements", this.elements);
        putField.put("publicID", this.publicID);
        putField.put("systemID", this.systemID);
        putField.put("internalSubset", this.internalSubset);
        putField.put("doctypeNumber", this.doctypeNumber);
        putField.put("userData", hashtable);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.name = (String)getField.get("name", null);
        this.entities = (NamedNodeMapImpl)getField.get("entities", null);
        this.notations = (NamedNodeMapImpl)getField.get("notations", null);
        this.elements = (NamedNodeMapImpl)getField.get("elements", null);
        this.publicID = (String)getField.get("publicID", null);
        this.systemID = (String)getField.get("systemID", null);
        this.internalSubset = (String)getField.get("internalSubset", null);
        this.doctypeNumber = getField.get("doctypeNumber", 0);
        Hashtable hashtable = (Hashtable)getField.get("userData", null);
        if (hashtable != null) {
            this.userData = new HashMap<String, ParentNode.UserDataRecord>(hashtable);
        }
    }
}

