;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text

; DE - input:  address of the 1st source string
; HL - input:  address of the 2nd source string
; AX - output: result of comparison

; [de] = 0, [hl] > 0               => res < 0 STOP  *
; [de] = 0, [hl] = 0               => res = 0 STOP
; [de] > 0, [hl] = 0               => res > 0 STOP  *
; [de] > 0, [hl] > 0, [de] == [hl] => CONT
; [de] > 0, [hl] > 0, [de] != [hl] => res != 0 STOP *


START_FUNC ___cmpstrhi

    push  de
    push  hl

    decw  de
    decw  hl

0:  incw  de
    incw  hl

    mov   a, [de]
    sub   a, [hl]
    bnz   $1f    ; different characters

    cmp   a, [hl]
    bnz   $0b    ; not end-of-strings => continue

1:  sarw  ax, 8  ; sign-extend to 16 bits

    pop   hl
    pop   de

    ret

END_FUNC ___cmpstrhi
