#include <Arduino.h>
#include "SD.h"
#include "HTTPServer.h"
#include "mbed_rpc.h"
#include "Camera.h"
#include "SdUsbConnect.h"

#define USE_WIFI

#ifdef USE_WIFI
#include "ESP32Interface.h"
ESP32Interface network;
#define WLAN_SSID            ("xxxxxxxx")
#define WLAN_PSK             ("xxxxxxxx")
#define WLAN_SECURITY        NSAPI_SECURITY_WPA_WPA2
#else
#include "EthernetInterface.h"
EthernetInterface network;
#endif

/** Network setting **/
#define USE_DHCP               (1)
#if (USE_DHCP == 0)
#define IP_ADDRESS           ("192.168.11.2")     /* IP address      */
#define SUBNET_MASK          ("255.255.255.0")    /* Subnet mask     */
#define DEFAULT_GATEWAY      ("192.168.11.3")     /* Default gateway */
#endif

Camera camera(320, 240); // default CMOS CAMERA. In case of NTSC, create camera(0).
SdUsbConnect storage("storage");

static int snapshot_req(const char ** pp_data) {
  size_t size = camera.createJpeg();
  *pp_data = (const char*)camera.getJpegAdr();
  return size;
}

void setup(void) {

  Serial.begin(9600);
  Serial.println("********* PROGRAM START ***********");

  // SD & USB
  Serial.print("Finding strage..");
  storage.wait_connect();
  Serial.println("done");

  camera.begin();

  Serial.print("Network Setting up...\r\n");
#if (USE_DHCP == 0)
  network.set_dhcp(false);
  if (network.set_network(IP_ADDRESS, SUBNET_MASK, DEFAULT_GATEWAY) != 0) { //for Static IP Address (IPAddress, NetMasks, Gateway)
    Serial.println("Error");
  }
#endif
#ifdef USE_WIFI
  network.set_credentials(WLAN_SSID, WLAN_PSK, WLAN_SECURITY);
#endif
  if (network.connect() != 0) {
    return;
  }

  Serial.print("MAC Address is ");
  Serial.println(network.get_mac_address());
  Serial.print("IP Address is ");
  Serial.println(network.get_ip_address());
  Serial.print("NetMask is ");
  Serial.println(network.get_netmask());
  Serial.print("Gateway Address is ");
  Serial.println(network.get_gateway());
  Serial.println("Network Setup OK\r\n");

  SnapshotHandler::attach_req(&snapshot_req);
  HTTPServerAddHandler<SnapshotHandler>("/camera"); //Camera
  FSHandler::mount("/storage", "/");
  HTTPServerAddHandler<FSHandler>("/");
  HTTPServerAddHandler<RPCHandler>("/rpc");
  HTTPServerStart(&network, 80);

}

void loop() {
}

