TARGET = rx
TYPE = elf
AR := $(TARGET)-$(TYPE)-ar
CC := $(TARGET)-$(TYPE)-gcc
CCOPTS = -fno-builtin -DSMALL_MEMORY -DINTERNAL_NEWLIB -DDEFINE_MALLOC -DDEFINE_FREE -DDEFINE_REALLOC -DDEFINE_CALLOC -DMISSING_SYSCALL_NAMES
#and this too "-D_LDBL_EQ_DBL", when "-m64bit-doubles"
SINC := -isystem "$(SRCDIR)/include"
MATHINC := "$(SRCDIR)/libm/common"
AR_SW = -rcus
STDLIBOPTS = -DDEFINE_MALLOC_STATS -DDEFINE_MALLOPT -DDEFINE_REALLOC -DDEFINE_MALLOC_USABLE_SIZE
LIBPATH = ./newlib.a
CCUOPTS = 
ASUOPTS = 

ifeq ($(findstring -m64bit-doubles,$(CCUOPTS)),)
CCOPTS += -D_LDBL_EQ_DBL
endif

MKFILE_PATH := $(realpath $(MAKEFILE_LIST))
MKFILE_DIR := $(dir $(MKFILE_PATH))

#clean
clean:
	@echo Cleaning...
	-@$(RM) *.o

#all
all_announce:
	@echo Starting build for '$(@:_announce=)'...

libm_common:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libm/common/*.c" $(CCUOPTS) $(SINC) -I $(MATHINC)

libm_math:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libm/math/*.c" $(CCUOPTS) $(SINC) -I $(MATHINC)

libm_mathfp:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libm/mathfp/*.c" $(CCUOPTS) $(SINC) -I $(MATHINC) -I "$(SRCDIR)/libm/mathfp"

libm: libm_common libm_math libm_mathfp

#only on 's' and 'v' targets
mathfp: libm_common libm_mathfp

libc_common:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libc/common/*.c" $(CCUOPTS) $(SINC)

libc_ctype:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libc/ctype/*.c" $(CCUOPTS) $(SINC)

libc_stdio:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libc/stdio/*.c" $(CCUOPTS) $(SINC)
#	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DINTEGER_ONLY -c $(SRCDIR)/libc/stdlib/mallocr.c $(SINC) -I $(MATHINC) $(CCUOPTS) -o mallocr.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DINTEGER_ONLY -c "$(SRCDIR)/libc/stdio/vfprintf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o vfiprintf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DINTEGER_ONLY -c "$(SRCDIR)/libc/stdio/vfscanf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o vfiscanf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DSTRING_ONLY -c "$(SRCDIR)/libc/stdio/vfprintf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o svfprintf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DSTRING_ONLY -c "$(SRCDIR)/libc/stdio/vfscanf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o svfscanf.o 
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DINTEGER_ONLY -DSTRING_ONLY -c "$(SRCDIR)/libc/stdio/vfprintf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o svfiprintf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DINTEGER_ONLY -DSTRING_ONLY -c "$(SRCDIR)/libc/stdio/vfscanf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o svfiscanf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DINTEGER_ONLY -c "$(SRCDIR)/libc/stdio/sprintf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o siprintf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DSTRING_ONLY -c "$(SRCDIR)/libc/stdio/sprintf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o ssprintf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DINTEGER_ONLY -DSTRING_ONLY -c "$(SRCDIR)/libc/stdio/sprintf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o ssiprintf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DINTEGER_ONLY -c "$(SRCDIR)/libc/stdio/sscanf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o siscanf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DSTRING_ONLY -c "$(SRCDIR)/libc/stdio/sscanf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o ssscanf.o
	@$(CC) $(CCOPTS) $(STDLIBOPTS) -DINTEGER_ONLY -DSTRING_ONLY -c "$(SRCDIR)/libc/stdio/sscanf.c" $(SINC) -I $(MATHINC) $(CCUOPTS) -o ssiscanf.o

libc_stdlib:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libc/stdlib/*.c" $(SINC) $(CCUOPTS)

libc_string:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libc/string/*.c" $(SINC) $(CCUOPTS)

libc_sys:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libc/sys/$(TARGET)/*.c" $(SINC) $(CCUOPTS)

libc_syscalls:
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libc/syscalls/*.c" $(SINC) $(CCUOPTS)

libgloss:
	@$(CC) $(CCOPTS) -c -xassembler-with-cpp "$(SRCDIR)/libgloss/$(TARGET)/*.S" $(SINC) -I "$(SRCDIR)/libgloss" -I "$(SRCDIR)/libgloss/$(TARGET)" $(ASUOPTS)
	@$(CC) $(CCOPTS) -c "$(SRCDIR)/libgloss/$(TARGET)/*.c" $(SINC) -I "$(SRCDIR)/libgloss" -I "$(SRCDIR)/libgloss/$(TARGET)" $(CCUOPTS)

libc: libc_common libc_ctype libc_stdio libc_stdlib libc_string libc_sys libc_syscalls libgloss

math: libm_common libm_math

common: libc_common libgloss

stdio: libc_stdio

stdlib: libc_stdlib

string: libc_string

ctype: libc_ctype

all: common math stdio stdlib string ctype

lib: common $(patsubst lib,,$(MAKECMDGOALS))
	@echo Creating library $(LIBPATH)
	@$(AR) $(AR_SW) "$(LIBPATH)" *.o
