;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by Alex Panek.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text

; HL - address of the destination buffer
; DE - address of the source buffer
; C  - count (may be zero)

START_FUNC ___movmemqi

#if 1 /* optimized for size only */

    cmp0  c
    bz    $1f

    push  de
    push  hl

0:  mov   a, [de]
    incw  de
    mov   [hl], a
    incw  hl
    dec   c
    bnz   $0b

    pop   hl
    pop   de

1:  ret

#else /* +4 code bytes for -2 clocks per copied byte */

    cmp0  c
    bz    $1f

    push  de

    mov   a, c
    add   e, a
    clrb  a
    addc  d, a

0:  decw  de
    dec   c
    mov   a, [de]
    mov   [hl+c], a
    bnz   $0b

    pop   de

1:  ret

#endif

END_FUNC ___movmemqi
