// Sample for GR-PEACH
//
// Required hardware: Ethernet, following files stored in SD
//  index.htm : http://gadget.renesas.com/software/peach3/index.htm
//
// Public Domain

#include <Arduino.h>
#include "SPI.h"
#include "SD.h"
#include "HTTPServer.h"
#include "EthernetInterface.h"
#include "FATFileSystem.h"
#include "RomRamBlockDevice.h"
#include "Camera.h"

FATFileSystem fs("storage");
RomRamBlockDevice romram_bd(512000, 512);
#define NUM_WEBFILES 1
const char mount_files[NUM_WEBFILES][13] = { //name should be 8.3 format
  "index.htm"};

/** Network setting **/
// #define IP_ADDRESS           ("192.168.11.2")     /* IP address      */
// #define SUBNET_MASK          ("255.255.255.0")   /* Subnet mask     */
// #define DEFAULT_GATEWAY      ("192.168.11.3")     /* Default gateway */

Camera camera(640, 480);
EthernetInterface network;
File myFile;

static int snapshot_req(const char ** pp_data) {

  int encode_size = camera.createJpeg();
  *pp_data = (const char *) camera.getJpegAdr();
  ;
  return encode_size;
}

static void mount_romramfs(void) {
  FILE * fp;

  romram_bd.SetRomAddr(0x18000000, 0x1FFFFFFF);
  fs.format(&romram_bd, 512);
  fs.mount(&romram_bd);

  char write_path[20];

  for (int i = 0; i < NUM_WEBFILES; i++) {
    myFile = SD.open(mount_files[i], FILE_READ);
    if (myFile) {
      sprintf(write_path, "/storage/%s", mount_files[i]);
      fp = fopen(write_path, "w");
      // read from the file until there's nothing else in it:
      while (myFile.available()) {
        putc(myFile.read(), fp);
      }
      // close the file:
      myFile.close();
      fclose(fp);
    }
  }
}

void setup(void) {

  Serial.begin(9600);
  Serial.print("********* PROGRAM START ***********\r\n");

  if (!SD.begin()) {
    return;
  }

  mount_romramfs();   //RomRamFileSystem Mount
  camera.begin();

  if (network.connect() != 0) {
    return;
  }

  Serial.print("MAC Address is ");
  Serial.println(network.get_mac_address());
  Serial.print("IP Address is ");
  Serial.println(network.get_ip_address());
  Serial.print("NetMask is ");
  Serial.println(network.get_netmask());
  Serial.print("Gateway Address is ");
  Serial.println(network.get_gateway());
  Serial.println("Network Setup OK\r\n");

  SnapshotHandler::attach_req(&snapshot_req);
  FSHandler::mount("/storage", "/");
  HTTPServerAddHandler<SnapshotHandler>("/camera"); //Camera
  HTTPServerAddHandler<FSHandler>("/");
  HTTPServerStart(&network, 80);

}

void loop() {
}
