/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.api;

import com.sun.xml.internal.bind.api.Messages;
import com.sun.xml.internal.bind.api.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;

public final class TypeReference {
    public final QName tagName;
    public final Type type;
    public final Annotation[] annotations;

    public TypeReference(QName qName, Type type, Annotation ... annotationArray) {
        if (qName == null || type == null || annotationArray == null) {
            String string = "";
            if (qName == null) {
                string = "tagName";
            }
            if (type == null) {
                string = string + (string.length() > 0 ? ", type" : "type");
            }
            if (annotationArray == null) {
                string = string + (string.length() > 0 ? ", annotations" : "annotations");
            }
            Messages.ARGUMENT_CANT_BE_NULL.format(string);
            throw new IllegalArgumentException(Messages.ARGUMENT_CANT_BE_NULL.format(string));
        }
        this.tagName = new QName(qName.getNamespaceURI().intern(), qName.getLocalPart().intern(), qName.getPrefix());
        this.type = type;
        this.annotations = annotationArray;
    }

    public <A extends Annotation> A get(Class<A> clazz) {
        for (Annotation annotation : this.annotations) {
            if (annotation.annotationType() != clazz) continue;
            return (A)((Annotation)clazz.cast(annotation));
        }
        return null;
    }

    public TypeReference toItemType() {
        Type type = Utils.REFLECTION_NAVIGATOR.getBaseClass(this.type, Collection.class);
        if (type == null) {
            return this;
        }
        return new TypeReference(this.tagName, Utils.REFLECTION_NAVIGATOR.getTypeArgument(type, 0), new Annotation[0]);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TypeReference typeReference = (TypeReference)object;
        if (!Arrays.equals(this.annotations, typeReference.annotations)) {
            return false;
        }
        if (!this.tagName.equals(typeReference.tagName)) {
            return false;
        }
        return this.type.equals(typeReference.type);
    }

    public int hashCode() {
        int n = this.tagName.hashCode();
        n = 31 * n + this.type.hashCode();
        n = 31 * n + Arrays.hashCode(this.annotations);
        return n;
    }
}

