/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;

public class FindReplace
extends JFrame
implements ActionListener {
    static final int EDGE = Base.isMacOS() ? 20 : 13;
    static final int SMALL = 6;
    static final int BUTTONGAP = 12;
    Editor editor;
    JTextField findField;
    JTextField replaceField;
    static String findString;
    static String replaceString;
    JButton replaceButton;
    JButton replaceAllButton;
    JButton replaceFindButton;
    JButton previousButton;
    JButton findButton;
    JCheckBox ignoreCaseBox;
    static boolean ignoreCase;
    JCheckBox wrapAroundBox;
    static boolean wrapAround;

    public FindReplace(Editor editor) {
        super("Find");
        this.setResizable(false);
        this.editor = editor;
        Container pain = this.getContentPane();
        pain.setLayout(null);
        JLabel findLabel = new JLabel(I18n._("Find:"));
        JLabel replaceLabel = new JLabel(I18n._("Replace with:"));
        Dimension labelDimension = replaceLabel.getPreferredSize();
        pain.add(findLabel);
        pain.add(replaceLabel);
        this.findField = new JTextField(20);
        pain.add(this.findField);
        this.replaceField = new JTextField(20);
        pain.add(this.replaceField);
        int fieldHeight = this.findField.getPreferredSize().height;
        if (findString != null) {
            this.findField.setText(findString);
        }
        if (replaceString != null) {
            this.replaceField.setText(replaceString);
        }
        this.ignoreCaseBox = new JCheckBox(I18n._("Ignore Case"));
        this.ignoreCaseBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ignoreCase = FindReplace.this.ignoreCaseBox.isSelected();
            }
        });
        this.ignoreCaseBox.setSelected(ignoreCase);
        pain.add(this.ignoreCaseBox);
        this.wrapAroundBox = new JCheckBox(I18n._("Wrap Around"));
        this.wrapAroundBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                wrapAround = FindReplace.this.wrapAroundBox.isSelected();
            }
        });
        this.wrapAroundBox.setSelected(wrapAround);
        pain.add(this.wrapAroundBox);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1, 12, 0));
        if (Base.isMacOS()) {
            this.replaceAllButton = new JButton(I18n._("Replace All"));
            buttons.add(this.replaceAllButton);
            this.replaceButton = new JButton(I18n._("Replace"));
            buttons.add(this.replaceButton);
            this.replaceFindButton = new JButton(I18n._("Replace & Find"));
            buttons.add(this.replaceFindButton);
            this.previousButton = new JButton(I18n._("Previous"));
            buttons.add(this.previousButton);
            this.findButton = new JButton(I18n._("Find"));
            buttons.add(this.findButton);
        } else {
            this.findButton = new JButton(I18n._("Find"));
            buttons.add(this.findButton);
            this.previousButton = new JButton(I18n._("Previous"));
            buttons.add(this.previousButton);
            this.replaceFindButton = new JButton(I18n._("Replace & Find"));
            buttons.add(this.replaceFindButton);
            this.replaceButton = new JButton(I18n._("Replace"));
            buttons.add(this.replaceButton);
            this.replaceAllButton = new JButton(I18n._("Replace All"));
            buttons.add(this.replaceAllButton);
        }
        pain.add(buttons);
        if (Base.isMacOS()) {
            buttons.setBorder(null);
        }
        Dimension buttonsDimension = buttons.getPreferredSize();
        int visibleButtonWidth = buttonsDimension.width - 24;
        int fieldWidth = visibleButtonWidth - (labelDimension.width + 6);
        int yoff = (1 + fieldHeight - labelDimension.height) / 2;
        int ypos = EDGE;
        int labelWidth = findLabel.getPreferredSize().width;
        findLabel.setBounds(EDGE + (labelDimension.width - labelWidth), ypos + yoff, labelWidth, labelDimension.height);
        this.findField.setBounds(EDGE + labelDimension.width + 6, ypos, fieldWidth, fieldHeight);
        labelWidth = replaceLabel.getPreferredSize().width;
        replaceLabel.setBounds(EDGE + (labelDimension.width - labelWidth), (ypos += fieldHeight + 6) + yoff, labelWidth, labelDimension.height);
        this.replaceField.setBounds(EDGE + labelDimension.width + 6, ypos, fieldWidth, fieldHeight);
        this.ignoreCaseBox.setBounds(EDGE + labelDimension.width + 6, ypos += fieldHeight + 6, (fieldWidth - 6) / 2, fieldHeight);
        this.wrapAroundBox.setBounds(EDGE + labelDimension.width + 6 + (fieldWidth - 6) / 2 + 6, ypos, (fieldWidth - 6) / 2, fieldHeight);
        buttons.setBounds(EDGE - 12, ypos += fieldHeight + 6, buttonsDimension.width, buttonsDimension.height);
        int wide = visibleButtonWidth + EDGE * 2;
        int high = ypos += buttonsDimension.height + EDGE;
        this.pack();
        Insets insets = this.getInsets();
        this.setSize(wide + insets.left + insets.right, high + insets.top + insets.bottom);
        this.setLocationRelativeTo(null);
        this.replaceButton.addActionListener(this);
        this.replaceAllButton.addActionListener(this);
        this.replaceFindButton.addActionListener(this);
        this.findButton.addActionListener(this);
        this.previousButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.findButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindReplace.this.handleClose();
            }
        });
        Base.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplace.this.handleClose();
            }
        });
        Base.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FindReplace.this.findField.requestFocusInWindow();
                FindReplace.this.findField.selectAll();
            }
        });
    }

    public void handleClose() {
        findString = this.findField.getText();
        replaceString = this.replaceField.getText();
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.findButton) {
            this.findNext();
        } else if (source == this.previousButton) {
            this.findPrevious();
        } else if (source == this.replaceFindButton) {
            this.replaceAndFindNext();
        } else if (source == this.replaceButton) {
            this.replace();
        } else if (source == this.replaceAllButton) {
            this.replaceAll();
        }
    }

    private boolean find(boolean wrap, boolean backwards) {
        int nextIndex;
        String search = this.findField.getText();
        if (search.length() == 0) {
            return false;
        }
        String text = this.editor.getText();
        if (ignoreCase) {
            search = search.toLowerCase();
            text = text.toLowerCase();
        }
        if (!backwards) {
            int selectionEnd = this.editor.getSelectionStop();
            nextIndex = text.indexOf(search, selectionEnd);
            if (wrap && nextIndex == -1) {
                nextIndex = text.indexOf(search, 0);
            }
        } else {
            int selectionStart = this.editor.getSelectionStart() - 1;
            nextIndex = selectionStart >= 0 ? text.lastIndexOf(search, selectionStart) : -1;
            if (wrap && nextIndex == -1) {
                nextIndex = text.lastIndexOf(search);
            }
        }
        if (nextIndex != -1) {
            this.editor.setSelection(nextIndex, nextIndex + search.length());
        }
        return nextIndex != -1;
    }

    public void replace() {
        this.editor.setSelectedText(this.replaceField.getText());
        this.editor.getSketch().setModified(true);
    }

    public void replaceAndFindNext() {
        this.replace();
        this.findNext();
    }

    public void replaceAll() {
        this.editor.setSelection(0, 0);
        boolean foundAtLeastOne = false;
        while (this.find(false, false)) {
            foundAtLeastOne = true;
            this.replace();
        }
        if (!foundAtLeastOne) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setFindText(String t) {
        this.findField.setText(t);
        findString = t;
    }

    public void findNext() {
        if (!this.find(wrapAround, false)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void findPrevious() {
        if (!this.find(wrapAround, true)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static {
        ignoreCase = true;
        wrapAround = true;
    }
}

