/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import processing.app.SketchImportDialog;
import processing.app.SketchImportUtility;

public class SketchImportThread
extends Thread {
    private int code;
    private SketchImportDialog dialog;
    private String apiKey;
    private String target;
    private String fileName;
    private String[] displayItems;
    private String file;
    private Boolean isSuccess;
    private Exception exception;

    protected int getCode() {
        return this.code;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getFile() {
        return this.file;
    }

    protected String[] getDisplayItems() {
        return this.displayItems;
    }

    protected Boolean getSuccess() {
        return this.isSuccess;
    }

    protected Exception getException() {
        return this.exception;
    }

    public SketchImportThread(int code, SketchImportDialog dialog, String apiKey, String target) {
        this.code = code;
        this.dialog = dialog;
        this.apiKey = apiKey;
        this.target = target;
    }

    @Override
    public void run() {
        try {
            this.isSuccess = false;
            if (this.code == 0) {
                this.displayItems = null;
                String projectInfo = SketchImportUtility.getProjcetInfo(this.apiKey);
                if (projectInfo != null && 0 < projectInfo.length()) {
                    JSONObject json = JSONObject.fromObject((Object)projectInfo);
                    this.displayItems = this.getDisplayItems(this.apiKey, json);
                }
                this.isSuccess = true;
            } else if (this.code == 1) {
                String projectName = this.getProjectName(this.target);
                this.fileName = this.getFileName(this.target);
                this.file = SketchImportUtility.getFile(this.apiKey, projectName, "/", this.fileName);
                this.isSuccess = true;
            }
        }
        catch (Exception ex) {
            this.exception = ex;
        }
        finally {
            this.dialog.importCallback(this);
        }
    }

    private String[] getDisplayItems(String apiKey, JSONObject object) throws IOException {
        ArrayList<String> itemList = new ArrayList<String>();
        Iterator iterator = object.keys();
        while (iterator.hasNext()) {
            JSONArray array = object.getJSONArray((String)iterator.next());
            for (int count = 0; count < array.size(); ++count) {
                JSONObject jsonObject = array.getJSONObject(count);
                if (!jsonObject.containsKey((Object)"name")) continue;
                String project = jsonObject.getString("name");
                for (String name : SketchImportUtility.getProjectFiles(apiKey, project, "/")) {
                    itemList.add("/" + project + "/" + name);
                }
            }
        }
        return itemList.toArray(new String[itemList.size()]);
    }

    private String getProjectName(String target) {
        int index = target.indexOf("/", 1);
        return target.substring(1, index);
    }

    private String getFileName(String target) {
        int index = target.lastIndexOf("/");
        return target.substring(index + 1, target.length());
    }
}

