/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import processing.core.PApplet;
import processing.xml.StdXMLBuilder;
import processing.xml.StdXMLParser;
import processing.xml.StdXMLReader;
import processing.xml.XMLAttribute;
import processing.xml.XMLException;
import processing.xml.XMLValidator;
import processing.xml.XMLWriter;

public class XMLElement
implements Serializable {
    public static final int NO_LINE = -1;
    private XMLElement parent;
    private Vector<XMLAttribute> attributes = new Vector();
    private Vector<XMLElement> children = new Vector(8);
    private String name;
    private String fullName;
    private String namespace;
    private String content;
    private String systemID;
    private int lineNr;

    public XMLElement() {
        this(null, null, null, -1);
    }

    protected void set(String fullName, String namespace, String systemID, int lineNr) {
        int index;
        this.fullName = fullName;
        this.name = namespace == null ? fullName : ((index = fullName.indexOf(58)) >= 0 ? fullName.substring(index + 1) : fullName);
        this.namespace = namespace;
        this.lineNr = lineNr;
        this.systemID = systemID;
    }

    public XMLElement(String fullName, String namespace, String systemID, int lineNr) {
        int index;
        this.fullName = fullName;
        this.name = namespace == null ? fullName : ((index = fullName.indexOf(58)) >= 0 ? fullName.substring(index + 1) : fullName);
        this.namespace = namespace;
        this.content = null;
        this.lineNr = lineNr;
        this.systemID = systemID;
        this.parent = null;
    }

    public XMLElement(PApplet parent, String filename) {
        this();
        this.parseFromReader(parent.createReader(filename));
    }

    public XMLElement(Reader r) {
        this();
        this.parseFromReader(r);
    }

    public XMLElement(String xml) {
        this();
        this.parseFromReader(new StringReader(xml));
    }

    protected void parseFromReader(Reader r) {
        try {
            StdXMLParser parser = new StdXMLParser();
            parser.setBuilder(new StdXMLBuilder(this));
            parser.setValidator(new XMLValidator());
            parser.setReader(new StdXMLReader(r));
            parser.parse();
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
    }

    public XMLElement createPCDataElement() {
        return new XMLElement();
    }

    public XMLElement createElement(String fullName, String namespace) {
        return new XMLElement(fullName, namespace, null, -1);
    }

    public XMLElement createElement(String fullName, String namespace, String systemID, int lineNr) {
        return new XMLElement(fullName, namespace, systemID, lineNr);
    }

    protected void finalize() throws Throwable {
        this.attributes.clear();
        this.attributes = null;
        this.children = null;
        this.fullName = null;
        this.name = null;
        this.namespace = null;
        this.content = null;
        this.systemID = null;
        this.parent = null;
        super.finalize();
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public String getName() {
        return this.fullName;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setName(String name) {
        this.name = name;
        this.fullName = name;
        this.namespace = null;
    }

    public void setName(String fullName, String namespace) {
        int index = fullName.indexOf(58);
        this.name = namespace == null || index < 0 ? fullName : fullName.substring(index + 1);
        this.fullName = fullName;
        this.namespace = namespace;
    }

    public void addChild(XMLElement child) {
        XMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getLocalName() == null && !this.children.isEmpty() && (lastChild = this.children.lastElement()).getLocalName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        child.parent = this;
        this.children.addElement(child);
    }

    public void insertChild(XMLElement child, int index) {
        XMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getLocalName() == null && !this.children.isEmpty() && (lastChild = this.children.lastElement()).getLocalName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        child.parent = this;
        this.children.insertElementAt(child, index);
    }

    public void removeChild(XMLElement child) {
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.removeElement(child);
    }

    public void removeChildAtIndex(int index) {
        this.children.removeElementAt(index);
    }

    public Enumeration<XMLElement> enumerateChildren() {
        return this.children.elements();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public String[] listChildren() {
        int childCount = this.getChildCount();
        String[] outgoing = new String[childCount];
        for (int i = 0; i < childCount; ++i) {
            outgoing[i] = this.getChild(i).getName();
        }
        return outgoing;
    }

    public XMLElement[] getChildren() {
        int childCount = this.getChildCount();
        Object[] kids = new XMLElement[childCount];
        this.children.copyInto(kids);
        return kids;
    }

    public XMLElement getChild(int index) {
        return this.children.elementAt(index);
    }

    public XMLElement getChild(String path) {
        if (path.indexOf(47) != -1) {
            return this.getChildRecursive(PApplet.split(path, '/'), 0);
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            XMLElement kid = this.getChild(i);
            String kidName = kid.getName();
            if (kidName == null || !kidName.equals(path)) continue;
            return kid;
        }
        return null;
    }

    protected XMLElement getChildRecursive(String[] items, int offset) {
        if (Character.isDigit(items[offset].charAt(0))) {
            XMLElement kid = this.getChild(Integer.parseInt(items[offset]));
            if (offset == items.length - 1) {
                return kid;
            }
            return kid.getChildRecursive(items, offset + 1);
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            XMLElement kid = this.getChild(i);
            String kidName = kid.getName();
            if (kidName == null || !kidName.equals(items[offset])) continue;
            if (offset == items.length - 1) {
                return kid;
            }
            return kid.getChildRecursive(items, offset + 1);
        }
        return null;
    }

    public XMLElement getChildAtIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.children.elementAt(index);
    }

    public XMLElement[] getChildren(String path) {
        if (path.indexOf(47) != -1) {
            return this.getChildrenRecursive(PApplet.split(path, '/'), 0);
        }
        if (Character.isDigit(path.charAt(0))) {
            return new XMLElement[]{this.getChild(Integer.parseInt(path))};
        }
        int childCount = this.getChildCount();
        XMLElement[] matches = new XMLElement[childCount];
        int matchCount = 0;
        for (int i = 0; i < childCount; ++i) {
            XMLElement kid = this.getChild(i);
            String kidName = kid.getName();
            if (kidName == null || !kidName.equals(path)) continue;
            matches[matchCount++] = kid;
        }
        return (XMLElement[])PApplet.subset(matches, 0, matchCount);
    }

    protected XMLElement[] getChildrenRecursive(String[] items, int offset) {
        if (offset == items.length - 1) {
            return this.getChildren(items[offset]);
        }
        XMLElement[] matches = this.getChildren(items[offset]);
        XMLElement[] outgoing = new XMLElement[]{};
        for (int i = 0; i < matches.length; ++i) {
            XMLElement[] kidMatches = matches[i].getChildrenRecursive(items, offset + 1);
            outgoing = (XMLElement[])PApplet.concat(outgoing, kidMatches);
        }
        return outgoing;
    }

    private XMLAttribute findAttribute(String fullName) {
        Enumeration<XMLAttribute> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            XMLAttribute attr = en.nextElement();
            if (!attr.getFullName().equals(fullName)) continue;
            return attr;
        }
        return null;
    }

    private XMLAttribute findAttribute(String name, String namespace) {
        Enumeration<XMLAttribute> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            XMLAttribute attr = en.nextElement();
            boolean found = attr.getName().equals(name);
            found = namespace == null ? (found &= attr.getNamespace() == null) : (found &= namespace.equals(attr.getNamespace()));
            if (!found) continue;
            return attr;
        }
        return null;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public String getAttribute(String name, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    public String getAttribute(String name, String namespace, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    public String getStringAttribute(String name) {
        return this.getAttribute(name);
    }

    public String getStringAttribute(String name, String defaultValue) {
        return this.getAttribute(name, defaultValue);
    }

    public String getStringAttribute(String name, String namespace, String defaultValue) {
        return this.getAttribute(name, namespace, defaultValue);
    }

    public int getIntAttribute(String name) {
        return this.getIntAttribute(name, 0);
    }

    public int getIntAttribute(String name, int defaultValue) {
        String value = this.getAttribute(name, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public int getIntAttribute(String name, String namespace, int defaultValue) {
        String value = this.getAttribute(name, namespace, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public float getFloatAttribute(String name) {
        return this.getFloatAttribute(name, 0.0f);
    }

    public float getFloatAttribute(String name, float defaultValue) {
        String value = this.getAttribute(name, Float.toString(defaultValue));
        return Float.parseFloat(value);
    }

    public float getFloatAttribute(String name, String namespace, float defaultValue) {
        String value = this.getAttribute(name, namespace, Float.toString(defaultValue));
        return Float.parseFloat(value);
    }

    public double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, 0.0);
    }

    public double getDoubleAttribute(String name, double defaultValue) {
        String value = this.getAttribute(name, Double.toString(defaultValue));
        return Double.parseDouble(value);
    }

    public double getDoubleAttribute(String name, String namespace, double defaultValue) {
        String value = this.getAttribute(name, namespace, Double.toString(defaultValue));
        return Double.parseDouble(value);
    }

    public String getAttributeType(String name) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getType();
    }

    public String getAttributeNamespace(String name) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getNamespace();
    }

    public String getAttributeType(String name, String namespace) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return null;
        }
        return attr.getType();
    }

    public void setAttribute(String name, String value) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            attr = new XMLAttribute(name, name, null, value, "CDATA");
            this.attributes.addElement(attr);
        } else {
            attr.setValue(value);
        }
    }

    public void setAttribute(String fullName, String namespace, String value) {
        int index = fullName.indexOf(58);
        String vorname = fullName.substring(index + 1);
        XMLAttribute attr = this.findAttribute(vorname, namespace);
        if (attr == null) {
            attr = new XMLAttribute(fullName, vorname, namespace, value, "CDATA");
            this.attributes.addElement(attr);
        } else {
            attr.setValue(value);
        }
    }

    public void removeAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute attr = this.attributes.elementAt(i);
            if (!attr.getFullName().equals(name)) continue;
            this.attributes.removeElementAt(i);
            return;
        }
    }

    public void removeAttribute(String name, String namespace) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute attr = this.attributes.elementAt(i);
            boolean found = attr.getName().equals(name);
            found = namespace == null ? (found &= attr.getNamespace() == null) : (found &= attr.getNamespace().equals(namespace));
            if (!found) continue;
            this.attributes.removeElementAt(i);
            return;
        }
    }

    public Enumeration<String> enumerateAttributeNames() {
        Vector<String> result = new Vector<String>();
        Enumeration<XMLAttribute> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            XMLAttribute attr = en.nextElement();
            result.addElement(attr.getFullName());
        }
        return result.elements();
    }

    public boolean hasAttribute(String name) {
        return this.findAttribute(name) != null;
    }

    public boolean hasAttribute(String name, String namespace) {
        return this.findAttribute(name, namespace) != null;
    }

    public Properties getAttributes() {
        Properties result = new Properties();
        Enumeration<XMLAttribute> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            XMLAttribute attr = en.nextElement();
            result.put(attr.getFullName(), attr.getValue());
        }
        return result;
    }

    public Properties getAttributesInNamespace(String namespace) {
        Properties result = new Properties();
        Enumeration<XMLAttribute> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            XMLAttribute attr = en.nextElement();
            if (namespace == null) {
                if (attr.getNamespace() != null) continue;
                result.put(attr.getName(), attr.getValue());
                continue;
            }
            if (!namespace.equals(attr.getNamespace())) continue;
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object rawElement) {
        try {
            return this.equalsXMLElement((XMLElement)rawElement);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean equalsXMLElement(XMLElement rawElement) {
        if (!this.name.equals(rawElement.getLocalName())) {
            return false;
        }
        if (this.attributes.size() != rawElement.getAttributeCount()) {
            return false;
        }
        Enumeration<XMLAttribute> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            XMLAttribute attr = en.nextElement();
            if (!rawElement.hasAttribute(attr.getName(), attr.getNamespace())) {
                return false;
            }
            String value = rawElement.getAttribute(attr.getName(), attr.getNamespace(), null);
            if (!attr.getValue().equals(value)) {
                return false;
            }
            String type = rawElement.getAttributeType(attr.getName(), attr.getNamespace());
            if (attr.getType().equals(type)) continue;
            return false;
        }
        if (this.children.size() != rawElement.getChildCount()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            XMLElement child2;
            XMLElement child1 = this.getChildAtIndex(i);
            if (child1.equalsXMLElement(child2 = rawElement.getChildAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean pretty) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(baos);
        XMLWriter writer = new XMLWriter(osw);
        try {
            if (pretty) {
                writer.write(this, true, 2, true);
            } else {
                writer.write(this, false, 0, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toString();
    }
}

