/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message.saaj;

import com.sun.xml.internal.bind.marshaller.SAX2DOMEx;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentEx;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.message.saaj.SaajStaxWriter;
import com.sun.xml.internal.ws.message.saaj.SAAJMessage;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class SAAJFactory {
    private static final SAAJFactory instance = new SAAJFactory();

    public static MessageFactory getMessageFactory(String string) throws SOAPException {
        for (SAAJFactory sAAJFactory : ServiceFinder.find(SAAJFactory.class)) {
            MessageFactory messageFactory = sAAJFactory.createMessageFactory(string);
            if (messageFactory == null) continue;
            return messageFactory;
        }
        return instance.createMessageFactory(string);
    }

    public static SOAPFactory getSOAPFactory(String string) throws SOAPException {
        for (SAAJFactory sAAJFactory : ServiceFinder.find(SAAJFactory.class)) {
            SOAPFactory sOAPFactory = sAAJFactory.createSOAPFactory(string);
            if (sOAPFactory == null) continue;
            return sOAPFactory;
        }
        return instance.createSOAPFactory(string);
    }

    public static Message create(SOAPMessage sOAPMessage) {
        for (SAAJFactory sAAJFactory : ServiceFinder.find(SAAJFactory.class)) {
            Message message = sAAJFactory.createMessage(sOAPMessage);
            if (message == null) continue;
            return message;
        }
        return instance.createMessage(sOAPMessage);
    }

    public static SOAPMessage read(SOAPVersion sOAPVersion, Message message) throws SOAPException {
        for (SAAJFactory sAAJFactory : ServiceFinder.find(SAAJFactory.class)) {
            SOAPMessage sOAPMessage = sAAJFactory.readAsSOAPMessage(sOAPVersion, message);
            if (sOAPMessage == null) continue;
            return sOAPMessage;
        }
        return instance.readAsSOAPMessage(sOAPVersion, message);
    }

    public static SOAPMessage read(SOAPVersion sOAPVersion, Message message, Packet packet) throws SOAPException {
        for (SAAJFactory sAAJFactory : ServiceFinder.find(SAAJFactory.class)) {
            SOAPMessage sOAPMessage = sAAJFactory.readAsSOAPMessage(sOAPVersion, message, packet);
            if (sOAPMessage == null) continue;
            return sOAPMessage;
        }
        return instance.readAsSOAPMessage(sOAPVersion, message, packet);
    }

    public static SAAJMessage read(Packet packet) throws SOAPException {
        ServiceFinder<SAAJFactory> serviceFinder = packet.component != null ? ServiceFinder.find(SAAJFactory.class, packet.component) : ServiceFinder.find(SAAJFactory.class);
        for (SAAJFactory sAAJFactory : serviceFinder) {
            SAAJMessage sAAJMessage = sAAJFactory.readAsSAAJ(packet);
            if (sAAJMessage == null) continue;
            return sAAJMessage;
        }
        return instance.readAsSAAJ(packet);
    }

    public SAAJMessage readAsSAAJ(Packet packet) throws SOAPException {
        SOAPVersion sOAPVersion = packet.getMessage().getSOAPVersion();
        SOAPMessage sOAPMessage = this.readAsSOAPMessage(sOAPVersion, packet.getMessage());
        return new SAAJMessage(sOAPMessage);
    }

    public MessageFactory createMessageFactory(String string) throws SOAPException {
        return MessageFactory.newInstance(string);
    }

    public SOAPFactory createSOAPFactory(String string) throws SOAPException {
        return SOAPFactory.newInstance(string);
    }

    public Message createMessage(SOAPMessage sOAPMessage) {
        return new SAAJMessage(sOAPMessage);
    }

    public SOAPMessage readAsSOAPMessage(SOAPVersion sOAPVersion, Message message) throws SOAPException {
        SOAPMessage sOAPMessage = sOAPVersion.getMessageFactory().createMessage();
        SaajStaxWriter saajStaxWriter = new SaajStaxWriter(sOAPMessage);
        try {
            message.writeTo(saajStaxWriter);
        }
        catch (XMLStreamException xMLStreamException) {
            throw xMLStreamException.getCause() instanceof SOAPException ? (SOAPException)xMLStreamException.getCause() : new SOAPException(xMLStreamException);
        }
        sOAPMessage = saajStaxWriter.getSOAPMessage();
        SAAJFactory.addAttachmentsToSOAPMessage(sOAPMessage, message);
        if (sOAPMessage.saveRequired()) {
            sOAPMessage.saveChanges();
        }
        return sOAPMessage;
    }

    public SOAPMessage readAsSOAPMessageSax2Dom(SOAPVersion sOAPVersion, Message message) throws SOAPException {
        SOAPMessage sOAPMessage = sOAPVersion.getMessageFactory().createMessage();
        SAX2DOMEx sAX2DOMEx = new SAX2DOMEx(sOAPMessage.getSOAPPart());
        try {
            message.writeTo(sAX2DOMEx, XmlUtil.DRACONIAN_ERROR_HANDLER);
        }
        catch (SAXException sAXException) {
            throw new SOAPException(sAXException);
        }
        SAAJFactory.addAttachmentsToSOAPMessage(sOAPMessage, message);
        if (sOAPMessage.saveRequired()) {
            sOAPMessage.saveChanges();
        }
        return sOAPMessage;
    }

    protected static void addAttachmentsToSOAPMessage(SOAPMessage sOAPMessage, Message message) {
        for (Attachment attachment : message.getAttachments()) {
            AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
            attachmentPart.setDataHandler(attachment.asDataHandler());
            String string = attachment.getContentId();
            if (string != null) {
                if (string.startsWith("<") && string.endsWith(">")) {
                    attachmentPart.setContentId(string);
                } else {
                    attachmentPart.setContentId('<' + string + '>');
                }
            }
            if (attachment instanceof AttachmentEx) {
                AttachmentEx attachmentEx = (AttachmentEx)attachment;
                Iterator<AttachmentEx.MimeHeader> iterator = attachmentEx.getMimeHeaders();
                while (iterator.hasNext()) {
                    AttachmentEx.MimeHeader mimeHeader = iterator.next();
                    if ("Content-ID".equals(mimeHeader.getName()) || "Content-Type".equals(mimeHeader.getName())) continue;
                    attachmentPart.addMimeHeader(mimeHeader.getName(), mimeHeader.getValue());
                }
            }
            sOAPMessage.addAttachmentPart(attachmentPart);
        }
    }

    public SOAPMessage readAsSOAPMessage(SOAPVersion sOAPVersion, Message message, Packet packet) throws SOAPException {
        return this.readAsSOAPMessage(sOAPVersion, message);
    }
}

