/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.xml.internal.ws.server.ServerRtException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

final class ServerMgr {
    private static final ServerMgr serverMgr = new ServerMgr();
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.server.http");
    private final Map<InetSocketAddress, ServerState> servers = new HashMap<InetSocketAddress, ServerState>();

    private ServerMgr() {
    }

    static ServerMgr getInstance() {
        return serverMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpContext createContext(String string) {
        try {
            ServerState serverState;
            URL uRL = new URL(string);
            int n = uRL.getPort();
            if (n == -1) {
                n = uRL.getDefaultPort();
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(uRL.getHost(), n);
            Object object = this.servers;
            synchronized (object) {
                serverState = this.servers.get(inetSocketAddress);
                if (serverState == null) {
                    logger.fine("Creating new HTTP Server at " + inetSocketAddress);
                    HttpServer httpServer = HttpServer.create(inetSocketAddress, 0);
                    httpServer.setExecutor(Executors.newCachedThreadPool());
                    String string2 = uRL.toURI().getPath();
                    logger.fine("Creating HTTP Context at = " + string2);
                    HttpContext httpContext = httpServer.createContext(string2);
                    httpServer.start();
                    inetSocketAddress = httpServer.getAddress();
                    logger.fine("HTTP server started = " + inetSocketAddress);
                    serverState = new ServerState(httpServer, string2);
                    this.servers.put(inetSocketAddress, serverState);
                    return httpContext;
                }
            }
            HttpServer httpServer = serverState.getServer();
            if (serverState.getPaths().contains(uRL.getPath())) {
                object = "Context with URL path " + uRL.getPath() + " already exists on the server " + httpServer.getAddress();
                logger.fine((String)object);
                throw new IllegalArgumentException((String)object);
            }
            logger.fine("Creating HTTP Context at = " + uRL.getPath());
            object = httpServer.createContext(uRL.getPath());
            serverState.oneMoreContext(uRL.getPath());
            return object;
        }
        catch (Exception exception) {
            throw new ServerRtException("server.rt.err", new Object[]{exception});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContext(HttpContext httpContext) {
        InetSocketAddress inetSocketAddress = httpContext.getServer().getAddress();
        Map<InetSocketAddress, ServerState> map = this.servers;
        synchronized (map) {
            ServerState serverState = this.servers.get(inetSocketAddress);
            int n = serverState.noOfContexts();
            if (n < 2) {
                ((ExecutorService)serverState.getServer().getExecutor()).shutdown();
                serverState.getServer().stop(0);
                this.servers.remove(inetSocketAddress);
            } else {
                serverState.getServer().removeContext(httpContext);
                serverState.oneLessContext(httpContext.getPath());
            }
        }
    }

    private static final class ServerState {
        private final HttpServer server;
        private int instances;
        private Set<String> paths = new HashSet<String>();

        ServerState(HttpServer httpServer, String string) {
            this.server = httpServer;
            this.instances = 1;
            this.paths.add(string);
        }

        public HttpServer getServer() {
            return this.server;
        }

        public void oneMoreContext(String string) {
            ++this.instances;
            this.paths.add(string);
        }

        public void oneLessContext(String string) {
            --this.instances;
            this.paths.remove(string);
        }

        public int noOfContexts() {
            return this.instances;
        }

        public Set<String> getPaths() {
            return this.paths;
        }
    }
}

