// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file LaserScan.h
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifndef _LaserScan_H_
#define _LaserScan_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdint.h>
#include <stdbool.h>
#include "Header.h"

/*!
 * @brief This struct represents the structure LaserScan defined by the user in the IDL file.
 * @ingroup LASERSCAN
 */
typedef struct LaserScan
{
    Header header;
    float angle_min;
    float angle_max;
    float angle_increment;
    float time_increment;
    float scan_time;
    float range_min;
    float range_max;
    float ranges[360];
    uint32_t ranges_size;
    float intensities[360];
    uint32_t intensities_size;
} LaserScan;

struct ucdrBuffer;

bool LaserScan_serialize_topic(struct ucdrBuffer* writer, const LaserScan* topic);
bool LaserScan_deserialize_topic(struct ucdrBuffer* reader, LaserScan* topic);
uint32_t LaserScan_size_of_topic(const LaserScan* topic, uint32_t size);


#ifdef __cplusplus
}
#endif

#endif // _LaserScan_H_