/* Arduino Tutorial 03 for FlashAir
 * Copyright (C) 2014 by Munehiro Doi, Fixstars Corporation
 *
 * This Library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the Arduino Sd2Card Library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <SPI.h>
#include <iSdio.h>
#include <utility/Sd2CardExt.h>

const int chipSelectPin = 4;
Sd2CardExt card;
uint8_t buffer[512];
#define DELAY 50

void printByte(uint8_t value) {
  Serial.print(value >> 4, HEX);
  Serial.print(value & 0xF, HEX);
}

void printBytes(uint8_t* p, uint32_t len) {
  for (int i = 0; i < len; ++i) {
    printByte(p[i]);
  }
}

void printIPAddress(uint8_t* p) {
  Serial.print(p[0], DEC);
  Serial.print('.');
  Serial.print(p[1], DEC);
  Serial.print('.');
  Serial.print(p[2], DEC);
  Serial.print('.');
  Serial.print(p[3], DEC);
}

boolean iSDIO_status() {
  Serial.print(F("\nRead iSDIO Status Register"));
  delay(DELAY); // For waiting transfering
  // Read iSDIO Status Register (E7 1.10 2.2.2.1)
  memset(buffer, 0, 0x200);
  if (!card.readExtMemory(1, 1, 0x400, 0x200, buffer)) {
    return false;
  }
  // Show values in the common status area.
  Serial.print(F("\n == iSDIO Status Registers == "));
  delay(DELAY); // For waiting transfering
  Serial.print(F("\n [0400h] Command Write Status: "));
  delay(DELAY); // For waiting transfering
  if (buffer[0x000] & 0x01) Serial.print(F("CWU "));
  if (buffer[0x000] & 0x02) Serial.print(F("CWA "));
  Serial.print(F("\n [0420h] iSDIO Status: "));
  delay(DELAY); // For waiting transfering
  if (buffer[0x020] & 0x01) Serial.print(F("CRU "));
  if (buffer[0x020] & 0x02) Serial.print(F("ESU "));
  if (buffer[0x020] & 0x04) Serial.print(F("MCU "));
  if (buffer[0x020] & 0x08) Serial.print(F("ASU "));
  Serial.print(F("\n [0422h] iSDIO Int Enable: "));
  delay(DELAY); // For waiting transfering
  if (buffer[0x022] & 0x01) Serial.print(F("CRU_ENA "));
  if (buffer[0x022] & 0x02) Serial.print(F("ESU_ENA "));
  if (buffer[0x022] & 0x04) Serial.print(F("MCU_ENA "));
  if (buffer[0x022] & 0x08) Serial.print(F("ASU_ENA "));
  Serial.print(F("\n [0424h] Error Status: "));
  delay(DELAY); // For waiting transfering
  if (buffer[0x024] & 0x01) Serial.print(F("CRE "));
  if (buffer[0x024] & 0x02) Serial.print(F("CWE "));
  if (buffer[0x024] & 0x04) Serial.print(F("RRE "));
  if (buffer[0x024] & 0x08) Serial.print(F("APE "));
  Serial.print(F("\n [0426h] Memory Status: "));
  delay(DELAY); // For waiting transfering
  if (buffer[0x026] & 0x01) Serial.print(F("MEX "));
  if (buffer[0x026] & 0x02) Serial.print(F("FAT "));
  for (int i = 0; i < 8; ++i) {
    uint8_t addr = 0x40 + i * 0x14;
    Serial.print(F("\n [04"));
    delay(DELAY); // For waiting transfering
    printByte(addr);
    Serial.print(F("h] Command Response Status #"));
    Serial.print(i + 1, DEC);
    Serial.print(F(": "));
    if (buffer[addr] & 0x01) {
      Serial.print(F("id = "));
      Serial.print(get_u16(buffer + addr + 2), DEC);
      Serial.print(F(", sequence id = "));
      Serial.print(get_u32(buffer + addr + 4), DEC);
      Serial.print(F(", status = "));
      switch (buffer[addr + 8]) {
        case 0x00: Serial.print(F("Initial")); break;
        case 0x01: Serial.print(F("Command Processing")); break;
        case 0x02: Serial.print(F("Command Rejected")); break;
        case 0x03: Serial.print(F("Process Succeeded")); break;
        case 0x04: Serial.print(F("Process Terminated")); break;
        default:   Serial.print(F("Process Failed ")); Serial.print(buffer[addr + 8], HEX); break;
      }
    } else {
      Serial.print(F("Not registered"));
    }
  }
  // Show values in the application status area.
  Serial.print(F("\n == Wireless LAN Status Registers =="));
  delay(DELAY); // For waiting transfering
  Serial.print(F("\n [0500h] DLNA Status: "));
  delay(DELAY); // For waiting transfering
  if (buffer[0x100] & 0x01) Serial.print(F("ULR "));
  if (buffer[0x100] & 0x02) Serial.print(F("DLU "));
  if (buffer[0x100] & 0x04) Serial.print(F("CBR "));
  if (buffer[0x100] & 0x08) Serial.print(F("CDR "));
  Serial.print(F("\n [0501h] P2P Status: "));
  delay(DELAY); // For waiting transfering
  if (buffer[0x101] & 0x01) Serial.print(F("ILU "));
  if (buffer[0x101] & 0x02) Serial.print(F("FLU "));
  Serial.print(F("\n [0502h] PTP Status: "));
  delay(DELAY); // For waiting transfering
  if (buffer[0x102] & 0x01) Serial.print(F("RPO "));
  if (buffer[0x102] & 0x02) Serial.print(F("RPD "));
  if (buffer[0x102] & 0x04) Serial.print(F("RPC "));
  if (buffer[0x102] & 0x08) Serial.print(F("CPI "));
  if (buffer[0x102] & 0x10) Serial.print(F("DPI "));
  if (buffer[0x102] & 0x20) Serial.print(F("CIL "));
  Serial.print(F("\n [0504h] Application: "));
  delay(DELAY); // For waiting transfering
  Serial.print(buffer[0x104]);
  Serial.print(F("\n [0506h] WLAN: "));
  delay(DELAY); // For waiting transfering
  if ((buffer[0x106] & 0x01) == 0x00) Serial.print(F("No Scan, "));
  if ((buffer[0x106] & 0x01) == 0x01) Serial.print(F("Scanning, "));
  if ((buffer[0x106] & 0x06) == 0x00) Serial.print(F("No WPS, "));
  if ((buffer[0x106] & 0x06) == 0x02) Serial.print(F("WPS with PIN, "));
  if ((buffer[0x106] & 0x06) == 0x04) Serial.print(F("WPS with PBC, "));
  if ((buffer[0x106] & 0x08) == 0x00) Serial.print(F("Group Client, "));
  if ((buffer[0x106] & 0x08) == 0x08) Serial.print(F("Group Owner "));
  if ((buffer[0x106] & 0x10) == 0x00) Serial.print(F("STA, "));
  if ((buffer[0x106] & 0x10) == 0x10) Serial.print(F("AP, "));
  if ((buffer[0x106] & 0x60) == 0x00) Serial.print(F("Initial, "));
  if ((buffer[0x106] & 0x60) == 0x20) Serial.print(F("Infrastructure, "));
  if ((buffer[0x106] & 0x60) == 0x40) Serial.print(F("Wi-Fi Direct, "));
  if ((buffer[0x106] & 0x80) == 0x00) Serial.print(F("No Connection, "));
  if ((buffer[0x106] & 0x80) == 0x80) Serial.print(F("Connected, "));
  Serial.print(F("\n [0508h] SSID: "));
  delay(DELAY); // For waiting transfering
  for (int i = 0; i < 32 && buffer[0x108 + i] != 0; ++i) { 
    Serial.print((char)buffer[0x108 + i]);
  }
  Serial.print(F("\n [0528h] Encryption Mode: "));
  delay(DELAY); // For waiting transfering
  switch (buffer[0x128]) {
    case 0 : Serial.print(F("Open System and no encryption")); break;
    case 1 : Serial.print(F("Open System and WEP")); break;
    case 2 : Serial.print(F("Shared Key and WEP")); break;
    case 3 : Serial.print(F("WPA-PSK and TKIP")); break;
    case 4 : Serial.print(F("WPA-PSK and AES")); break;
    case 5 : Serial.print(F("WPA2-PSK and TKIP")); break;
    case 6 : Serial.print(F("WPA2-PSK and AES")); break;
    default: Serial.print(F("Unknown"));
  }
  Serial.print(F("\n [0529h] Signal Strength: "));
  delay(DELAY); // For waiting transfering
  Serial.print(buffer[0x129], DEC);
  Serial.print(F("\n [052Ah] Channel: "));
  delay(DELAY); // For waiting transfering
  if (buffer[0x12A] == 0) Serial.print(F("No connection"));
  else Serial.print(buffer[0x12A], DEC);
  Serial.print(F("\n [0530h] MAC Address: "));
  delay(DELAY); // For waiting transfering
  printBytes(buffer + 0x130, 6);
  Serial.print(F("\n [0540h] ID: "));
  delay(DELAY); // For waiting transfering
  for (int i = 0; i < 16 && buffer[0x140 + i] != 0; ++i) { 
    Serial.print((char)buffer[0x140 + i]);
  }
  Serial.print(F("\n [0550h] IP Address: "));
  delay(DELAY); // For waiting transfering
  printIPAddress(buffer + 0x150);
  Serial.print(F("\n [0554h] Subnet Mask: "));
  delay(DELAY); // For waiting transfering
  printIPAddress(buffer + 0x154);
  Serial.print(F("\n [0558h] Default Gateway: "));
  delay(DELAY); // For waiting transfering
  printIPAddress(buffer + 0x158);
  Serial.print(F("\n [055Ch] Preferred DNS Server: "));
  delay(DELAY); // For waiting transfering
  printIPAddress(buffer + 0x15C);
  Serial.print(F("\n [0560h] Alternate DNS Server: "));
  delay(DELAY); // For waiting transfering
  printIPAddress(buffer + 0x160);
  Serial.print(F("\n [0564h] Proxy Server: "));
  delay(DELAY); // For waiting transfering
  if ((buffer[0x164] & 0x01) == 0x00) Serial.print(F("Disabled"));
  if ((buffer[0x164] & 0x01) == 0x01) Serial.print(F("Enabled"));
  Serial.print(F("\n [0570h] Date: "));
  delay(DELAY); // For waiting transfering
  Serial.print(buffer[0x171] + 1980, DEC); Serial.print('-');
  Serial.print(buffer[0x170] >> 4, DEC); Serial.print('-');
  Serial.print(buffer[0x170] & 0xF, DEC);
  Serial.print(F("\n [0572h] Time: "));
  delay(DELAY); // For waiting transfering
  Serial.print(buffer[0x173] >> 3, DEC); Serial.print(':');
  Serial.print(buffer[0x172] << 3 | buffer[0x170] >> 3, DEC); Serial.print(':');
  Serial.print((buffer[0x172] & 0x1F) * 2, DEC);
  Serial.print(F("\n [0574h] HTTP Status: "));
  delay(DELAY); // For waiting transfering
  Serial.print(buffer[0x174] & 0xEF, DEC);
  if ((buffer[0x174] & 0x80) == 0x00) Serial.print(F(" (No Processing)"));
  if ((buffer[0x174] & 0x80) == 0x80) Serial.print(F(" (Processing)"));
  Serial.print(F("\n [0575h] Power Save Management: "));
  delay(DELAY); // For waiting transfering
  if ((buffer[0x175] & 0x01) == 0x00) Serial.print(F("Power Save Mode Off"));
  if ((buffer[0x175] & 0x01) == 0x01) Serial.print(F("Power Save Mode On"));
  Serial.print(F("\n [0576h] File System Management: "));
  delay(DELAY); // For waiting transfering
  if ((buffer[0x176] & 0x01) == 0x00) Serial.print(F("FS Information may be modified"));
  if ((buffer[0x176] & 0x01) == 0x01) Serial.print(F("FS Information shall not be modified"));
  Serial.println();
  
  return true;
}

void setup() {
  // Initialize UART for message print.
  Serial.begin(9600);
  while (!Serial) {
    ;
  }
  
  // Initialize SD card.
  Serial.print(F("\nInitializing SD card..."));  
  delay(DELAY); // For waiting transfering
  if (card.init(SPI_HALF_SPEED, chipSelectPin)) {
    Serial.print(F("OK"));
  } else {
    Serial.print(F("NG"));
    abort();
  }

  if (iSDIO_status()) {
    Serial.print(F("\nOK"));
  } else {
    Serial.println(F("\nFailed to read status."));
  }
}

void loop() {
}
