/*
 This sample enables to take a photo that include moving detection. 
 After taking a photo, the photo will be compressed to JPEG file and 
 then saved to SD card. 
 Hardware: GR-KAEDE, camera option and SD. Also USB cable and PC.
 note: This sample needs to install USB driver for GR-KAEDE
       The USB driver is in the project folder just you created.
       Also you need to install a terminal software like Teraterm.
*/
 
#include <Arduino.h>
#include "Wire.h"
#include "Image.h"
#include "SPI.h"
#include "SD.h"
#include "RTC.h"
 
Image image[3];
RTC_TIMETYPE t;
void dateTime(uint16_t* date, uint16_t* time);
 
void setup(){
    Serial.begin(9600);
    Serial.println("start");
 
    if(!SD.begin()){
        Serial.println("Failed to access SD.");
    } else {
        Serial.println("Success to access SD.");
    }
 
    // RTC for time stamp in SD
    rtc_init();
    t.year = 15;
    t.mon = 9;
    t.day = 2;
    t.weekday = RTC_WEEK_WEDNESDAY;
    t.hour = 17;
    t.min = 0;
    t.second = 0;
    rtc_set_time(&t);
 
    SdFile::dateTimeCallback( &dateTime );
 
    // Initialize Image library
    Serial.println("Initializing a camera..");
    image[0].begin();
 
}
 
void loop(){
 
    static int cnt = 0;
 
    while(cnt < 2){ //necessary at least two image in the past.
        image[cnt].captureStart();
        while(!image[cnt].isCaptureFinished());
        image[cnt].createGrayImage();
        cnt++;
    }
     
    Serial.println("Capturing image");
    image[cnt%3].captureStart();
    while(!image[cnt%3].isCaptureFinished());
    image[cnt%3].createGrayImage();
     
    // Moving detection
    if( 0 == image[cnt%3].movingDetection(image[(cnt-2)%3].getCreatedGrayImage(), image[(cnt-1)%3].getCreatedGrayImage())){
        Serial.println("finish detection");
        Serial.print("Moving Number is:");
        Serial.println(image[cnt%3].getMovingNumber());
        Serial.print("The biggest moving is in area:");
        Serial.println(image[cnt%3].getMovingArea(0));
    }
    image[cnt%3].createJpg();
 
    Serial.println("Write jpg to SD:");
 
    char fn[20];
    sprintf (fn, "test%d.jpg", (cnt-2));
    File file = SD.open(fn, FILE_WRITE);
    uint8_t* adr = image[cnt%3].getCreatedJpg();
    int32_t size = image[cnt%3].getCreatedJpgSize();
    for (int i = 0; i < size; i++){
        file.write(*adr);
        adr++;
    }
    file.close();
    Serial.println("Done.");
    cnt++;
}
 
void dateTime(uint16_t* date, uint16_t* time)
{
  rtc_get_time(&t);
 
  *date = FAT_DATE(t.year+2000, t.mon, t.day);
  *time = FAT_TIME(t.hour, t.min, t.second);
}