// Sample program for GR-LYCHEE and GR-PEACH
// Display camera image after canny on LCD
// Public domain

#include <Arduino.h>
#include <Camera.h>
#include <LCD.h>
#include <opencv.hpp>

#define IMAGE_HW 480
#define IMAGE_VW 272
Camera camera(IMAGE_HW, IMAGE_VW);
//Camera camera(IMAGE_HW, IMAGE_VW, 0); // specify 0 for CVBS with GR-PEACH
//Camera camera(IMAGE_HW, IMAGE_VW, 2); // specify 2 for Wireless Camera shield
LCD lcd(IMAGE_HW, IMAGE_VW);
static uint8_t lcd_buf[IMAGE_HW * IMAGE_VW * 2]; // 2 bytes per pixel

using namespace cv;

void setup() {
  camera.begin();
  lcd.begin(lcd_buf, IMAGE_HW, IMAGE_VW);
  lcd.clear();
}

void loop() {
  Mat img_raw(IMAGE_VW, IMAGE_HW, CV_8UC2, camera.getImageAdr());
  Mat src, dst;
  cvtColor(img_raw, src, COLOR_YUV2GRAY_YUY2); // convert YUV to GRAY
  Canny(src, dst, 50, 150); // Canny
  lcd.GRAY2YUV(dst.data, lcd_buf, IMAGE_HW, IMAGE_VW);
  delay(10);
}
